/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.SingletonFileTree;
import org.gradle.api.resources.ResourceException;
import org.gradle.api.resources.internal.ReadableResourceInternal;
import org.gradle.internal.IoActions;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.nativeintegration.filesystem.Chmod;
import org.gradle.internal.nativeintegration.filesystem.Stat;
import org.gradle.util.GFileUtils;

public class TarFileTree
implements MinimalFileTree,
FileSystemMirroringFileTree {
    private final File tarFile;
    private final ReadableResourceInternal resource;
    private final Chmod chmod;
    private final Stat stat;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final File tmpDir;
    private final StreamHasher streamHasher;
    private final FileHasher fileHasher;

    public TarFileTree(@Nullable File tarFile, ReadableResourceInternal resource, File tmpDir, Chmod chmod, Stat stat, DirectoryFileTreeFactory directoryFileTreeFactory, StreamHasher streamHasher, FileHasher fileHasher) {
        this.tarFile = tarFile;
        this.resource = resource;
        this.chmod = chmod;
        this.stat = stat;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.tmpDir = tmpDir;
        this.streamHasher = streamHasher;
        this.fileHasher = fileHasher;
    }

    @Override
    public String getDisplayName() {
        return String.format("TAR '%s'", this.resource.getDisplayName());
    }

    @Override
    public DirectoryFileTree getMirror() {
        return this.directoryFileTreeFactory.create(this.getExpandedDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(FileVisitor visitor) {
        BufferedInputStream inputStream;
        try {
            inputStream = new BufferedInputStream(this.resource.read());
        }
        catch (ResourceException e) {
            throw this.cannotExpand((Exception)((Object)e));
        }
        try {
            try {
                this.visitImpl(visitor, inputStream);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception e) {
            String message = "Unable to expand " + this.getDisplayName() + "\n" + "  The tar might be corrupted or it is compressed in an unexpected way.\n" + "  By default the tar tree tries to guess the compression based on the file extension.\n" + "  If you need to specify the compression explicitly please refer to the DSL reference.";
            throw new GradleException(message, (Throwable)e);
        }
    }

    private void visitImpl(FileVisitor visitor, InputStream inputStream) throws IOException {
        TarEntry entry;
        AtomicBoolean stopFlag = new AtomicBoolean();
        NoCloseTarInputStream tar = new NoCloseTarInputStream(inputStream);
        File expandedDir = this.getExpandedDir();
        while (!stopFlag.get() && (entry = tar.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                visitor.visitDir((FileVisitDetails)new DetailsImpl(this.resource, expandedDir, entry, tar, stopFlag, this.chmod));
                continue;
            }
            visitor.visitFile((FileVisitDetails)new DetailsImpl(this.resource, expandedDir, entry, tar, stopFlag, this.chmod));
        }
    }

    private File getBackingFile() {
        if (this.tarFile != null) {
            return this.tarFile;
        }
        return this.resource.getBackingFile();
    }

    private File getExpandedDir() {
        HashCode fileHash = this.tarFile != null ? this.hashFile(this.tarFile) : this.hashResource(this.resource);
        String expandedDirName = this.resource.getBaseName() + "_" + fileHash;
        return new File(this.tmpDir, expandedDirName);
    }

    private HashCode hashFile(File tarFile) {
        try {
            return this.fileHasher.hash(tarFile);
        }
        catch (Exception e) {
            throw this.cannotExpand(e);
        }
    }

    private HashCode hashResource(ReadableResourceInternal resource) {
        HashCode hashCode;
        BufferedInputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(resource.read());
            hashCode = this.streamHasher.hash((InputStream)inputStream);
        }
        catch (ResourceException e) {
            try {
                throw this.cannotExpand((Exception)((Object)e));
            }
            catch (Throwable throwable) {
                IoActions.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IoActions.closeQuietly((Closeable)inputStream);
        return hashCode;
    }

    private RuntimeException cannotExpand(Exception e) {
        throw new InvalidUserDataException(String.format("Cannot expand %s.", this.getDisplayName()), (Throwable)e);
    }

    @Override
    public void registerWatchPoints(FileSystemSubset.Builder builder) {
        File backingFile = this.getBackingFile();
        if (backingFile != null) {
            builder.add(backingFile);
        }
    }

    @Override
    public void visitTreeOrBackingFile(final FileVisitor visitor) {
        File backingFile = this.getBackingFile();
        if (backingFile != null) {
            new SingletonFileTree(backingFile).visit(visitor);
        } else {
            this.visit(new FileVisitor(){
                private final AtomicBoolean stopFlag = new AtomicBoolean();

                public void visitDir(FileVisitDetails dirDetails) {
                    visitor.visitDir((FileVisitDetails)new DefaultFileVisitDetails(dirDetails.getFile(), dirDetails.getRelativePath(), this.stopFlag, TarFileTree.this.chmod, TarFileTree.this.stat));
                }

                public void visitFile(FileVisitDetails fileDetails) {
                    visitor.visitFile((FileVisitDetails)new DefaultFileVisitDetails(fileDetails.getFile(), fileDetails.getRelativePath(), this.stopFlag, TarFileTree.this.chmod, TarFileTree.this.stat));
                }
            });
        }
    }

    private static class NoCloseTarInputStream
    extends TarInputStream {
        public NoCloseTarInputStream(InputStream is) {
            super(is);
        }

        public void close() throws IOException {
        }

        public TarEntry getCurrent() {
            return this.currEntry;
        }
    }

    private static class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final TarEntry entry;
        private final NoCloseTarInputStream tar;
        private final AtomicBoolean stopFlag;
        private final ReadableResourceInternal resource;
        private final File expandedDir;
        private File file;
        private boolean read;

        public DetailsImpl(ReadableResourceInternal resource, File expandedDir, TarEntry entry, NoCloseTarInputStream tar, AtomicBoolean stopFlag, Chmod chmod) {
            super(chmod);
            this.resource = resource;
            this.expandedDir = expandedDir;
            this.entry = entry;
            this.tar = tar;
            this.stopFlag = stopFlag;
        }

        @Override
        public String getDisplayName() {
            return String.format("tar entry %s!%s", this.resource.getDisplayName(), this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(this.expandedDir, this.entry.getName());
                if (!this.file.exists()) {
                    this.copyTo(this.file);
                }
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getModTime().getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            if (this.read && this.file != null) {
                return GFileUtils.openInputStream((File)this.file);
            }
            if (this.read || this.tar.getCurrent() != this.entry) {
                throw new UnsupportedOperationException(String.format("The contents of %s has already been read.", this));
            }
            this.read = true;
            return this.tar;
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.entry.getName().split("/"));
        }

        @Override
        public int getMode() {
            return this.entry.getMode() & 0x1FF;
        }
    }
}

