/*
 * Decompiled with CFR 0.152.
 */
package net.daimonin.client3d.editor.util.binpacker;

public class Rect
implements Comparable {
    int x;
    int y;
    int w;
    int h;
    String id;
    static final String ID_DEAULT = "invalid";
    private int[] children = new int[2];
    boolean rotated;
    boolean packed;

    public Rect(String id, int w, int h) {
        this(id, 0, 0, w, h, false, false);
    }

    Rect(String id, int x, int y, int w, int h, boolean rotated, boolean packed) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.rotated = rotated;
        this.packed = packed;
        this.children[0] = -1;
        this.children[1] = -1;
    }

    Rect(Rect rect) {
        this.id = rect.id;
        this.x = rect.x;
        this.y = rect.y;
        this.w = rect.w;
        this.h = rect.h;
        this.children = rect.children;
        this.packed = rect.packed;
        this.rotated = rect.rotated;
    }

    final int getArea() {
        return this.w * this.h;
    }

    final void rotate() {
        int tmp = this.h;
        this.h = this.w;
        this.w = tmp;
        this.rotated = !this.rotated;
    }

    final int[] getChildren() {
        return this.children;
    }

    final void setChildren(int c1, int c2) {
        this.children = new int[]{c1, c2};
    }

    public final String toString() {
        return String.valueOf(this.id) + "/" + this.x + "/" + this.y + "/" + this.w + "/" + this.h + "/" + this.rotated + "/" + this.packed + " (ID/x/y/w/h/rotated/packed)";
    }

    public final int compareTo(Object rect) {
        Rect other = (Rect)rect;
        if (this.getArea() > other.getArea()) {
            return 1;
        }
        if (this.getArea() < other.getArea()) {
            return -1;
        }
        return 0;
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rect)) {
            return false;
        }
        Rect o = (Rect)obj;
        if (this.id == null || o.id == null) {
            return false;
        }
        return o.id.equals(this.id);
    }

    public final String getId() {
        return this.id;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }
}

