/*
 * Decompiled with CFR 0.152.
 */
package JTrrntzip;

import JTrrntzip.LogCallback;
import JTrrntzip.Messages;
import JTrrntzip.SupportedFiles.ICompress;
import JTrrntzip.SupportedFiles.ZipFile.ZipFile;
import JTrrntzip.TorrentZipCheck;
import JTrrntzip.TorrentZipOptions;
import JTrrntzip.TorrentZipRebuild;
import JTrrntzip.TrrntZipStatus;
import JTrrntzip.ZipReturn;
import JTrrntzip.ZipStatus;
import JTrrntzip.ZippedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class TorrentZip {
    private final LogCallback statusLogCallBack;
    private final TorrentZipOptions options;
    private final byte[] buffer;

    public TorrentZip(LogCallback statusLogCallBack, TorrentZipOptions options) {
        this.statusLogCallBack = statusLogCallBack;
        this.options = options;
        this.buffer = new byte[8192];
    }

    public final EnumSet<TrrntZipStatus> Process(File f) throws IOException {
        if (this.statusLogCallBack.isVerboseLogging()) {
            this.statusLogCallBack.StatusLogCallBack("");
        }
        this.statusLogCallBack.StatusLogCallBack(f.getName() + " - ");
        AtomicReference<ICompress> zipFile = new AtomicReference<ICompress>();
        EnumSet<TrrntZipStatus> tzs = this.OpenZip(f, zipFile);
        if (tzs.contains(TrrntZipStatus.CorruptZip)) {
            this.statusLogCallBack.StatusLogCallBack(Messages.getString("TorrentZip.ZipFileCorrupt"));
            return tzs;
        }
        List<ZippedFile> zippedFiles = this.ReadZipContent(zipFile.get());
        tzs.addAll(TorrentZipCheck.CheckZipFiles(zippedFiles, this.statusLogCallBack));
        if (tzs.contains(TrrntZipStatus.ValidTrrntzip) && !this.options.isForceRezip()) {
            this.statusLogCallBack.StatusLogCallBack(Messages.getString("TorrentZip.SkippingFile"));
            zipFile.get().ZipFileClose();
            return tzs;
        }
        if (this.options.isCheckOnly()) {
            this.statusLogCallBack.StatusLogCallBack(tzs.toString());
            zipFile.get().ZipFileClose();
            return tzs;
        }
        this.statusLogCallBack.StatusLogCallBack(Messages.getString("TorrentZip.TorrentZipping"));
        EnumSet<TrrntZipStatus> fixedTzs = TorrentZipRebuild.ReZipFiles(zippedFiles, zipFile.get(), this.buffer, this.statusLogCallBack);
        return fixedTzs;
    }

    private final EnumSet<TrrntZipStatus> OpenZip(File f, AtomicReference<ICompress> zipFile) throws IOException {
        zipFile.set(new ZipFile());
        ZipReturn zr = zipFile.get().ZipFileOpen(f, f.lastModified(), true);
        if (zr != ZipReturn.ZipGood) {
            return EnumSet.of(TrrntZipStatus.CorruptZip);
        }
        EnumSet<TrrntZipStatus> tzStatus = EnumSet.noneOf(TrrntZipStatus.class);
        if (zipFile.get().ZipStatus().contains((Object)ZipStatus.TrrntZip)) {
            tzStatus.add(TrrntZipStatus.ValidTrrntzip);
        }
        return tzStatus;
    }

    private final List<ZippedFile> ReadZipContent(final ICompress zipFile) {
        ArrayList<ZippedFile> zippedFiles = new ArrayList<ZippedFile>();
        int i = 0;
        while (i < zipFile.LocalFilesCount()) {
            final int ii = i++;
            zippedFiles.add(new ZippedFile(){
                {
                    this.Index = ii;
                    this.Name = zipFile.Filename(ii);
                    this.setCRC(zipFile.CRC32(ii));
                    this.Size = zipFile.UncompressedSize(ii);
                }
            });
        }
        return zippedFiles;
    }
}

