/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.Datum;
import oracle.sql.TypeDescriptor;

public abstract class OracleNamedType
extends OracleType
implements Serializable {
    transient OracleConnection m_conn;
    transient boolean m_hasName;
    String m_fullName;
    transient String m_schemaName;
    transient String m_typeName;
    transient OracleTypeADT m_parent;
    transient int m_idx;
    transient TypeDescriptor m_descriptor;

    protected OracleNamedType() {
    }

    public OracleNamedType(String string, OracleConnection oracleConnection) {
        this._setConnection(oracleConnection);
        this.m_fullName = string;
        this.initNames();
        this.m_hasName = true;
        this.m_parent = null;
        this.m_descriptor = null;
    }

    protected OracleNamedType(OracleTypeADT oracleTypeADT, int n, OracleConnection oracleConnection) {
        this._setConnection(oracleConnection);
        this.m_parent = oracleTypeADT;
        this.m_idx = n;
        this.m_hasName = false;
        this.m_descriptor = null;
    }

    private void initNames() {
        int n = this.m_fullName.indexOf(".");
        if (n >= 0) {
            this.m_schemaName = this.m_fullName.substring(0, n);
            this.m_typeName = this.m_fullName.substring(n + 1);
        } else {
            this.m_typeName = this.m_fullName;
        }
    }

    public String getFullName() throws SQLException {
        return this.getFullName(false);
    }

    public String getFullName(boolean bl) throws SQLException {
        String string = null;
        if (bl | !this.m_hasName) {
            string = this.m_parent.getAttributeType(this.m_idx);
            if (string != null) {
                this.m_fullName = string;
                this.initNames();
                this.m_hasName = true;
            } else {
                DBError.throwSqlException(1, "Unable to resolve name");
            }
        }
        return this.m_fullName;
    }

    public String getSchemaName() throws SQLException {
        if (!this.m_hasName) {
            this.getFullName();
        }
        return this.m_schemaName;
    }

    public String getSimpleName() throws SQLException {
        if (!this.m_hasName) {
            this.getFullName();
        }
        return this.m_typeName;
    }

    public boolean hasName() throws SQLException {
        return this.m_hasName;
    }

    public OracleTypeADT getParent() throws SQLException {
        return this.m_parent;
    }

    public void setParent(OracleTypeADT oracleTypeADT) throws SQLException {
        this.m_parent = oracleTypeADT;
    }

    public int getOrder() throws SQLException {
        return this.m_idx;
    }

    public void setOrder(int n) throws SQLException {
        this.m_idx = n;
    }

    public OracleConnection getConnection() throws SQLException {
        return this.m_conn;
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
        this._setConnection(oracleConnection);
    }

    public void _setConnection(OracleConnection oracleConnection) {
        this.m_conn = oracleConnection;
    }

    public Datum unlinearize(byte[] byArray, long l, Datum datum, int n, Map map) throws SQLException {
        DBError.throwSqlException(23);
        return null;
    }

    public Datum unlinearize(byte[] byArray, long l, Datum datum, long l2, int n, int n2, Map map) throws SQLException {
        DBError.throwSqlException(23);
        return null;
    }

    public byte[] linearize(Datum datum) throws SQLException {
        DBError.throwSqlException(23);
        return null;
    }

    public TypeDescriptor getDescriptor() throws SQLException {
        return this.m_descriptor;
    }

    public void setDescriptor(TypeDescriptor typeDescriptor) throws SQLException {
        this.m_descriptor = typeDescriptor;
    }

    public int getTypeVersion() {
        return 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            objectOutputStream.writeUTF(this.getFullName());
        }
        catch (SQLException sQLException) {
            DBError.SQLToIOException(sQLException);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_fullName = objectInputStream.readUTF();
        this.initNames();
        this.m_hasName = true;
        this.m_parent = null;
        this.m_idx = -1;
    }
}

