/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.search;

import com.jgoodies.search.Completion;
import com.jgoodies.search.CompletionInfoRenderer;
import com.jgoodies.search.CompletionManager;
import com.jgoodies.search.CompletionView;
import com.jgoodies.search.DefaultCompletionInfoRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

final class CompletionInfoView {
    private final CompletionManager completionManager;
    private final CompletionView completionView;
    private Timer timer;
    private JPopupMenu popup;
    private CompletionInfoRenderer renderer;
    private JPanel renderContainer;

    CompletionInfoView(CompletionManager completionManager, CompletionView completionView) {
        this.completionManager = completionManager;
        this.completionView = completionView;
    }

    private void initComponents() {
        this.renderer = this.completionManager.getCompletionInfoRenderer();
        this.renderContainer = new JPanel(new BorderLayout());
        this.popup = new JPopupMenu();
        this.popup.putClientProperty("JPopupMenu.noMargin", Boolean.TRUE);
        this.popup.setFocusable(false);
        this.popup.add(this.renderContainer);
    }

    void show() {
        Completion selection = this.completionManager.getSelection();
        if (selection == null || selection.getAdditionalInfo() == null) {
            this.hide();
            return;
        }
        if (this.popup != null) {
            this.setContent(this.renderer.getRendererComponent(selection));
            return;
        }
        this.initComponents();
        JPopupMenu primaryPopup = this.completionView.getPopup();
        Point origin = primaryPopup.getLocation();
        SwingUtilities.convertPointToScreen(origin, primaryPopup);
        this.popup.setPopupSize(this.computePopupSize());
        int x = origin.x + primaryPopup.getWidth();
        Insets i = this.popup.getInsets();
        int pw = this.popup.getPreferredSize().width + i.left + i.right;
        GraphicsConfiguration gc = primaryPopup.getGraphicsConfiguration();
        int popupX = gc != null && CompletionInfoView.adjustX(x, gc.getDevice()) + pw < gc.getBounds().width ? x : origin.x - (pw + 3);
        int popupY = origin.y;
        this.popup.setLocation(popupX, popupY);
        this.setContent(this.renderer.getRendererComponent(selection));
        this.popup.setVisible(true);
    }

    private static int adjustX(int x, GraphicsDevice device) {
        int newX = x;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice d : ge.getScreenDevices()) {
            if (d == device) break;
            newX -= d.getDisplayMode().getWidth();
        }
        return newX;
    }

    void hide() {
        this.stopTimer();
        if (this.popup == null) {
            return;
        }
        this.popup.setVisible(false);
        this.popup = null;
        this.setContent(null);
        this.renderer = null;
    }

    private void setContent(Component view) {
        this.renderContainer.removeAll();
        if (view != null) {
            this.renderContainer.add(view);
            this.renderContainer.revalidate();
            this.renderContainer.repaint();
        }
    }

    private Dimension computePopupSize() {
        return new Dimension(this.computePopupWidth(), this.completionView.getPopup().getHeight());
    }

    private int computePopupWidth() {
        Completion prototype = this.completionManager.getCompletionInfoPrototypeDisplayValue();
        if (prototype == null) {
            return this.completionView.getPopup().getWidth();
        }
        CompletionInfoRenderer infoRenderer = this.completionManager.getCompletionInfoRenderer();
        Insets insets = this.popup.getInsets();
        if (!(infoRenderer instanceof DefaultCompletionInfoRenderer)) {
            Component component = infoRenderer.getRendererComponent(prototype);
            return component.getPreferredSize().width + insets.left + insets.right;
        }
        DefaultCompletionInfoRenderer area = (DefaultCompletionInfoRenderer)infoRenderer;
        boolean lineWrap = area.getLineWrap();
        area.setLineWrap(false);
        Component component = infoRenderer.getRendererComponent(prototype);
        int width = component.getPreferredSize().width + insets.left + insets.right;
        area.setLineWrap(lineWrap);
        return width;
    }

    void initTimer() {
        this.timer = new Timer(this.completionManager.getAdditionalInfoActivationDelay(), this::onTimerFired);
        this.timer.setRepeats(false);
        this.timer.setCoalesce(true);
    }

    void startTimer() {
        this.timer.restart();
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    private void onTimerFired(ActionEvent e) {
        this.show();
    }
}

