/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import java.math.BigDecimal;
import org.jspecify.annotations.Nullable;

public final class BigDecimalSubject
extends ComparableSubject<BigDecimal> {
    private final @Nullable BigDecimal actual;

    BigDecimalSubject(FailureMetadata metadata, @Nullable BigDecimal actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    public void isEqualToIgnoringScale(BigDecimal expected) {
        this.compareValues(expected);
    }

    public void isEqualToIgnoringScale(String expected) {
        this.compareValues(new BigDecimal(expected));
    }

    public void isEqualToIgnoringScale(long expected) {
        this.compareValues(new BigDecimal(expected));
    }

    @Override
    public void isEqualTo(@Nullable Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isEquivalentAccordingToCompareTo(@Nullable BigDecimal expected) {
        this.compareValues(expected);
    }

    private void compareValues(@Nullable BigDecimal expected) {
        if (((BigDecimal)Preconditions.checkNotNull((Object)this.actual)).compareTo((BigDecimal)Preconditions.checkNotNull((Object)expected)) != 0) {
            this.failWithoutActual(Fact.fact("expected", expected), this.butWas(), Fact.simpleFact("(scale is ignored)"));
        }
    }
}

