/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.util.Logging;

public final class EquipSlot
implements Cloneable {
    private String slotName = "";
    private Set<String> containEqList = new HashSet<String>();
    private String slotNumType = "";
    private int containNum = 1;

    public String toString() {
        return this.slotName;
    }

    public EquipSlot clone() {
        EquipSlot newSlot;
        try {
            newSlot = (EquipSlot)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logging.errorPrint("Clone is not supported!", e);
            return null;
        }
        newSlot.containEqList = new HashSet<String>(this.containEqList);
        return newSlot;
    }

    public void setContainNum(int i) {
        this.containNum = i;
    }

    public Set<String> getContainType() {
        return this.containEqList;
    }

    public int getSlotCount() {
        int multi = Globals.getEquipSlotTypeCount(this.slotNumType);
        return multi * this.containNum;
    }

    public void setSlotName(String x) {
        this.slotName = x;
    }

    public String getSlotName() {
        return this.slotName;
    }

    public void setSlotNumType(String x) {
        this.slotNumType = x;
    }

    public String getBodyStructureName() {
        return this.slotNumType;
    }

    public boolean canContainType(String aTypeList) {
        StringTokenizer aTok = new StringTokenizer(aTypeList, ".", false);
        while (aTok.hasMoreTokens()) {
            String aType = aTok.nextToken();
            for (String allowed : this.containEqList) {
                if (!aType.equalsIgnoreCase(allowed)) continue;
                return true;
            }
        }
        return false;
    }

    public void addContainedType(String type) {
        this.containEqList.add(type);
    }
}

