/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.Module;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResolutionParams
implements Serializable {
    private Integer maxIterations = null;
    private final HashMap<Module, String> forceVersions = new HashMap();
    private final HashMap<String, String> forcedProperties = new HashMap();
    private final HashSet<String> profiles = new HashSet();
    private final HashSet<Map.Entry<String, String>> exclusions = new HashSet();
    private boolean useSystemOsInfo = true;
    private boolean useSystemJdkVersion = true;
    private String scalaVersion = null;
    private Boolean keepProvidedDependencies = null;
    private Boolean forceDepMgmtVersions = null;
    private Boolean enableDependencyOverrides = null;
    private String defaultConfiguration = null;

    private ResolutionParams() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResolutionParams)) {
            return false;
        }
        ResolutionParams resolutionParams = (ResolutionParams)object;
        return this.useSystemOsInfo == resolutionParams.useSystemOsInfo && this.useSystemJdkVersion == resolutionParams.useSystemJdkVersion && Objects.equals(this.maxIterations, resolutionParams.maxIterations) && Objects.equals(this.forceVersions, resolutionParams.forceVersions) && Objects.equals(this.forcedProperties, resolutionParams.forcedProperties) && Objects.equals(this.profiles, resolutionParams.profiles) && Objects.equals(this.exclusions, resolutionParams.exclusions) && Objects.equals(this.scalaVersion, resolutionParams.scalaVersion) && Objects.equals(this.keepProvidedDependencies, resolutionParams.keepProvidedDependencies) && Objects.equals(this.forceDepMgmtVersions, resolutionParams.forceDepMgmtVersions) && Objects.equals(this.enableDependencyOverrides, resolutionParams.enableDependencyOverrides) && Objects.equals(this.defaultConfiguration, resolutionParams.defaultConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.maxIterations, this.forceVersions, this.forcedProperties, this.profiles, this.exclusions, this.useSystemOsInfo, this.useSystemJdkVersion, this.scalaVersion, this.keepProvidedDependencies, this.forceDepMgmtVersions, this.enableDependencyOverrides, this.defaultConfiguration);
    }

    public String toString() {
        return "ResolutionParams{maxIterations=" + this.maxIterations + ", forceVersions=" + this.forceVersions + ", forcedProperties=" + this.forcedProperties + ", profiles=" + this.profiles + ", exclusions=" + this.exclusions + ", useSystemOsInfo=" + this.useSystemOsInfo + ", useSystemJdkVersion=" + this.useSystemJdkVersion + ", scalaVersion='" + this.scalaVersion + '\'' + ", keepProvidedDependencies=" + this.keepProvidedDependencies + ", forceDepMgmtVersions=" + this.forceDepMgmtVersions + ", enableDependencyOverrides=" + this.enableDependencyOverrides + ", defaultConfiguration=" + this.defaultConfiguration + '}';
    }

    public static ResolutionParams create() {
        return new ResolutionParams();
    }

    public static ResolutionParams of(ResolutionParams resolutionParams) {
        return new ResolutionParams().withMaxIterations(resolutionParams.maxIterations).withForceProperties(resolutionParams.forcedProperties).withForceVersions(resolutionParams.forceVersions).withProfiles(resolutionParams.profiles).withExclusions(resolutionParams.exclusions).withUseSystemOsInfo(resolutionParams.useSystemOsInfo).withUseSystemJdkVersion(resolutionParams.useSystemJdkVersion).withScalaVersion(resolutionParams.scalaVersion).withKeepProvidedDependencies(resolutionParams.keepProvidedDependencies).withForceDepMgmtVersions(resolutionParams.forceDepMgmtVersions).withEnableDependencyOverrides(resolutionParams.enableDependencyOverrides).withDefaultConfiguration(resolutionParams.defaultConfiguration);
    }

    public ResolutionParams withMaxIterations(Integer n) {
        this.maxIterations = n;
        return this;
    }

    public ResolutionParams forceProperty(String string, String string2) {
        this.forcedProperties.put(string, string2);
        return this;
    }

    public ResolutionParams forceProperties(Map<String, String> map) {
        this.forcedProperties.putAll(map);
        return this;
    }

    public ResolutionParams withForceProperties(Map<String, String> map) {
        this.forcedProperties.clear();
        this.forcedProperties.putAll(map);
        return this;
    }

    public ResolutionParams forceVersion(Module module, String string) {
        this.forceVersions.put(module, string);
        return this;
    }

    public ResolutionParams forceVersions(Map<Module, String> map) {
        this.forceVersions.putAll(map);
        return this;
    }

    public ResolutionParams withForceVersions(Map<Module, String> map) {
        this.forceVersions.clear();
        this.forceVersions.putAll(map);
        return this;
    }

    public ResolutionParams addProfile(String string) {
        this.profiles.add(string);
        return this;
    }

    public ResolutionParams removeProfile(String string) {
        this.profiles.remove(string);
        return this;
    }

    public ResolutionParams withProfiles(Set<String> set) {
        this.profiles.clear();
        this.profiles.addAll(set);
        return this;
    }

    public ResolutionParams addExclusion(String string, String string2) {
        this.exclusions.add(new AbstractMap.SimpleEntry<String, String>(string, string2));
        return this;
    }

    public ResolutionParams removeExclusion(String string, String string2) {
        this.exclusions.remove(new AbstractMap.SimpleEntry<String, String>(string, string2));
        return this;
    }

    public ResolutionParams withExclusions(Set<Map.Entry<String, String>> set) {
        this.exclusions.clear();
        this.exclusions.addAll(set);
        return this;
    }

    public ResolutionParams withUseSystemOsInfo(boolean bl) {
        this.useSystemOsInfo = bl;
        return this;
    }

    public ResolutionParams withUseSystemJdkVersion(boolean bl) {
        this.useSystemJdkVersion = bl;
        return this;
    }

    public ResolutionParams withScalaVersion(String string) {
        this.scalaVersion = string;
        return this;
    }

    public ResolutionParams withKeepProvidedDependencies(Boolean bl) {
        this.keepProvidedDependencies = bl;
        return this;
    }

    public ResolutionParams withForceDepMgmtVersions(Boolean bl) {
        this.forceDepMgmtVersions = bl;
        return this;
    }

    public ResolutionParams withEnableDependencyOverrides(Boolean bl) {
        this.enableDependencyOverrides = bl;
        return this;
    }

    public ResolutionParams withDefaultConfiguration(String string) {
        this.defaultConfiguration = string;
        return this;
    }

    public Integer getMaxIterations() {
        return this.maxIterations;
    }

    public Map<String, String> getForcedProperties() {
        return Collections.unmodifiableMap(this.forcedProperties);
    }

    public Map<Module, String> getForceVersions() {
        return Collections.unmodifiableMap(this.forceVersions);
    }

    public Set<String> getProfiles() {
        return Collections.unmodifiableSet(this.profiles);
    }

    public Set<Map.Entry<String, String>> getExclusions() {
        return Collections.unmodifiableSet(this.exclusions);
    }

    public boolean getUseSystemOsInfo() {
        return this.useSystemOsInfo;
    }

    public boolean getUseSystemJdkVersion() {
        return this.useSystemJdkVersion;
    }

    public String getScalaVersion() {
        return this.scalaVersion;
    }

    public Boolean getKeepProvidedDependencies() {
        return this.keepProvidedDependencies;
    }

    public Boolean getForceDepMgmtVersions() {
        return this.forceDepMgmtVersions;
    }

    public Boolean getEnableDependencyOverrides() {
        return this.enableDependencyOverrides;
    }

    public String getDefaultConfiguration() {
        return this.defaultConfiguration;
    }
}

