/*******************************************************************************
 * Copyright (c) Contributors to the Eclipse Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-License-Identifier: Apache-2.0 
 *******************************************************************************/

package org.osgi.service.cdi;

/**
 * Defines the possible values of the policy of a satisfied reference towards
 * new matching services appearing.
 *
 * @author $Id: 35aa1a9b3f96292d6d3072c0a154a5ebea8d4858 $
 */
public enum ReferencePolicyOption {
	/**
	 * Consume the matching service applying it's {@link ReferencePolicy}
	 */
	GREEDY,
	/**
	 * Do not consume the matching service
	 */
	RELUCTANT
}
