#pragma once

#include "IO.h"

namespace APE
{

/**************************************************************************************************
Declares
**************************************************************************************************/
#define BIT_ARRAY_ELEMENTS    (1024)                      // the number of elements in the bit array (4 kB)
#define BIT_ARRAY_BYTES       (BIT_ARRAY_ELEMENTS * 4)    // the number of bytes in the bit array
#define BIT_ARRAY_BITS        (BIT_ARRAY_BYTES    * 8)    // the number of bits in the bit array

//#define BUILD_RANGE_TABLE

struct RANGE_CODER_STRUCT_COMPRESS
{
    unsigned int low;         // low end of interval
    unsigned int range;       // length of interval
    unsigned int help;        // bytes_to_follow resp. intermediate value
    unsigned char buffer;     // buffer for input / output
    unsigned char padding[3]; // buffer alignment
};

struct BIT_ARRAY_STATE
{
    uint32 nKSum;
};

class CBitArray
{
public:
    // construction / destruction
    CBitArray(APE::CIO * pIO);
    virtual ~CBitArray();

    // encoding
    int EncodeUnsignedLong(unsigned int n);
    int EncodeValue(int64 nEncode, BIT_ARRAY_STATE & BitArrayState);

    // output (saving)
    int OutputBitArray(bool bFinalize = false);

    // other functions
    void Finalize();
    void AdvanceToByteBoundary();
    __forceinline uint32 GetCurrentBitIndex() const { return m_nCurrentBitIndex; }
    void FlushState(BIT_ARRAY_STATE & BitArrayState);
    void FlushBitArray();

private:
    // data members
    uint32 m_aryBitArray[BIT_ARRAY_ELEMENTS];
    CIO * m_pIO;
    uint32 m_nCurrentBitIndex;
    RANGE_CODER_STRUCT_COMPRESS m_RangeCoderInfo;

#ifdef BUILD_RANGE_TABLE
    void OutputRangeTable();
#endif
};

}
