/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.dictionary;

import net.java.sen.dictionary.Morpheme;
import net.java.sen.dictionary.Node;

public class Token {
    private String surface = null;
    private int cost = -1;
    private int start = -1;
    private int length = -1;
    private boolean sentenceStart;
    private Morpheme morpheme;

    public boolean isSentenceStart() {
        return this.sentenceStart;
    }

    public void setSentenceStart(boolean sentenceStart) {
        this.sentenceStart = sentenceStart;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getSurface() {
        return this.surface;
    }

    public void setSurface(String surface) {
        this.surface = surface;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public Morpheme getMorpheme() {
        return this.morpheme;
    }

    public void setMorpheme(Morpheme morpheme) {
        this.morpheme = morpheme;
    }

    public int end() {
        return this.getStart() + this.getLength();
    }

    public boolean equals(Object object) {
        if (object instanceof Token) {
            Token token = (Token)object;
            if ((this.surface == token.surface || this.surface != null && this.surface.equals(token.surface)) && this.cost == token.cost && this.start == token.start && this.length == token.length && (this.morpheme == token.morpheme || this.morpheme != null && this.morpheme.equals(token.morpheme))) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getSurface();
    }

    public Token(String surface, Node node) {
        this.morpheme = node.morpheme;
        this.cost = node.cost;
        this.surface = surface.substring(node.start, node.start + node.length);
        this.start = node.start;
        this.length = node.length;
    }

    public Token(String surface, int cost, int start, int length, Morpheme morpheme) {
        this.surface = surface;
        this.cost = cost;
        this.start = start;
        this.length = length;
        this.morpheme = morpheme;
    }

    public Token() {
        this.morpheme = new Morpheme();
    }
}

