#ifndef _fmshttprequesthandlerfactory_
#define _fmshttprequesthandlerfactory_

#include "ipagehandler.h"
#include "htmltemplatehandler.h"
#include "../ipaddressacl.h"
#include "../ilogger.h"
#include "../idatabase.h"

#include <vector>
#include <set>

#include <Poco/Net/HTTPRequestHandlerFactory.h>
#include <Poco/Net/HTTPServerRequest.h>

class FMSHTTPRequestHandlerFactory:public Poco::Net::HTTPRequestHandlerFactory,public ILogger,public IDatabase
{
public:
	FMSHTTPRequestHandlerFactory(SQLite3DB::DB *db);
	~FMSHTTPRequestHandlerFactory();

	Poco::Net::HTTPRequestHandler *createRequestHandler(const Poco::Net::HTTPServerRequest &request);

private:
	std::vector<IPageHandler *> m_pagehandlers;
	IPAddressACL m_acl;
	HTMLTemplateHandler m_forumtemplatehandler;
	std::set<std::string> m_allowedhostheader;
	std::vector<std::pair<std::string,std::string> > m_extraresponseheader;

};

#endif	// _fmshttprequesthandlerfactory_
