/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.agent;

import java.util.Collection;
import java.util.Map;

final class ArgsFormatter {
    private StringBuilder sb = new StringBuilder();

    ArgsFormatter() {
    }

    String format(Object[] args) {
        try {
            for (Object arg : args) {
                this.format(arg, ',');
            }
            String argsAsString = this.sb.deleteCharAt(this.sb.length() - 1).toString();
            return argsAsString;
        }
        catch (Exception exception) {
            return "";
        }
    }

    void format(Object object, char separator) {
        if (object == null) {
            this.formatNullObject();
        } else if (object instanceof Collection) {
            this.formatCollection((Collection)object);
        } else if (object instanceof Map) {
            this.formatMap((Map)object);
        } else if (object instanceof Object[]) {
            this.formatArray((Object[])object);
        } else {
            this.sb.append(object.toString());
        }
        this.sb.append(separator);
    }

    private void formatArray(Object[] array) {
        this.sb.append('[');
        for (Object object : array) {
            this.format(object, ',');
        }
        this.sb.deleteCharAt(this.sb.length() - 1);
        this.sb.append(']');
    }

    private void formatCollection(Collection collection) {
        this.sb.append('[');
        for (Object obj : collection) {
            this.format(obj, ',');
        }
        this.sb.deleteCharAt(this.sb.length() - 1);
        this.sb.append(']');
    }

    private <K, V> void formatMap(Map<K, V> map) {
        this.sb.append('[');
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.format(entry.getKey(), ':');
            this.format(entry.getValue(), ',');
        }
        this.sb.deleteCharAt(this.sb.length() - 1);
        this.sb.append(']');
    }

    void formatNullObject() {
        this.sb.append("null");
    }
}

