/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.samplingV2;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.StringUtils;
import com.microsoft.applicationinsights.telemetry.Telemetry;
import java.util.Random;

public class SamplingScoreGeneratorV2 {
    private static Random random = new Random();

    public static double getSamplingScore(Telemetry telemetry) {
        double samplingScore = 0.0;
        if (!StringUtils.isEmpty(telemetry.getContext().getOperation().getId())) {
            samplingScore = (double)SamplingScoreGeneratorV2.getSamplingHashCode(telemetry.getContext().getOperation().getId()) / 2.147483647E9;
        } else {
            long val = Math.abs(random.nextLong());
            samplingScore = (double)Math.abs(val) / 9.223372036854776E18;
        }
        return samplingScore * 100.0;
    }

    static int getSamplingHashCode(String input) {
        if (StringUtils.isEmpty(input)) {
            return 0;
        }
        StringBuilder inputBuilder = new StringBuilder(input);
        while (inputBuilder.length() < 8) {
            inputBuilder.append(input);
        }
        int hash = 5381;
        for (int i = 0; i < inputBuilder.length(); ++i) {
            hash = (hash << 5) + hash + inputBuilder.charAt(i);
        }
        return hash == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(hash);
    }
}

