/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.PDLineDashPattern;

public class PDBorderStyleDictionary
implements COSObjectable {
    public static final String STYLE_SOLID = "S";
    public static final String STYLE_DASHED = "D";
    public static final String STYLE_BEVELED = "B";
    public static final String STYLE_INSET = "I";
    public static final String STYLE_UNDERLINE = "U";
    private final COSDictionary dictionary;

    public PDBorderStyleDictionary() {
        this.dictionary = new COSDictionary();
    }

    public PDBorderStyleDictionary(COSDictionary dict) {
        this.dictionary = dict;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public void setWidth(float w) {
        if (w == (float)((int)w)) {
            this.getCOSObject().setInt("W", (int)w);
        } else {
            this.getCOSObject().setFloat("W", w);
        }
    }

    public float getWidth() {
        return this.getCOSObject().getFloat("W", 1.0f);
    }

    public void setStyle(String s2) {
        this.getCOSObject().setName(STYLE_SOLID, s2);
    }

    public String getStyle() {
        return this.getCOSObject().getNameAsString(STYLE_SOLID, STYLE_SOLID);
    }

    public void setDashStyle(COSArray dashArray) {
        COSArray array = null;
        if (dashArray != null) {
            array = dashArray;
        }
        this.getCOSObject().setItem(STYLE_DASHED, (COSBase)array);
    }

    public PDLineDashPattern getDashStyle() {
        COSArray d = (COSArray)this.getCOSObject().getDictionaryObject(STYLE_DASHED);
        if (d == null) {
            d = new COSArray();
            d.add(COSInteger.THREE);
            this.getCOSObject().setItem(STYLE_DASHED, (COSBase)d);
        }
        return new PDLineDashPattern(d, 0);
    }
}

