/*
 * Decompiled with CFR 0.152.
 */
package org.jabref;

import java.net.Authenticator;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jabref.FallbackExceptionHandler;
import org.jabref.Globals;
import org.jabref.JabRefGUI;
import org.jabref.cli.ArgumentProcessor;
import org.jabref.gui.remote.JabRefMessageHandler;
import org.jabref.logic.journals.JournalAbbreviationLoader;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.net.ProxyAuthenticator;
import org.jabref.logic.net.ProxyPreferences;
import org.jabref.logic.net.ProxyRegisterer;
import org.jabref.logic.protectedterms.ProtectedTermsLoader;
import org.jabref.logic.remote.RemotePreferences;
import org.jabref.logic.remote.client.RemoteClient;
import org.jabref.logic.util.BuildInfo;
import org.jabref.logic.util.JavaVersion;
import org.jabref.logic.util.OS;
import org.jabref.migrations.PreferencesMigrations;
import org.jabref.model.EntryTypes;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabRefMain
extends Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(JabRefMain.class);
    private static String[] arguments;

    public static void main(String[] args) {
        arguments = args;
        JabRefMain.launch((String[])arguments);
    }

    public void start(Stage mainStage) throws Exception {
        Platform.setImplicitExit((boolean)false);
        SwingUtilities.invokeLater(() -> JabRefMain.start(arguments));
    }

    private static void ensureCorrectJavaVersion() {
        boolean versionFail;
        BuildInfo buildInfo = Globals.BUILD_INFO;
        JavaVersion checker = new JavaVersion();
        boolean java9Fail = !buildInfo.isAllowJava9() && checker.isJava9();
        boolean bl = versionFail = !checker.isAtLeast(buildInfo.getMinRequiredJavaVersion());
        if (java9Fail || versionFail) {
            StringBuilder versionError = new StringBuilder(Localization.lang("Your current Java version (%0) is not supported. Please install version %1 or higher.", checker.getJavaVersion(), buildInfo.getMinRequiredJavaVersion()));
            versionError.append("\n");
            versionError.append(Localization.lang("Your Java Runtime Environment is located at %0.", checker.getJavaInstallationDirectory()));
            if (!buildInfo.isAllowJava9()) {
                versionError.append("\n");
                versionError.append(Localization.lang("Note that currently, JabRef does not run with Java 9.", new String[0]));
            }
            JFrame frame = new JFrame();
            JOptionPane.showMessageDialog(frame, versionError, Localization.lang("Error", new String[0]), 0);
            frame.dispose();
            if (java9Fail) {
                System.exit(0);
            }
        }
    }

    private static void start(String[] args) {
        JabRefPreferences preferences;
        JabRefMain.ensureCorrectJavaVersion();
        FallbackExceptionHandler.installExceptionHandler();
        Globals.prefs = preferences = JabRefPreferences.getInstance();
        PreferencesMigrations.runMigrations();
        JabRefMain.configureProxy(preferences.getProxyPreferences());
        Globals.startBackgroundTasks();
        JabRefMain.applyPreferences(preferences);
        ArgumentProcessor argumentProcessor = new ArgumentProcessor(args, ArgumentProcessor.Mode.INITIAL_START);
        if (!JabRefMain.handleMultipleAppInstances(args) || argumentProcessor.shouldShutDown()) {
            JabRefMain.shutdownCurrentInstance();
            return;
        }
        SwingUtilities.invokeLater(() -> new JabRefGUI(argumentProcessor.getParserResults(), argumentProcessor.isBlank()));
    }

    private static boolean handleMultipleAppInstances(String[] args) {
        RemotePreferences remotePreferences = Globals.prefs.getRemotePreferences();
        if (remotePreferences.useRemoteServer()) {
            RemoteClient remoteClient = new RemoteClient(remotePreferences.getPort());
            if (remoteClient.ping()) {
                if (remoteClient.sendCommandLineArguments(args)) {
                    LOGGER.info(Localization.lang("Arguments passed on to running JabRef instance. Shutting down.", new String[0]));
                    return false;
                }
            } else {
                Globals.REMOTE_LISTENER.openAndStart(new JabRefMessageHandler(), remotePreferences.getPort());
            }
        }
        return true;
    }

    private static void shutdownCurrentInstance() {
        Globals.shutdownThreadPools();
        Platform.exit();
    }

    private static void applyPreferences(JabRefPreferences preferences) {
        InternalBibtexFields.updateSpecialFields(Globals.prefs.getBoolean("serializeSpecialFields"));
        InternalBibtexFields.updateTimeStampField(Globals.prefs.getTimestampPreferences().getTimestampField());
        InternalBibtexFields.setNumericFields(Globals.prefs.getStringList("numericFields"));
        Globals.journalAbbreviationLoader = new JournalAbbreviationLoader();
        Globals.IMPORT_FORMAT_READER.resetImportFormats(Globals.prefs.getImportFormatPreferences(), Globals.prefs.getXMPPreferences(), Globals.getFileUpdateMonitor());
        EntryTypes.loadCustomEntryTypes(preferences.loadCustomEntryTypes(BibDatabaseMode.BIBTEX), preferences.loadCustomEntryTypes(BibDatabaseMode.BIBLATEX));
        Globals.exportFactory = Globals.prefs.getExporterFactory(Globals.journalAbbreviationLoader);
        Globals.protectedTermsLoader = new ProtectedTermsLoader(Globals.prefs.getProtectedTermsPreferences());
        OS.NEWLINE = Globals.prefs.get("newline");
    }

    private static void configureProxy(ProxyPreferences proxyPreferences) {
        ProxyRegisterer.register(proxyPreferences);
        if (proxyPreferences.isUseProxy().booleanValue() && proxyPreferences.isUseAuthentication().booleanValue()) {
            Authenticator.setDefault(new ProxyAuthenticator());
        }
    }
}

