/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.auximport;

import org.jabref.logic.l10n.Localization;
import org.jabref.model.auxparser.AuxParserResult;

public class AuxParserResultViewModel {
    private AuxParserResult auxParserResult;

    public AuxParserResultViewModel(AuxParserResult auxParserResult) {
        this.auxParserResult = auxParserResult;
    }

    public String getInformation(boolean includeMissingEntries) {
        StringBuilder result = new StringBuilder();
        result.append(Localization.lang("keys in library", new String[0])).append(' ').append(this.auxParserResult.getMasterDatabase().getEntryCount()).append('\n').append(Localization.lang("found in AUX file", new String[0])).append(' ').append(this.auxParserResult.getFoundKeysInAux()).append('\n').append(Localization.lang("resolved", new String[0])).append(' ').append(this.auxParserResult.getResolvedKeysCount()).append('\n').append(Localization.lang("not found", new String[0])).append(' ').append(this.auxParserResult.getUnresolvedKeysCount()).append('\n').append(Localization.lang("crossreferenced entries included", new String[0])).append(' ').append(this.auxParserResult.getCrossRefEntriesCount()).append(Localization.lang("strings included", new String[0])).append(' ').append(this.auxParserResult.getInsertedStrings()).append('\n');
        if (includeMissingEntries && this.auxParserResult.getUnresolvedKeysCount() > 0) {
            for (String entry : this.auxParserResult.getUnresolvedKeys()) {
                result.append(entry).append('\n');
            }
        }
        if (this.auxParserResult.getNestedAuxCount() > 0) {
            result.append(Localization.lang("nested AUX files", new String[0])).append(' ').append(this.auxParserResult.getNestedAuxCount());
        }
        return result.toString();
    }
}

