/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.util.io;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.metadata.FileDirectoryPreferences;

public class DatabaseFileLookup {
    private final Set<Path> fileCache = new HashSet<Path>();
    private final List<Path> possibleFilePaths;

    public DatabaseFileLookup(BibDatabaseContext databaseContext, FileDirectoryPreferences fileDirectoryPreferences) {
        Objects.requireNonNull(databaseContext);
        this.possibleFilePaths = Optional.ofNullable(databaseContext.getFileDirectoriesAsPaths(fileDirectoryPreferences)).orElse(new ArrayList());
        for (BibEntry entry : databaseContext.getDatabase().getEntries()) {
            this.fileCache.addAll(this.parseFileField(entry));
        }
    }

    public boolean lookupDatabase(File file) {
        return this.fileCache.contains(file.toPath());
    }

    private List<Path> parseFileField(BibEntry entry) {
        Objects.requireNonNull(entry);
        return entry.getFiles().stream().filter(file -> !file.isOnlineLink()).map(file -> file.findIn(this.possibleFilePaths)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

