/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.e4models;

import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderRenderer;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.widgets.Control;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class ViewModelFolderRenderer
extends CTabFolderRenderer {
    private static final int FLAGS = 9;
    private static final String ELLIPSIS = "...";
    private static final int BORDER1_COLOR = 18;
    private ResourceManager resources;

    public ViewModelFolderRenderer(CTabFolder parent) {
        super(parent);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
    }

    protected Point computeSize(int part, int state, GC gc, int wHint, int hHint) {
        Point size = super.computeSize(part, state, gc, wHint, hHint);
        if (part >= 0 && part < this.parent.getItemCount()) {
            Control topRight = this.parent.getTopRight();
            size.x = this.parent.getItemCount() == 1 ? this.parent.getSize().x : (this.parent.getSize().x - (topRight.getSize().x + 8)) / this.parent.getItemCount();
            size.y += 5;
        }
        return size;
    }

    protected void draw(int part, int state, Rectangle bounds, GC gc) {
        if (part == -2) {
            this.drawTabArea2(gc, bounds, state);
        } else if (part >= 0 && part < this.parent.getItemCount()) {
            if (bounds.width == 0 || bounds.height == 0) {
                return;
            }
            CTabItem item = this.parent.getItem(part);
            if (this.parent.getItemCount() == 1) {
                this.drawSingleItem(bounds, gc, item);
            } else {
                this.drawMultiItems(part, state, bounds, gc, item);
            }
        } else {
            super.draw(part, state, bounds, gc);
        }
    }

    private void drawSingleItem(Rectangle bounds, GC gc, CTabItem item) {
        int fullWidth = this.parent.getSize().x;
        gc.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#f4f4f4")));
        gc.fillRectangle(bounds.x + 1, bounds.y + 1, bounds.x + fullWidth - 2, bounds.y + bounds.height - 1);
        gc.setLineWidth(1);
        gc.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#cecece")));
        gc.drawLine(bounds.x + 1, bounds.y + bounds.height, bounds.x + fullWidth - 2, bounds.y + bounds.height);
        Rectangle topBounds = new Rectangle(bounds.x, bounds.y, this.parent.getSize().x, bounds.height);
        this.drawText(bounds, gc, item, "#1c1c1c", topBounds);
    }

    private void drawMultiItems(int part, int state, Rectangle bounds, GC gc, CTabItem item) {
        int fullWidth = this.parent.getSize().x;
        gc.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#f4f4f4")));
        gc.fillRectangle(bounds.x + 1, bounds.y + 1, bounds.width, bounds.height - 1);
        gc.setLineWidth(1);
        gc.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#a0a0a0")));
        gc.drawLine(bounds.x + 1, bounds.y + bounds.height, bounds.x + bounds.width, bounds.y + bounds.height);
        if ((state & 2) != 0) {
            this.drawSelectedItem(part, gc, bounds, state);
        } else {
            this.drawUnselectedItem(part, gc, bounds, state);
        }
        if (part == this.parent.getItemCount() - 1) {
            gc.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#f4f4f4")));
            gc.fillRectangle(bounds.x + bounds.width + 1, bounds.y + 1, fullWidth - (bounds.x + bounds.width + 1) - 1, bounds.height - 1);
            gc.setLineWidth(1);
            gc.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#a0a0a0")));
            gc.drawLine(bounds.x + bounds.width + 1, bounds.y + bounds.height, fullWidth - 1, bounds.y + bounds.height);
        }
    }

    private void drawSelectedItem(int part, GC gc, Rectangle bounds, int state) {
        gc.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#28abe6")));
        gc.fillRectangle(bounds.x + 1, bounds.y + 1, bounds.width - 1, bounds.height - 1);
        gc.setLineWidth(1);
        gc.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#a0a0a0")));
        gc.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height - 1);
        if (part != 0) {
            gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
        }
        CTabItem item = this.parent.getItem(part);
        this.drawText(bounds, gc, item, "#ffffff", null);
    }

    private void drawUnselectedItem(int part, GC gc, Rectangle bounds, int state) {
        gc.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#f4f4f4")));
        gc.fillRectangle(bounds.x + 1, bounds.y + 1, bounds.width - 3, bounds.height - 1);
        gc.setLineWidth(1);
        gc.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor("#a0a0a0")));
        gc.drawLine(bounds.x + bounds.width, bounds.y, bounds.x + bounds.width, bounds.y + bounds.height - 1);
        if (part != 0) {
            gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
        }
        CTabItem item = this.parent.getItem(part);
        this.drawText(bounds, gc, item, "#1c1c1c", null);
    }

    private void drawText(Rectangle bounds, GC gc, CTabItem item, String foreground, Rectangle topBounds) {
        Color gcForeground = gc.getForeground();
        gc.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor(foreground)));
        Font gcFont = gc.getFont();
        gc.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData[])FontUtils.relativeHeight(gcFont.getFontData(), 2))));
        item.setText(this.shortenText2(true, gc, item.getText(), bounds.width));
        Point extent = gc.textExtent(item.getText(), 9);
        int textX = bounds.x + (bounds.width - extent.x) / 2;
        if (topBounds != null && (textX = topBounds.x + (topBounds.width - extent.x) / 2) + extent.x > bounds.x + bounds.width) {
            textX = bounds.x + bounds.width - extent.x;
        }
        int textY = bounds.y + (bounds.height - extent.y) / 2;
        gc.drawText(item.getText(), textX, textY, 9);
        gc.setFont(gcFont);
        gc.setForeground(gcForeground);
    }

    private String shortenText2(boolean useEllipses, GC gc, String text, int width) {
        return useEllipses ? this.shortenText2(gc, text, width, ELLIPSIS) : this.shortenText2(gc, text, width, "");
    }

    private String shortenText2(GC gc, String text, int width, String ellipses) {
        if (gc.textExtent((String)text, (int)9).x <= width) {
            return text;
        }
        int ellipseWidth = gc.textExtent((String)ellipses, (int)9).x;
        int length = text.length();
        TextLayout layout = new TextLayout((Device)this.parent.getDisplay());
        layout.setText(text);
        int end = layout.getPreviousOffset(length, 2);
        while (end > 0) {
            text = text.substring(0, end);
            int l = gc.textExtent((String)text, (int)9).x;
            if (l + ellipseWidth <= width) break;
            end = layout.getPreviousOffset(end, 2);
        }
        layout.dispose();
        return end == 0 ? text.substring(0, 1) : String.valueOf(text) + ellipses;
    }

    private void drawTabArea2(GC gc, Rectangle bounds, int state) {
        Color borderColor = this.parent.getDisplay().getSystemColor(18);
        int tabHeight = this.parent.getTabHeight();
        gc.setLineWidth(1);
        gc.setForeground(borderColor);
        gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, tabHeight);
    }
}

