/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;

public class TextFormatter {
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;

    public static String toFileSize(long size) {
        if (size <= 1024L) {
            return String.format("%d B", size);
        }
        if (size <= 0x100000L) {
            return String.format("%.1f K", (double)size * 1.0 / 1024.0);
        }
        if (size <= 0x40000000L) {
            return String.format("%.1f M", (double)size * 1.0 / 1048576.0);
        }
        return String.format("%.1f G", (double)size * 1.0 / 1.073741824E9);
    }

    public static Object[] toHMS(long milliseconds) {
        long s = milliseconds / 1000L;
        long m = s / 60L;
        long h = m / 60L;
        return new Object[]{h, m % 60L, s % 60L};
    }

    public static Object[] toPrecisionHMS(long milliseconds) {
        double s = (double)milliseconds / 1000.0;
        double m = s / 60.0;
        double h = m / 60.0;
        return new Object[]{h, TextFormatter.rem(m, 60.0), TextFormatter.rem(s, 60.0)};
    }

    private static double rem(double dividend, double divisor) {
        return dividend - (double)((int)(dividend / divisor)) * divisor;
    }

    public static String toTime(long milliseconds) {
        return TextFormatter.toTime(milliseconds, 0, false);
    }

    public static String toTime(long milliseconds, int secondPrecision, boolean autoCompact) {
        if (secondPrecision > 0) {
            Object[] hms = TextFormatter.toPrecisionHMS(milliseconds);
            if (autoCompact && (Double)hms[0] == 0.0) {
                return String.format("%.0f:%." + secondPrecision + "f", hms);
            }
            return String.format("%.0f:%.0f:%." + secondPrecision + "f", hms);
        }
        Object[] hms = TextFormatter.toHMS(milliseconds);
        if (autoCompact && (Long)hms[0] == 0L) {
            return String.format("%02d:%02d", hms);
        }
        return String.format("%02d:%02d:%02d", hms);
    }

    public static String removeNewLineCharacter(String text) {
        return text.replaceAll(" ?(\\r\\n|\\n|\\r)+", " ");
    }

    public static String formatTimeMillis(long timeMillis, String pattern) {
        if (timeMillis <= 0L || pattern == null) {
            return null;
        }
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTimeInMillis(timeMillis);
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.getDefault());
        return formatter.format(calendar.getTime());
    }
}

