/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.widgets.Composite;
import org.xmind.core.ITopic;
import org.xmind.ui.dialogs.PopupFilteredList;
import org.xmind.ui.internal.taskinfo.AssigneeItem;
import org.xmind.ui.internal.taskinfo.AssigneePopupFilteredList;
import org.xmind.ui.internal.taskinfo.AssigneeSheetManager;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.viewers.MComboViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssigneeMComboViewer
extends MComboViewer {
    private boolean hasExtra;
    private ITopic topic;

    public AssigneeMComboViewer(Composite parent, int style, boolean hasExtral, ITopic topic) {
        super(parent, style);
        this.hasExtra = hasExtral;
        this.topic = topic;
    }

    public void setTopic(ITopic topic) {
        this.topic = topic;
    }

    protected PopupFilteredList createPopupList() {
        if (this.hasExtra) {
            AssigneePopupFilteredList list = new AssigneePopupFilteredList(this.getControl().getShell());
            this.refreshPopupList(list);
            list.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    AssigneeMComboViewer.this.setSelection(event.getSelection());
                }
            });
            return list;
        }
        return super.createPopupList();
    }

    protected void openPopupList(PopupFilteredList list) {
        list.setInput(this.getAssigneeComboInput());
        super.openPopupList(list);
    }

    private Set<String> getAssigneeComboInput() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (this.topic != null) {
            if (TaskInfoUtils.getContent(this.topic, "assigned-to") != null) {
                set.add("org.xmind.ui.internal.taskinfo.assignee.none");
            }
            set.addAll(TaskInfoUtils.loadAllAssignees(this.topic.getOwnedWorkbook()));
        }
        if (this.getFrequencyAssignees() != null) {
            set.addAll(this.getFrequencyAssignees());
        }
        return set;
    }

    private Collection<String> getFrequencyAssignees() {
        TreeSet<AssigneeItem> list = AssigneeSheetManager.getInstance().getAssigneeSheet().getAssignees();
        if (list == null || list.isEmpty()) {
            return null;
        }
        TreeSet<String> assignees = new TreeSet<String>();
        for (AssigneeItem item : list) {
            assignees.add(item.getName());
        }
        return assignees;
    }
}

