/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITopic;
import org.xmind.gef.GEF;
import org.xmind.ui.gantt.export.ExportConstants;
import org.xmind.ui.gantt.export.GanttFigureRenderer;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeHeaderViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.gantt2.viewer.TimelineViewer;
import org.xmind.ui.internal.print.PrintUtils;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.resources.ColorUtils;

public class GanttImageCreator {
    private Display display;
    private GanttViewer ganttViewer;
    protected IDialogSettings settings;
    private GanttFigureRenderer render;
    private Image leftImage;
    private Image fullRightImage;
    private Image headerImage;
    private Image contentImage;
    private Image[][] singleImages;
    private boolean isHeaderImageValid;
    private boolean isContentImageValid;
    private List<Image> images = new ArrayList<Image>();

    public GanttImageCreator(Display display, GanttViewer ganttViewer, IDialogSettings settings) {
        this.display = display;
        this.ganttViewer = ganttViewer;
        this.settings = settings;
        this.render = new GanttFigureRenderer(ganttViewer);
    }

    private Image createTaskTreeHeaderImage() {
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        final int width = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        int height = headerViewer.getCanvas().getSize().y;
        Image image = new Image((Device)this.display, width, height);
        this.images.add(image);
        final GC gc = new GC((Drawable)image);
        this.display.syncExec(new Runnable(){

            public void run() {
                try {
                    GanttImageCreator.this.render.renderTaskTreeHeaderViewer(gc, new Point(0, 0), 0, width);
                }
                finally {
                    gc.dispose();
                }
            }
        });
        return image;
    }

    private Image createTaskTreeImage() {
        TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
        RangeModel rangeModel = taskTreeViewer.getCanvas().getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        final int width = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        int height = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        Image image = new Image((Device)this.display, width, height);
        this.images.add(image);
        final GC gc = new GC((Drawable)image);
        try {
            this.display.syncExec(new Runnable(){

                public void run() {
                    GanttImageCreator.this.render.renderTaskTreeViewer(gc, new Point(0, 0), 0, width);
                }
            });
        }
        finally {
            gc.dispose();
        }
        return image;
    }

    private Image createTimelineImage() {
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        final int start = timelineModel.getPixelsFromMillis(startTime - timelineModel.getOriginDate().getTimeInMillis()) - 50;
        final int width = startTime != endTime ? timelineModel.getPixelsFromMillis(endTime - startTime) + 100 : 0;
        final int end = start + width;
        Image image = null;
        TimelineViewer timelineViewer = this.ganttViewer.getTimelineViewer();
        if (width > 0) {
            image = new Image((Device)this.display, width, timelineViewer.getCanvas().getSize().y);
            this.images.add(image);
            final GC gc = new GC((Drawable)image);
            try {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if (width != 0) {
                            GanttImageCreator.this.render.renderTimelineViewer(gc, new Point(0, 0), start, end);
                        }
                    }
                });
            }
            finally {
                gc.dispose();
            }
        }
        return image;
    }

    private Image createTaskBarImage() {
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        final int start = timelineModel.getPixelsFromMillis(startTime - timelineModel.getOriginDate().getTimeInMillis()) - 50;
        final int width = startTime != endTime ? timelineModel.getPixelsFromMillis(endTime - startTime) + 100 : 0;
        final int end = start + width;
        Image image = null;
        TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
        if (width > 0) {
            image = new Image((Device)this.display, width, ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height);
            this.images.add(image);
            final GC gc = new GC((Drawable)image);
            try {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        if (width != 0) {
                            GanttImageCreator.this.render.renderTaskBarViewer(gc, new Point(0, 0), start, end);
                        }
                    }
                });
            }
            finally {
                gc.dispose();
            }
        }
        return image;
    }

    private Image createFullTimelineImage() {
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.getMinTimeInMillis();
        long endTime = this.getMaxTimeInMillis();
        int start = 0;
        int width = 0;
        if (startTime != endTime) {
            start = timelineModel.getPixelsFromMillis(startTime - timelineModel.getOriginDate().getTimeInMillis()) - 50;
            width = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        Image image = null;
        TimelineViewer timelineViewer = this.ganttViewer.getTimelineViewer();
        if (width > 0) {
            image = new Image((Device)this.display, width, timelineViewer.getCanvas().getSize().y);
            this.images.add(image);
            GC gc = new GC((Drawable)image);
            try {
                this.render.renderTimelineViewer(gc, new Point(0, 0), start, start + width);
            }
            finally {
                gc.dispose();
            }
        }
        return image;
    }

    private Image createFullTaskBarImage() {
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.getMinTimeInMillis();
        long endTime = this.getMaxTimeInMillis();
        int start = 0;
        int width = 0;
        if (startTime != endTime) {
            start = timelineModel.getPixelsFromMillis(startTime - timelineModel.getOriginDate().getTimeInMillis()) - 50;
            width = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        Image image = null;
        TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
        if (width > 0) {
            image = new Image((Device)this.display, width, ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height);
            this.images.add(image);
            GC gc = new GC((Drawable)image);
            try {
                this.render.renderTaskBarViewer(gc, new Point(0, 0), start, start + width);
            }
            finally {
                gc.dispose();
            }
        }
        return image;
    }

    private Image getHeaderImage() {
        if (this.headerImage == null || this.headerImage.isDisposed() || !this.isHeaderImageValid) {
            if (this.headerImage != null) {
                this.headerImage.dispose();
            }
            this.headerImage = this.createHeaderImage();
            this.isHeaderImageValid = true;
        }
        return this.headerImage;
    }

    private Image createHeaderImage() {
        Image taskTreeHeaderImage = this.createTaskTreeHeaderImage();
        Image timelineImage = this.createTimelineImage();
        Image image = new Image((Device)this.display, taskTreeHeaderImage.getBounds().width + (timelineImage == null ? 0 : timelineImage.getBounds().width), taskTreeHeaderImage.getBounds().height);
        GC gc = new GC((Drawable)image);
        try {
            gc.drawImage(taskTreeHeaderImage, 0, 0);
            if (timelineImage != null) {
                gc.drawImage(timelineImage, taskTreeHeaderImage.getBounds().width, 0);
            }
        }
        finally {
            gc.dispose();
            taskTreeHeaderImage.dispose();
            if (timelineImage != null) {
                timelineImage.dispose();
            }
        }
        return image;
    }

    private Image getContentImage() {
        if (this.contentImage == null || this.contentImage.isDisposed() || !this.isContentImageValid) {
            if (this.contentImage != null) {
                this.contentImage.dispose();
            }
            this.contentImage = this.createContentImage();
            this.isContentImageValid = true;
        }
        return this.contentImage;
    }

    private Image createContentImage() {
        Image taskTreeImage = this.createTaskTreeImage();
        Image taskBarImage = this.createTaskBarImage();
        Image image = new Image((Device)this.display, taskTreeImage.getBounds().width + (taskBarImage == null ? 0 : taskBarImage.getBounds().width), taskTreeImage.getBounds().height);
        GC gc = new GC((Drawable)image);
        try {
            gc.drawImage(taskTreeImage, 0, 0);
            if (taskBarImage != null) {
                gc.drawImage(taskBarImage, taskTreeImage.getBounds().width, 0);
            }
        }
        finally {
            gc.dispose();
            taskTreeImage.dispose();
            if (taskBarImage != null) {
                taskBarImage.dispose();
            }
        }
        return image;
    }

    private Image getLeftImage() {
        if (this.leftImage == null || this.leftImage.isDisposed()) {
            this.leftImage = this.createLeftImage();
        }
        return this.leftImage;
    }

    private Image createLeftImage() {
        Image taskTreeHeaderImage = this.createTaskTreeHeaderImage();
        Image taskTreeImage = this.createTaskTreeImage();
        Image image = new Image((Device)this.display, taskTreeHeaderImage.getBounds().width, taskTreeHeaderImage.getBounds().height + taskTreeImage.getBounds().height);
        GC gc = new GC((Drawable)image);
        try {
            gc.drawImage(taskTreeHeaderImage, 0, 0);
            gc.drawImage(taskTreeImage, 0, taskTreeHeaderImage.getBounds().height);
        }
        finally {
            gc.dispose();
            taskTreeHeaderImage.dispose();
            taskTreeImage.dispose();
        }
        return image;
    }

    private Image getFullRightImage() {
        if (this.fullRightImage == null || this.fullRightImage.isDisposed()) {
            this.fullRightImage = this.createFullRightImage();
        }
        return this.fullRightImage;
    }

    private Image createFullRightImage() {
        Image timelineImage = this.createFullTimelineImage();
        Image taskBarImage = this.createFullTaskBarImage();
        Image image = null;
        if (timelineImage != null || taskBarImage != null) {
            image = new Image((Device)this.display, timelineImage == null ? 0 : timelineImage.getBounds().width, (timelineImage == null ? 0 : timelineImage.getBounds().height) + (taskBarImage == null ? 0 : taskBarImage.getBounds().height));
            GC gc = new GC((Drawable)image);
            try {
                if (timelineImage != null) {
                    gc.drawImage(timelineImage, 0, 0);
                }
                if (taskBarImage != null) {
                    gc.drawImage(taskBarImage, 0, timelineImage == null ? 0 : timelineImage.getBounds().height);
                }
            }
            finally {
                gc.dispose();
                timelineImage.dispose();
                taskBarImage.dispose();
            }
        }
        return image;
    }

    public Image createCutImage() {
        Image leftImage = this.getLeftImage();
        Image fullRightImage = this.getFullRightImage();
        int width = 0;
        int startX = 0;
        if (fullRightImage != null) {
            TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
            long startTime = this.settings.getLong("startTime");
            long endTime = this.settings.getLong("endTime");
            startX = timelineModel.getPixelsFromMillis(startTime - this.getMinTimeInMillis());
            if (startTime != endTime) {
                width = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
            }
        }
        Image image = new Image((Device)this.display, leftImage.getBounds().width + width, leftImage.getBounds().height);
        this.images.add(image);
        GC gc = new GC((Drawable)image);
        try {
            gc.drawImage(leftImage, 0, 0);
            if (width != 0) {
                int height = fullRightImage.getBounds().height;
                gc.drawImage(fullRightImage, startX, 0, width, height, leftImage.getBounds().width, 0, width, height);
            }
            gc.setLineWidth(1);
            gc.setForeground(this.display.getSystemColor(15));
            Rectangle bounds = image.getBounds();
            gc.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
        finally {
            gc.dispose();
        }
        return image;
    }

    public Image createPrintPreviewDetailedImage() {
        if (!this.checkImage()) {
            return null;
        }
        Image[][] images = this.getSingleImages2();
        int perWidth = images[0][0].getBounds().width;
        int width = perWidth * images[0].length;
        int perHeight = images[0][0].getBounds().height;
        int height = perHeight * images.length;
        Image detailedImage = new Image(images[0][0].getDevice(), width, height);
        this.images.add(detailedImage);
        GC gc = new GC((Drawable)detailedImage);
        try {
            int i = 0;
            while (i < images.length) {
                Image[] imageArr = images[i];
                int y = i * perHeight;
                int j = 0;
                while (j < imageArr.length) {
                    Image image = imageArr[j];
                    int x = j * perWidth;
                    gc.drawImage(image, x, y);
                    gc.setBackground(ColorUtils.getColor((String)"#000000"));
                    int lineWidth = Math.max(1, Math.max(width, height) / 500);
                    gc.setLineWidth(lineWidth);
                    gc.drawRectangle(x, y, image.getBounds().width - 1, image.getBounds().height - 1);
                    ++j;
                }
                ++i;
            }
        }
        finally {
            gc.dispose();
        }
        return detailedImage;
    }

    public Image[] getSingleImages() {
        if (!this.checkImage()) {
            return new Image[0];
        }
        Image[][] images = this.getSingleImages2();
        Image[] images2 = new Image[images.length * images[0].length];
        int i = 0;
        while (i < images.length) {
            int j = 0;
            while (j < images[0].length) {
                images2[i * images[0].length + j] = images[i][j];
                ++j;
            }
            ++i;
        }
        return images2;
    }

    private Image[][] getSingleImages2() {
        if (this.singleImages == null || this.singleImages[0] == null || this.singleImages[0][0] == null || this.singleImages[0][0].isDisposed()) {
            if (this.singleImages != null) {
                Image[][] imageArray = this.singleImages;
                int n = this.singleImages.length;
                int n2 = 0;
                while (n2 < n) {
                    Image[] images = imageArray[n2];
                    if (images != null) {
                        Image[] imageArray2 = images;
                        int n3 = images.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Image image = imageArray2[n4];
                            if (image != null) {
                                image.dispose();
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            this.singleImages = this.createSingleImages();
        }
        return this.singleImages;
    }

    private Image[][] createSingleImages() {
        int usefulPerPageHeightByRatio;
        int lines;
        int heightByRatio;
        double ratio;
        Insets margins = this.getPageMargins();
        Dimension pageBounds = this.getPageBounds();
        int headerHeight = PrintUtils.getHeaderHeight((IDialogSettings)this.settings, (int)120);
        int footerHeight = PrintUtils.getBottomHeight((IDialogSettings)this.settings, (int)120);
        int perPageWidth = pageBounds.width;
        int perPageHeight = pageBounds.height;
        int usefulPerPageWidth = perPageWidth - (margins.left + margins.right);
        int usefulPerPageHeight = perPageHeight - (margins.top + margins.bottom) - headerHeight - footerHeight;
        int widthPages = this.getInt("widthPages", 1);
        int heightPages = this.getInt("heightPages", 1);
        boolean isAspectRatio = this.settings.getBoolean("aspectRatioLocked");
        boolean fullWidth = !this.settings.getBoolean("fillHeight");
        Image headerImage = this.getHeaderImage();
        Rectangle headerBounds = headerImage.getBounds();
        Image contentImage = this.getContentImage();
        Rectangle contentBounds = contentImage.getBounds();
        if (!isAspectRatio) {
            double fillWidthratio = (double)usefulPerPageWidth * (double)widthPages / (double)contentBounds.width;
            double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentBounds.height + heightPages * headerBounds.height);
            int heightByRatio2 = (int)((double)usefulPerPageHeight / fillHeightRatio);
            int lines2 = (heightByRatio2 - headerBounds.height) / ExportConstants.ITEM_HEIGHT;
            lines2 = (heightByRatio2 - headerBounds.height) % ExportConstants.ITEM_HEIGHT == 0 ? lines2 : lines2 + 1;
            int usefulPerPageHeightByRatio2 = headerBounds.height + lines2 * ExportConstants.ITEM_HEIGHT;
            fillHeightRatio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio2;
            fullWidth = fillWidthratio <= fillHeightRatio;
        }
        int usefulWidthPages = widthPages;
        int usefulHeightPages = heightPages;
        if (fullWidth) {
            ratio = (double)usefulPerPageWidth * (double)widthPages / (double)contentBounds.width;
            heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            lines = (heightByRatio - headerBounds.height) / ExportConstants.ITEM_HEIGHT;
            usefulPerPageHeightByRatio = headerBounds.height + lines * ExportConstants.ITEM_HEIGHT;
            usefulHeightPages = contentBounds.height / (usefulPerPageHeightByRatio - headerBounds.height);
            usefulHeightPages = contentBounds.height % (usefulPerPageHeightByRatio - headerBounds.height) == 0 ? usefulHeightPages : usefulHeightPages + 1;
        } else {
            ratio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentBounds.height + heightPages * headerBounds.height);
            heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            lines = (heightByRatio - headerBounds.height) / ExportConstants.ITEM_HEIGHT;
            lines = (heightByRatio - headerBounds.height) % ExportConstants.ITEM_HEIGHT == 0 ? lines : lines + 1;
            usefulPerPageHeightByRatio = headerBounds.height + lines * ExportConstants.ITEM_HEIGHT;
            ratio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio;
            usefulWidthPages = contentBounds.width / (int)((double)usefulPerPageWidth / ratio);
            usefulWidthPages = contentBounds.width % (int)((double)usefulPerPageWidth / ratio) == 0 ? usefulWidthPages : usefulWidthPages + 1;
        }
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / ratio);
        Image[][] images = new Image[heightPages][widthPages];
        int j = 0;
        while (j < heightPages) {
            int y0 = j * (usefulPerPageHeightByRatio - headerBounds.height);
            int height = contentBounds.height - y0;
            height = Math.min(height, usefulPerPageHeightByRatio - headerBounds.height);
            int i = 0;
            while (i < widthPages) {
                int x0 = usefulPerPageWidthByRatio * i;
                int width = contentBounds.width - x0;
                width = Math.min(width, usefulPerPageWidthByRatio);
                Image image = new Image(headerImage.getDevice(), (int)((double)perPageWidth / ratio), (int)((double)perPageHeight / ratio));
                this.images.add(image);
                GC gc = new GC((Drawable)image);
                try {
                    boolean hasBorder;
                    int leftMarginByRatio = (int)((double)margins.left / ratio);
                    int topMarginByRation = (int)((double)(margins.top + headerHeight) / ratio);
                    if (i < usefulWidthPages && j < usefulHeightPages) {
                        gc.drawImage(headerImage, x0, 0, width, headerBounds.height, leftMarginByRatio, topMarginByRation, width, headerBounds.height);
                        if (height >= ExportConstants.ITEM_HEIGHT) {
                            gc.drawImage(contentImage, x0, y0, width, height, leftMarginByRatio, topMarginByRation + headerBounds.height, width, height);
                        }
                    }
                    boolean bl = hasBorder = !this.settings.getBoolean("noBorder");
                    if (hasBorder) {
                        gc.setLineWidth(1);
                        gc.setForeground(this.display.getSystemColor(2));
                        gc.drawRectangle(leftMarginByRatio, topMarginByRation, width, usefulPerPageHeightByRatio);
                    }
                }
                finally {
                    gc.dispose();
                }
                images[j][i] = image;
                ++i;
            }
            ++j;
        }
        return images;
    }

    protected Insets getPageMargins() {
        int leftMarginPixel = ExportConstants.toPixel(this.getDouble("leftMargin", 0.25));
        int rightMarginPixel = ExportConstants.toPixel(this.getDouble("rightMargin", 0.25));
        int topMarginPixel = ExportConstants.toPixel(this.getDouble("topMargin", 0.25));
        int bottomMarginPixel = ExportConstants.toPixel(this.getDouble("bottomMargin", 0.25));
        return new Insets(topMarginPixel, leftMarginPixel, bottomMarginPixel, rightMarginPixel);
    }

    protected Dimension getPageBounds() {
        int orientation = this.getInt("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        return new Dimension(perPageWidth, perPageHeight);
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return this.settings.getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private int getInt(String key, int defaultValue) {
        try {
            return this.settings.getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private long getMinTimeInMillis() {
        ITopic rootTopic = (ITopic)this.ganttViewer.getInput();
        Date minTime = TaskInfoUtils.getEarliestStartDate((ITopic)rootTopic);
        return minTime == null ? 0L : minTime.getTime();
    }

    private long getMaxTimeInMillis() {
        ITopic rootTopic = (ITopic)this.ganttViewer.getInput();
        Date maxTime = TaskInfoUtils.getLatestEndDate((ITopic)rootTopic);
        return maxTime == null ? 0L : maxTime.getTime();
    }

    public void releaseResource() {
        if (this.images != null) {
            Iterator<Image> ite = this.images.iterator();
            while (ite.hasNext()) {
                Image image = ite.next();
                if (image == null) continue;
                image.dispose();
                ite.remove();
                Object var2_2 = null;
            }
            this.images.clear();
        }
    }

    public void dispose() {
        this.releaseResource();
        if (this.headerImage != null) {
            this.headerImage.dispose();
        }
        if (this.contentImage != null) {
            this.contentImage.dispose();
        }
        if (this.leftImage != null) {
            this.leftImage.dispose();
        }
        if (this.fullRightImage != null) {
            this.fullRightImage.dispose();
        }
    }

    public void setHeaderImageValid(boolean isHeaderImageValid) {
        this.isHeaderImageValid = isHeaderImageValid;
    }

    public void setContentImageValid(boolean isContentImageValid) {
        this.isContentImageValid = isContentImageValid;
    }

    public boolean checkImage() {
        return !this.isImageLarge(100000000);
    }

    public boolean isImageLarge(int largeSize) {
        int sourceHeight;
        int sourceWidth;
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int leftWidth = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        int headerHeight = headerViewer.getCanvas().getSize().y;
        TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
        int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        int rightWidth = 0;
        if (startTime != endTime) {
            rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        return (sourceWidth = leftWidth + rightWidth) * (sourceHeight = headerHeight + contentHeight) > largeSize;
    }
}

