/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.share.jobs;

import java.io.File;
import java.util.Map;
import net.xmind.share.Info;
import net.xmind.share.Uploader;
import net.xmind.share.XmindSharePlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.xmind.core.net.IDataStore;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.net.internal.XMindNetRequest;
import org.xmind.core.net.util.LinkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadSession {
    public static final int INITIALIZED = 0;
    public static final int PREPARING = 1;
    public static final int UPLOADING = 2;
    public static final int COMPLETED = 3;
    public static final int CANCELING = 4;
    public static final int CANCELED = 5;
    public static final int CODE_VERIFICATION_FAILURE = 1001;
    public static final String URL_DATA_KEY = "url";
    public static final String FACEBOOK_URL_DATA_KEY = "facebook-url";
    public static final String TWITTER_URL_DATA_KEY = "twitter-url";
    public static final String LINKEDIN_URL_DATA_KEY = "linkedin-url";
    private static final boolean DEBUG = System.getProperty("org.xmind.debug.share") != null;
    private static final String UPLOAD_API = "/_fs/mapfile/%s";
    private static final String SESSION_API = "/_fs/mapfile/%s/%s";
    private String userName;
    private String authToken;
    private String title;
    private File sourceFile;
    private File svgFile;
    private String sessionId;
    private int status;
    private IStatus termination;
    private String permalink;
    private String viewLink;
    private double uploadProgress;
    private XMindNetRequest prepareRequest = null;
    private XMindNetRequest transferRequest = null;
    private XMindNetRequest retrieveProgressRequest = null;
    private Map<Object, Object> dataMap = null;
    private boolean isCnUser;

    public UploadSession(Info info) {
        this.userName = info.getString("UserID");
        Assert.isNotNull((Object)this.userName);
        this.authToken = info.getString("Token");
        Assert.isNotNull((Object)this.authToken);
        this.title = info.getString("Title");
        Assert.isNotNull((Object)this.title);
        this.sourceFile = (File)info.getProperty("File");
        Assert.isNotNull((Object)this.sourceFile);
        this.isCnUser = info.getBoolean("CnUser");
        this.setStatus(0);
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public String getPermalink() {
        return this.permalink;
    }

    public String getViewLink() {
        return this.viewLink;
    }

    public double getUploadProgress() {
        return this.uploadProgress;
    }

    public int getStatus() {
        return this.status;
    }

    public IStatus getError() {
        return this.termination;
    }

    public boolean hasError() {
        return this.termination != null && !this.termination.isOK();
    }

    public IStatus prepare() {
        this.setStatus(1);
        UploadSession.debug("[upload][prepare] userName=%s, authToken=%s, title=%s", this.userName, this.authToken, this.title);
        XMindNetRequest request = new XMindNetRequest();
        if (DEBUG) {
            request.debug();
        }
        this.prepareRequest = request;
        request.uri(LinkUtils.getLinkByUser((boolean)this.isCnUser, (boolean)true, (boolean)true, (String)EncodingUtils.format((String)UPLOAD_API, (Object[])new Object[]{this.userName})));
        request.setAuthToken(this.authToken);
        request.addParameter("title", (Object)this.title);
        request.post();
        if (request.isAborted()) {
            this.setStatus(5);
            return this.ok();
        }
        int code = request.getStatusCode();
        IDataStore data = request.getData();
        UploadSession.debug("[upload][prepare] response code=%s", code);
        UploadSession.debug("[upload][prepare] response text='%s'", request.getResponseText());
        if (code == 200 && data != null) {
            String sessionId = data.getString("session");
            if (sessionId == null) {
                return this.error(500, request.getResponseText());
            }
            this.sessionId = sessionId;
            this.permalink = data.getString(URL_DATA_KEY);
            String mapname = data.getString("mapname");
            this.dataMap = data.toMap();
            if (mapname != null) {
                this.viewLink = String.format(LinkUtils.getLinkByUser((boolean)this.isCnUser, (boolean)true, (boolean)true, (String)"/xmind/map/%s/%s/%s"), this.userName, this.authToken, mapname);
            }
            return this.ok();
        }
        return this.error(code, request.getError(), request.getResponseText());
    }

    public IStatus transfer() {
        this.setStatus(2);
        UploadSession.debug("[upload][transfer] userName=%s, sessionId=%s, sourceFile=%s", this.userName, this.sessionId, this.sourceFile.getAbsolutePath());
        Uploader.validateUploadFile(this.sourceFile.getAbsolutePath());
        XMindNetRequest request = new XMindNetRequest().multipart();
        if (DEBUG) {
            request.debug();
        }
        this.transferRequest = request;
        request.uri(LinkUtils.getLinkByUser((boolean)this.isCnUser, (boolean)true, (boolean)true, (String)EncodingUtils.format((String)SESSION_API, (Object[])new Object[]{this.userName, this.sessionId})));
        request.addParameter("map", (Object)this.sourceFile);
        if (this.svgFile != null && this.svgFile.exists()) {
            request.addParameter("svg", (Object)this.svgFile);
        }
        request.post();
        if (request.isAborted()) {
            this.setStatus(5);
            return this.ok();
        }
        int code = request.getStatusCode();
        UploadSession.debug("[upload][transfer] response code=%s", code);
        UploadSession.debug("[upload][transfer] response text=%s", request.getResponseText());
        if (code == 200) {
            return this.ok();
        }
        return this.error(code, request.getError(), request.getResponseText());
    }

    public IStatus retrieveProgress() {
        UploadSession.debug("[upload][progress] userName=%s, sessionId=%s", this.userName, this.sessionId);
        XMindNetRequest request = new XMindNetRequest();
        if (DEBUG) {
            request.debug();
        }
        this.retrieveProgressRequest = request;
        request.uri(LinkUtils.getLinkByUser((boolean)this.isCnUser, (boolean)true, (boolean)true, (String)EncodingUtils.format((String)SESSION_API, (Object[])new Object[]{this.userName, this.sessionId})));
        request.setAuthToken(this.authToken);
        request.get();
        if (request.isAborted()) {
            this.setStatus(5);
            return this.ok();
        }
        int code = request.getStatusCode();
        IDataStore data = request.getData();
        UploadSession.debug("[upload][progress] response code=%s", code);
        UploadSession.debug("[upload][progress] response text=%s", request.getResponseText());
        if (code == 200 && data != null) {
            String status = data.getString("status");
            if (status != null) {
                UploadSession.debug("[upload][progress] status=%s", status);
                if ("forbidden".equals(status)) {
                    return this.error(1001, request.getResponseText());
                }
                if ("error".equals(status)) {
                    return this.error(500, request.getResponseText());
                }
                if ("finished".equals(status)) {
                    this.setStatus(3);
                    return this.ok();
                }
            }
            this.uploadProgress = data.getDouble("progress");
            return this.ok();
        }
        return this.error(code, request.getError(), request.getResponseText());
    }

    public IStatus cancel() {
        if (this.prepareRequest != null) {
            this.prepareRequest.abort();
        }
        if (this.transferRequest != null) {
            this.transferRequest.abort();
        }
        if (this.retrieveProgressRequest != null) {
            this.retrieveProgressRequest.abort();
        }
        UploadSession.debug("[upload][cancel] userName=%s, sessionId=%s", this.userName, this.sessionId);
        if (this.sessionId == null) {
            return Status.CANCEL_STATUS;
        }
        this.setStatus(4);
        XMindNetRequest request = new XMindNetRequest();
        if (DEBUG) {
            request.debug();
        }
        request.uri(LinkUtils.getLinkByUser((boolean)this.isCnUser, (boolean)true, (boolean)true, (String)EncodingUtils.format((String)SESSION_API, (Object[])new Object[]{this.userName, this.sessionId})));
        request.setAuthToken(this.authToken);
        request.delete();
        if (request.isAborted()) {
            this.setStatus(5);
            return this.ok();
        }
        int code = request.getStatusCode();
        UploadSession.debug("[upload][cancel] response code=%s", code);
        UploadSession.debug("[upload][cancel] response text=%s", request.getResponseText());
        if (code == 200) {
            this.setStatus(5);
            return this.ok();
        }
        return this.error(code, request.getError(), request.getResponseText());
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private IStatus ok() {
        if (this.termination == null) {
            this.termination = Status.OK_STATUS;
        }
        return this.termination;
    }

    private IStatus error(int code, String message) {
        return this.error(code, null, message);
    }

    private IStatus error(int code, Throwable error, String message) {
        this.setError(code, error, message);
        return this.termination;
    }

    private void setError(int code, Throwable err, String message) {
        if (this.hasError() || this.status == 3 || this.status == 5) {
            return;
        }
        this.termination = UploadSession.createTermination(code, err, message);
    }

    private static IStatus createTermination(int code, Throwable err, String message) {
        return new Status(4, "com.xmindshare.uploader", code, message, err);
    }

    private static void debug(String message, Object ... values) {
        if (DEBUG) {
            XmindSharePlugin.log(String.format(message, values));
        }
    }

    public void setSvgFile(File svgFile) {
        this.svgFile = svgFile;
    }

    public Map<Object, Object> getDataMap() {
        return this.dataMap;
    }
}

