/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.ui.internal.auth;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import net.xmind.core.IAccount;
import net.xmind.signin.XMindNet;
import net.xmind.signin.internal.Activator;
import net.xmind.signin.internal.Messages;
import net.xmind.ui.internal.e4handlers.SignOutHandler;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.HttpRequest;
import org.xmind.core.net.http.IResponseHandler;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class AccountInfoDialog
extends Window {
    private static IPath avatarStorageLocation = null;
    private static final String COLOR_AVATAR_OUTLINE = "#A0A0A0";
    private static final int LEFT_AREA_WIDTH = 240;
    private static final int RIGHT_AREA_WIDTH = 480;
    private static final int AVATAR_WIDTH = 120;
    private static final int AVATAR_HEIGHT = 120;
    private static final String AVATAR_URL = "https://www.gravatar.com/avatar/%s?s=%s&d=404";
    private IAccount account;
    private boolean isCnUser;
    private ResourceManager resources;

    public AccountInfoDialog(Shell parentShell, IAccount account) {
        super(parentShell);
        this.account = account;
        this.isCnUser = account.isCnUser();
        this.setShellStyle(67680);
    }

    private boolean hasValidSubscription() {
        return this.account.hasValidSubscription();
    }

    private boolean proUser() {
        boolean proLicense;
        int type = XMindNet.getLicenseInfo().getType();
        boolean bl = proLicense = (type & 2) != 0;
        return this.hasValidSubscription() || proLicense;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.AccountInfoDialog_shellTitle);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().spacing(0, 0).numColumns(2).applyTo(composite);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        Control leftArea = this.createLeftArea(composite);
        GridDataFactory.fillDefaults().grab(false, true).align(4, 4).hint(240, -1).minSize(240, -1).applyTo(leftArea);
        Control rightArea = this.createRightArea(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).minSize(480, -1).applyTo(rightArea);
        return composite;
    }

    private Control createLeftArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(20, 20).spacing(0, 30).applyTo(composite);
        composite.setBackground(parent.getBackground());
        Control baseInfoArea = this.createBaseInfoArea(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo(baseInfoArea);
        Control settingsArea = this.createSettingsArea(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(settingsArea);
        return composite;
    }

    private Control createBaseInfoArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, 20).applyTo(composite);
        composite.setBackground(composite.getBackground());
        Control avatarLabel = this.createAvatarLabel(composite);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo(avatarLabel);
        String userName = (String)this.account.getProperty("user");
        Label nameLabel = new Label(composite, 0x1000000);
        nameLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontUtils.scaleHeight((FontDescriptor)JFaceResources.getDefaultFontDescriptor().withStyle(1), (float)1.2f)));
        nameLabel.setText(userName == null ? "" : userName);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, false).applyTo((Control)nameLabel);
        return composite;
    }

    private Control createSettingsArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().spacing(0, Util.isMac() ? 0 : 10).applyTo(composite);
        composite.setBackground(composite.getBackground());
        this.createLeftAreaButton(composite, Messages.AccountInfoDialog_accountSettings_button, new Runnable(){

            public void run() {
                XMindNet.gotoURL(LinkUtils.getLinkByUser((boolean)AccountInfoDialog.this.isCnUser, (boolean)true, (boolean)true, (String)"/xmind/account/%s/%s/settings"), (String)AccountInfoDialog.this.account.getProperty("user"), (String)AccountInfoDialog.this.account.getProperty("token"));
            }
        });
        if (this.hasValidSubscription()) {
            this.createLeftAreaButton(composite, Messages.AccountInfoDialog_manageSubscription_button, new Runnable(){

                public void run() {
                    XMindNet.gotoURL(LinkUtils.getLinkByUser((boolean)AccountInfoDialog.this.isCnUser, (boolean)true, (boolean)true, (String)"/xmind/account/%s/%s/subscription"), (String)AccountInfoDialog.this.account.getProperty("user"), (String)AccountInfoDialog.this.account.getProperty("token"));
                }
            });
        }
        this.createLeftAreaButton(composite, Messages.AccountInfoDialog_customerSupport_button, new Runnable(){

            public void run() {
                XMindNet.gotoURL(LinkUtils.getLinkByUser((boolean)AccountInfoDialog.this.isCnUser, (boolean)true, (boolean)false, (String)"/xmind/help/"), new Object[0]);
            }
        });
        Control lastButton = this.createLeftAreaButton(composite, Messages.AccountInfoDialog_signOut_button, new Runnable(){

            public void run() {
                Display.getCurrent().asyncExec(new Runnable(){

                    public void run() {
                        AccountInfoDialog.this.close();
                        SignOutHandler.signOut(AccountInfoDialog.this.account);
                    }
                });
            }
        });
        GridDataFactory.fillDefaults().align(4, 0x1000008).grab(true, true).applyTo(lastButton);
        return composite;
    }

    private Control createAvatarLabel(Composite composite) {
        final Canvas avatarLabel = new Canvas(composite, 524288);
        avatarLabel.setLayout(new Layout(){

            protected void layout(Composite composite, boolean flushCache) {
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(120, 120);
            }
        });
        avatarLabel.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).hint(120, 120).minSize(120, 120).grab(true, false).applyTo((Control)avatarLabel);
        final Image[] avatarImage = new Image[]{(Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("default_avatar.png"))};
        final Color lineColor = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_AVATAR_OUTLINE));
        avatarLabel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Control c = (Control)e.widget;
                Rectangle r = c.getBounds();
                Image image = avatarImage[0];
                if (image == null || image.isDisposed()) {
                    return;
                }
                Rectangle b = image.getBounds();
                AccountInfoDialog.this.drawAvatarImage(e.gc, image, b.width, b.height, r.width, r.height, 1.0f, lineColor);
            }
        });
        final String emailHash = (String)this.account.getProperty("emailhash");
        if (emailHash != null) {
            final Display display = Display.getCurrent();
            final Job job = Activator.getDefault().createJob(Messages.AccountInfoDialog_downloadAvatar_jobName, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AccountInfoDialog.this.doDownloadAvatarImage(monitor, emailHash, display, avatarImage, avatarLabel);
                }
            });
            job.schedule();
            avatarLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    job.cancel();
                }
            });
        }
        return avatarLabel;
    }

    private void drawAvatarImage(GC gc, Image image, float imageWidth, float imageHeight, float controlWidth, float controlHeight, float lineWidth, Color lineColor) {
        float widthScale = controlWidth / imageWidth;
        float heightScale = controlHeight / imageHeight;
        float scale = Math.min(widthScale, heightScale);
        Transform t = new Transform(gc.getDevice());
        try {
            t.scale(scale, scale);
            t.translate((controlWidth - scale * imageWidth) / 2.0f, (controlHeight - scale * imageHeight) / 2.0f);
            if (!t.isIdentity()) {
                gc.setTransform(t);
            }
            Path clipPath = new Path(gc.getDevice());
            try {
                clipPath.addArc(lineWidth / 2.0f, lineWidth / 2.0f, imageWidth - lineWidth, imageHeight - lineWidth, 0.0f, 360.0f);
                gc.setClipping(clipPath);
                gc.drawImage(image, 0, 0);
            }
            finally {
                gc.setClipping(null);
                clipPath.dispose();
            }
            gc.setAlpha(208);
            gc.setBackground(lineColor);
            clipPath = new Path(gc.getDevice());
            try {
                clipPath.addArc(0.0f, 0.0f, imageWidth, imageHeight, 0.0f, 360.0f);
                clipPath.addArc(lineWidth, lineWidth, imageWidth - lineWidth - lineWidth, imageHeight - lineWidth - lineWidth, 0.0f, -360.0f);
                gc.setClipping(clipPath);
                gc.fillRectangle(0, 0, (int)imageWidth, (int)imageHeight);
            }
            finally {
                gc.setClipping(null);
                clipPath.dispose();
            }
        }
        finally {
            gc.setTransform(null);
            t.dispose();
        }
    }

    private void doDownloadAvatarImage(IProgressMonitor monitor, final String emailHash, Display display, final Image[] images, final Canvas label) throws InvocationTargetException, InterruptedException {
        URL url;
        try {
            url = new URL(EncodingUtils.format((String)AVATAR_URL, (Object[])new Object[]{emailHash, 120}));
        }
        catch (MalformedURLException e) {
            throw new InvocationTargetException(e);
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        final File[] avatarFile = new File[]{null};
        HttpRequest request = new HttpRequest(url, "GET", null, null, null, new IResponseHandler(){

            public void handleResponseEntity(IProgressMonitor monitor, HttpRequest request, HttpEntity entity) throws InterruptedException, IOException {
                if (request.getStatusCode() == 200) {
                    File file;
                    avatarFile[0] = file = AccountInfoDialog.this.createAvatarStorageFile(emailHash, request);
                    entity.writeTo((OutputStream)new FileOutputStream(file));
                }
            }
        });
        try {
            request.execute(monitor);
        }
        catch (HttpException e) {
            if (e.getCode() == 404) {
                return;
            }
            throw new InvocationTargetException(e);
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        if (avatarFile[0] == null) {
            return;
        }
        if (label.isDisposed()) {
            return;
        }
        images[0] = new Image((Device)display, avatarFile[0].getAbsolutePath());
        if (label.isDisposed()) {
            images[0].dispose();
            return;
        }
        display.asyncExec(new Runnable(){

            public void run() {
                if (!label.isDisposed()) {
                    label.redraw();
                } else {
                    Image img = images[0];
                    if (img != null) {
                        img.dispose();
                    }
                }
            }
        });
    }

    private File createAvatarStorageFile(String emailHash, HttpRequest request) throws IOException {
        File file = avatarStorageLocation != null ? avatarStorageLocation.append(emailHash).toFile() : File.createTempFile(emailHash, "");
        File dir = file.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        return file;
    }

    private Control createLeftAreaButton(Composite parent, String text, final Runnable action) {
        Button button = new Button(parent, 0x1000008);
        button.setBackground(parent.getBackground());
        button.setText(text);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)button);
        Listener actionTriggerListener = new Listener(){

            public void handleEvent(Event event) {
                action.run();
            }
        };
        button.addListener(13, actionTriggerListener);
        button.addListener(14, actionTriggerListener);
        return button;
    }

    private Control createRightArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayoutFactory.fillDefaults().margins(20, 30).spacing(0, 0).applyTo(composite);
        Control topArea = this.proUser() ? this.createTopRightAreaForProMember(composite) : this.createTopRightAreaForFreeMember(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo(topArea);
        Control separatorLine = this.createSeparatorLine(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo(separatorLine);
        Control centerArea = this.createCenterRightArea(composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(centerArea);
        Composite bottomComposite = this.createBottomRightArea(composite);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000008).applyTo((Control)bottomComposite);
        return composite;
    }

    private Control createTopRightAreaForFreeMember(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().margins(0, 20).applyTo(composite);
        Label messageLabel = new Label(composite, 0x1000000);
        messageLabel.setBackground(composite.getBackground());
        messageLabel.setText(Messages.AccountInfoDialog_freeMember_text);
        messageLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontUtils.scaleHeight((FontDescriptor)JFaceResources.getDefaultFontDescriptor().setStyle(1), (float)1.6f)));
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(true, true).applyTo((Control)messageLabel);
        return composite;
    }

    private Control createTopRightAreaForProMember(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().spacing(0, 20).applyTo(composite);
        Label badgeLabel = new Label(composite, 0);
        badgeLabel.setBackground(composite.getBackground());
        badgeLabel.setImage((Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("badge_pro.png")));
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)badgeLabel);
        Label memberTypeLabel = new Label(composite, 0);
        memberTypeLabel.setBackground(composite.getBackground());
        memberTypeLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontUtils.scaleHeight((FontDescriptor)JFaceResources.getDefaultFontDescriptor().withStyle(1), (float)1.2f)));
        memberTypeLabel.setText(Messages.AccountInfoDialog_proMember_text);
        GridDataFactory.fillDefaults().grab(true, false).align(0x1000000, 0x1000000).applyTo((Control)memberTypeLabel);
        return composite;
    }

    private Control createSeparatorLine(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().margins(0, 20).applyTo(composite);
        Label separator = new Label(composite, 258);
        separator.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)separator);
        return composite;
    }

    private Control createCenterRightArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().extendedMargins(60, 0, 15, 55).numColumns(2).applyTo(composite);
        this.addFeatureLine(composite, Messages.AccountInfoDialog_export_feature);
        this.addFeatureLine(composite, Messages.AccountInfoDialog_themeEditor_feature);
        this.addFeatureLine(composite, Messages.AccountInfoDialog_brainstorming_feature);
        this.addFeatureLine(composite, Messages.AccountInfoDialog_presentation_feature);
        this.addFeatureLine(composite, Messages.AccountInfoDialog_gantt_feature);
        this.addFeatureLine(composite, Messages.AccountInfoDialog_password_feature);
        this.addFeatureLine(composite, Messages.AccountInfoDialog_microsoftProject_feature);
        this.addFeatureLine(composite, Messages.AccountInfoDialog_icons_feature);
        return composite;
    }

    private void addFeatureLine(Composite parent, String description) {
        Label checkedImage = new Label(parent, 0);
        checkedImage.setBackground(parent.getBackground());
        checkedImage.setImage((Image)this.resources.get((DeviceResourceDescriptor)Activator.getImageDescriptor("checked.png")));
        GridDataFactory.fillDefaults().grab(false, false).align(0x1000000, 0x1000000).applyTo((Control)checkedImage);
        Label descriptionLabel = new Label(parent, 64);
        descriptionLabel.setBackground(parent.getBackground());
        descriptionLabel.setText(description);
        descriptionLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)FontUtils.scaleHeight((FontDescriptor)JFaceResources.getDefaultFontDescriptor(), (float)1.1f)));
        GridDataFactory.fillDefaults().grab(true, false).align(16384, 0x1000000).applyTo((Control)descriptionLabel);
    }

    private Composite createBottomRightArea(Composite parent) {
        Composite bottomComposite = new Composite(parent, 0);
        bottomComposite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(this.proUser() ? 1 : 2).spacing(30, 0).applyTo(bottomComposite);
        this.createHyperlink(bottomComposite, Messages.AccountInfoDialog_viewProFeatures_hyperlink, new Runnable(){

            public void run() {
                XMindNet.gotoURL(LinkUtils.getLinkByUser((boolean)AccountInfoDialog.this.isCnUser, (boolean)true, (boolean)false, (String)"/xmind/features/"), new Object[0]);
            }
        });
        if (!this.proUser()) {
            this.createHyperlink(bottomComposite, Messages.AccountInfoDialog_upgrade_hyperlink, new Runnable(){

                public void run() {
                    XMindNet.gotoURL(LinkUtils.getLinkByUser((boolean)AccountInfoDialog.this.isCnUser, (boolean)true, (boolean)true, (String)"/xmind/buy/"), new Object[0]);
                }
            });
        }
        return bottomComposite;
    }

    private Hyperlink createHyperlink(Composite parent, String content, final Runnable action) {
        Hyperlink hyperlink = new Hyperlink(parent, 0);
        hyperlink.setBackground(parent.getBackground());
        hyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#006CF9")));
        hyperlink.setUnderlined(true);
        hyperlink.setText(content);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).grab(false, false).applyTo((Control)hyperlink);
        try {
            Field fPaintFocus = AbstractHyperlink.class.getDeclaredField("paintFocus");
            fPaintFocus.setAccessible(true);
            fPaintFocus.set(hyperlink, false);
        }
        catch (Throwable throwable) {}
        hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                action.run();
            }
        });
        return hyperlink;
    }

    public static void setAvatarStorageLocation(IPath path) {
        avatarStorageLocation = path;
    }
}

