/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.DragDetectEvent;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.command.SourceCommand;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.commands.DeleteTopicCommand;
import org.xmind.ui.internal.ideafactory.AddIdeaCommand;
import org.xmind.ui.internal.ideafactory.AddIdeaGroupCommand;
import org.xmind.ui.internal.ideafactory.AddIdeasToGroupCommand;
import org.xmind.ui.internal.ideafactory.DeleteIdeaCommand;
import org.xmind.ui.internal.ideafactory.DeleteIdeaGroupCommand;
import org.xmind.ui.internal.ideafactory.FontSizeConstants;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;
import org.xmind.ui.internal.ideafactory.IdeaTransfer;
import org.xmind.ui.internal.ideafactory.IdeaTransfer2;
import org.xmind.ui.internal.ideafactory.IdeaUtils;
import org.xmind.ui.internal.ideafactory.ModifyIdeaContentCommand;
import org.xmind.ui.internal.ideafactory.ModifyIdeaGroupTitleCommand;
import org.xmind.ui.internal.ideafactory.TransparentCornerLabel;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.SWTUtils;

public class IdeaFactoryViewer
extends StructuredViewer
implements ICoreEventListener {
    private static final Color COLOR_FG_SELECTED = ColorUtils.getColor((String)"#65c2f1");
    private static final Color COLOR_BG_SELECTED = ColorUtils.getColor((String)"#e0e1e2");
    private static final Color COLOR_FG_PRESELECTED = ColorUtils.getColor((String)"#dddddd");
    private static final Color COLOR_BG_PRESELECTED = ColorUtils.getColor((String)"#e0e1e2");
    private static final Color COLOR_FG_UNSELECTED = ColorUtils.getColor((String)"#dddddd");
    private static final Color COLOR_BG_UNSELECTED = ColorUtils.getColor((String)"#fafafa");
    private static final String CONTENT_LAYER_KEY = "contentLayer";
    private static final String FEEDBACK_LAYER_KEY = "feedbackLayer";
    private static final int TITLE_LENGTH = 12;
    private Composite composite;
    private FigureCanvas canvas;
    private EventHandler eventHandler;
    private IGraphicalEditor sourceEditor;
    private ITopicExtensionElement groupElement;
    private Label groupTitle;
    private Text ideasEntrance;
    private Figure ideaPool;
    private ICoreEventRegister register;
    private boolean showGroupTitle = true;
    private Map<IdeaFigure, ITopicExtensionElement> ideaToExelements = new HashMap<IdeaFigure, ITopicExtensionElement>();
    private int ideaFontHeight;
    private Label leftInsertFeedback;
    private Label rightInsertFeedback;
    private IdeaDropTargetHandler ideaDropTargetHandler;
    private ITopic rootTopic;
    private String createdGroupName;
    private String groupTitleText;
    private boolean isEditingGroupTitle = false;
    private ResourceManager resources;

    public IdeaFactoryViewer(Composite parent, boolean showGroupTitle) {
        this.showGroupTitle = showGroupTitle;
        IEditorPart targetEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.sourceEditor = targetEditor instanceof IGraphicalEditor ? (IGraphicalEditor)targetEditor : null;
        this.composite = this.createControl(parent);
    }

    private Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumWidth = 200;
        composite.setLayoutData((Object)gridData);
        if (this.showGroupTitle) {
            this.createGroupTitle(composite);
        } else {
            layout.marginHeight = 5;
        }
        this.createIdeaCreator(composite);
        this.createIdeaPool(composite);
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IdeaFactoryViewer.this.unregisterCoreEvent();
            }
        });
        return composite;
    }

    private void createGroupTitle(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 5;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)layoutData);
        layoutData.heightHint = 34;
        this.leftInsertFeedback = new Label(composite, 0);
        GridData gridData = new GridData(16384, 4, false, true);
        gridData.widthHint = 3;
        this.leftInsertFeedback.setLayoutData((Object)gridData);
        this.leftInsertFeedback.setBackground(ColorUtils.getColor((String)"#2f7dd9"));
        this.leftInsertFeedback.setVisible(false);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(composite2.getParent().getBackground());
        GridData layoutData2 = new GridData(0x1000000, 0x1000000, true, true);
        composite2.setLayoutData((Object)layoutData2);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 10;
        composite2.setLayout((Layout)layout2);
        this.groupTitle = new Label(composite2, 0);
        this.groupTitle.setBackground(composite2.getBackground());
        this.groupTitle.setForeground(ColorUtils.getColor((String)"#4a4a4a"));
        this.groupTitle.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.groupTitle.setCursor(composite2.getDisplay().getSystemCursor(19));
        final Font newFont = new Font((Device)composite2.getDisplay(), "Arial", 12, 0);
        this.groupTitle.setFont(newFont);
        this.groupTitle.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                newFont.dispose();
            }
        });
        this.createPullDownArrow(composite2);
        this.createGroupContextMenu((Control)composite);
        this.createGroupContextMenu((Control)composite2);
        this.createGroupContextMenu((Control)this.groupTitle);
        Listener mouseListener = new Listener(){

            public void handleEvent(Event event) {
                IdeaFactoryViewer.this.startEditingGroupTitle();
            }
        };
        composite.addListener(8, mouseListener);
        composite2.addListener(8, mouseListener);
        this.groupTitle.addListener(8, mouseListener);
        this.rightInsertFeedback = new Label(composite, 0);
        GridData gridData2 = new GridData(131072, 4, false, true);
        gridData2.widthHint = 3;
        this.rightInsertFeedback.setLayoutData((Object)gridData2);
        this.rightInsertFeedback.setBackground(ColorUtils.getColor((String)"#2f7dd9"));
        this.rightInsertFeedback.setVisible(false);
        this.groupTitle.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                if (IdeaFactoryViewer.this.groupTitle != null && !IdeaFactoryViewer.this.groupTitle.isDisposed()) {
                    boolean isOverlong = ((IdeaFactoryViewer)IdeaFactoryViewer.this).groupTitle.computeSize((int)-1, (int)-1).x - ((IdeaFactoryViewer)IdeaFactoryViewer.this).groupTitle.getSize().x > 0;
                    String tooltip = isOverlong ? IdeaFactoryViewer.this.groupTitle.getText() : null;
                    IdeaFactoryViewer.this.groupTitle.setToolTipText(tooltip);
                }
            }
        });
        final Color originalBackground = this.groupTitle.getBackground();
        this.groupTitle.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(org.eclipse.swt.events.MouseEvent e) {
            }

            public void mouseExit(org.eclipse.swt.events.MouseEvent e) {
                IdeaFactoryViewer.this.groupTitle.setBackground(originalBackground);
            }

            public void mouseEnter(org.eclipse.swt.events.MouseEvent e) {
                IdeaFactoryViewer.this.groupTitle.setBackground(ColorUtils.getColor((String)"#d7d7d8"));
            }
        });
    }

    private void createPullDownArrow(final Composite parent) {
        final Label pullDown = new Label(parent, 0);
        pullDown.setBackground(pullDown.getParent().getBackground());
        pullDown.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        pullDown.setImage((Image)this.resources.get((DeviceResourceDescriptor)AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.xmind.ui.ideafactory", (String)"icons/pull-down-nofocus.png")));
        pullDown.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(org.eclipse.swt.events.MouseEvent e) {
            }

            public void mouseExit(org.eclipse.swt.events.MouseEvent e) {
                pullDown.setImage((Image)IdeaFactoryViewer.this.resources.get((DeviceResourceDescriptor)AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.xmind.ui.ideafactory", (String)"icons/pull-down-nofocus.png")));
            }

            public void mouseEnter(org.eclipse.swt.events.MouseEvent e) {
                pullDown.setImage((Image)IdeaFactoryViewer.this.resources.get((DeviceResourceDescriptor)AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.xmind.ui.ideafactory", (String)"icons/pull-down-focus.png")));
            }
        });
        pullDown.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                org.eclipse.swt.graphics.Rectangle bounds = parent.getBounds();
                org.eclipse.swt.graphics.Point toDisplay = parent.getParent().toDisplay(bounds.x, bounds.y);
                Menu menu = parent.getMenu();
                menu.setLocation(toDisplay.x, toDisplay.y + bounds.height + 1);
                menu.setVisible(true);
            }

            public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
            }

            public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            }
        });
    }

    private void createGroupContextMenu(Control control) {
        MenuManager menuManager = new MenuManager();
        Action modifyGroupTitleAction = new Action(IdeaFactoryMessages.IdeaFactoryViewer_Action_Modify_Group){

            public void run() {
                this.setId("org.xmind.ui.ideafactory.modifyIdeaGroupTitle");
                IdeaFactoryViewer.this.startEditingGroupTitle();
            }
        };
        menuManager.add((IAction)modifyGroupTitleAction);
        Action deleteGroupAction = new Action(IdeaFactoryMessages.IdeaFactoryViewer_Action_Delete_Group){

            public void run() {
                this.setId("org.xmind.ui.ideafactory.addIdeaGroup");
                IdeaFactoryViewer.this.checkGroup();
                IdeaFactoryViewer.this.sourceEditor.getCommandStack().execute((Command)new DeleteIdeaGroupCommand(IdeaFactoryViewer.this.groupElement.getTopic(), IdeaFactoryViewer.this.groupElement));
            }
        };
        menuManager.add((IAction)deleteGroupAction);
        control.setMenu(menuManager.createContextMenu(control));
    }

    public void startEditingGroupTitle() {
        if (this.groupTitle == null || this.isEditingGroupTitle) {
            return;
        }
        if (this.groupTitleText.length() > 12) {
            this.groupTitle.setText(this.groupTitleText);
        }
        Composite composite = this.groupTitle.getParent();
        this.isEditingGroupTitle = true;
        composite.setVisible(false);
        ((GridData)composite.getLayoutData()).exclude = true;
        Composite parent = composite.getParent();
        final Text editor = new Text(parent, 2052);
        editor.setFont(this.groupTitle.getFont());
        editor.setText(this.groupTitle.getText());
        editor.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        editor.moveAbove((Control)composite);
        parent.layout();
        editor.selectAll();
        editor.setFocus();
        editor.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                IdeaFactoryViewer.this.finishEditingGroupTitle(editor);
            }
        });
        editor.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    IdeaFactoryViewer.this.finishEditingGroupTitle(editor);
                }
            }
        });
        editor.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    e.doit = false;
                    IdeaFactoryViewer.this.cancelEditingGroupTitle(editor);
                }
            }
        });
        final Listener mouseDownFilter = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget != editor && editor != null && !editor.isDisposed()) {
                    IdeaFactoryViewer.this.finishEditingGroupTitle(editor);
                }
            }
        };
        editor.getDisplay().addFilter(3, mouseDownFilter);
        editor.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                editor.getDisplay().removeFilter(3, mouseDownFilter);
            }
        });
    }

    private void finishEditingGroupTitle(Text editor) {
        if (this.groupTitle == null) {
            return;
        }
        Composite composite = this.groupTitle.getParent();
        String newTitle = editor.getText();
        String oldTitle = this.groupTitle.getText();
        editor.dispose();
        composite.setVisible(true);
        ((GridData)composite.getLayoutData()).exclude = false;
        if (newTitle != null && !newTitle.equals(oldTitle)) {
            if ("".equals(newTitle)) {
                this.cancelEditingGroupTitle(editor);
                return;
            }
            this.checkGroup();
            this.sourceEditor.getCommandStack().execute((Command)new ModifyIdeaGroupTitleCommand(this.groupElement.getTopic(), this.groupElement, newTitle));
        } else if (this.groupTitleText.length() > 12) {
            this.groupTitle.setText(String.valueOf(this.groupTitleText.substring(0, 11)) + "...");
        }
        composite.getParent().layout();
        this.isEditingGroupTitle = false;
    }

    private void cancelEditingGroupTitle(Text editor) {
        if (this.groupTitle == null) {
            return;
        }
        Composite composite = this.groupTitle.getParent();
        editor.dispose();
        composite.setVisible(true);
        ((GridData)composite.getLayoutData()).exclude = false;
        composite.getParent().layout();
        this.isEditingGroupTitle = false;
    }

    private void createIdeaCreator(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        composite.setLayoutData((Object)layoutData);
        final Composite border = new Composite(composite, 0);
        border.setLayoutData((Object)new GridData(1808));
        GridLayout layout2 = new GridLayout();
        layout2.marginWidth = 1;
        layout2.marginHeight = 1;
        border.setLayout((Layout)layout2);
        final Color unselectedColor = ColorUtils.getColor((String)"#d5d5d5");
        final Color selectedColor = ColorUtils.getColor((String)"#0078d7");
        border.setBackground(unselectedColor);
        this.ideasEntrance = new Text(border, 16384);
        final Font font = new Font((Device)border.getDisplay(), "Arial", 13, 0);
        this.ideasEntrance.setFont(font);
        this.ideasEntrance.forceFocus();
        this.ideasEntrance.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        GridData textLayoutData = new GridData(4, 4, true, true);
        textLayoutData.heightHint = 28;
        this.ideasEntrance.setLayoutData((Object)textLayoutData);
        this.ideasEntrance.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String ideaContent;
                if (SWTUtils.matchKey((int)e.stateMask, (int)e.keyCode, (int)0, (int)13) && (ideaContent = IdeaFactoryViewer.this.ideasEntrance.getText()).length() != 0) {
                    IdeaFactoryViewer.this.checkGroup();
                    ICommandStack commandStack = IdeaFactoryViewer.this.sourceEditor.getCommandStack();
                    AddIdeaCommand command = null;
                    if (IdeaFactoryViewer.this.groupElement == null) {
                        String groupName = NLS.bind((String)IdeaFactoryMessages.IdeaFactoryViewer_Group_Name, (Object)1);
                        command = new AddIdeaCommand(IdeaFactoryViewer.this.findMindMap().getSheet().getRootTopic(), groupName, ideaContent);
                    } else {
                        command = new AddIdeaCommand(IdeaFactoryViewer.this.groupElement, ideaContent);
                    }
                    commandStack.execute((Command)command);
                    if (IdeaFactoryViewer.this.ideasEntrance != null && !IdeaFactoryViewer.this.ideasEntrance.isDisposed()) {
                        IdeaFactoryViewer.this.ideasEntrance.setText("");
                    }
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (IdeaFactoryViewer.this.ideasEntrance != null && !IdeaFactoryViewer.this.ideasEntrance.isDisposed()) {
                    IdeaFactoryViewer.this.ideasEntrance.addFocusListener(new FocusListener(){

                        public void focusLost(FocusEvent e) {
                            if (border != null && !border.isDisposed()) {
                                border.setBackground(unselectedColor);
                            }
                        }

                        public void focusGained(FocusEvent e) {
                            if (border != null && !border.isDisposed()) {
                                border.setBackground(selectedColor);
                            }
                        }
                    });
                }
            }
        });
    }

    private void createIdeaPool(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 7;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(ColorUtils.getColor((String)"#e1e1e1"));
        composite2.setLayoutData((Object)new GridData(1808));
        GridLayout layout2 = new GridLayout();
        layout2.marginWidth = 1;
        layout2.marginHeight = 1;
        composite2.setLayout((Layout)layout2);
        this.canvas = new FigureCanvas(composite2);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        final IdeaFigure ideaSample = new IdeaFigure("");
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                ScrollBar scrollBar = IdeaFactoryViewer.this.canvas.getVerticalBar();
                if (((IdeaFactoryViewer)IdeaFactoryViewer.this).canvas.getBounds().height >= scrollBar.getMaximum() - ideaSample.getBounds().height - 8) {
                    IdeaFactoryViewer.this.canvas.setVerticalScrollBarVisibility(FigureCanvas.AUTOMATIC);
                } else {
                    IdeaFactoryViewer.this.canvas.setVerticalScrollBarVisibility(FigureCanvas.ALWAYS);
                }
            }
        });
        this.canvas.setHorizontalScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#e9e9e9")));
        ScrollBar horizontalBar = this.canvas.getHorizontalBar();
        if (horizontalBar != null && !horizontalBar.isDisposed()) {
            horizontalBar.setEnabled(false);
            horizontalBar.setVisible(false);
        }
        this.eventHandler = new EventHandler();
        this.eventHandler.install((Control)this.canvas);
        this.canvas.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                IdeaFactoryViewer.this.eventHandler.uninstall((Control)IdeaFactoryViewer.this.canvas);
            }
        });
        this.createContextMenu();
        this.eventHandler.createDragSource((Control)this.canvas);
        this.ideaDropTargetHandler = new IdeaDropTargetHandler();
        this.ideaDropTargetHandler.createDropTarget((Control)this.canvas);
        Viewport viewport = new Viewport(true);
        viewport.setContentsTracksHeight(true);
        viewport.setContentsTracksWidth(true);
        this.canvas.setViewport(viewport);
        LayeredPane layeredPane = new LayeredPane();
        this.canvas.setContents((IFigure)layeredPane);
        Layer contentLayer = new Layer();
        contentLayer.setLayoutManager((LayoutManager)new StackLayout());
        layeredPane.add((IFigure)contentLayer, (Object)CONTENT_LAYER_KEY, -1);
        Layer feedbackLayer = new Layer();
        feedbackLayer.setLayoutManager((LayoutManager)new XYLayout());
        layeredPane.add((IFigure)feedbackLayer, (Object)FEEDBACK_LAYER_KEY, -1);
        this.ideaPool = new Figure();
        this.ideaPool.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        FlowLayout ideaLayout = new FlowLayout();
        ideaLayout.setMinorAlignment(0);
        ideaLayout.setMinorSpacing(10);
        ideaLayout.setMajorSpacing(6);
        this.ideaPool.setLayoutManager((LayoutManager)ideaLayout);
        contentLayer.add((IFigure)this.ideaPool);
        this.loadOldIdeas();
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this.eventHandler);
        Menu menu = menuManager.createContextMenu((Control)this.canvas);
        this.canvas.setMenu(menu);
    }

    private void loadOldIdeas() {
        if (this.groupElement == null && this.rootTopic == null) {
            return;
        }
        this.setGroupTitle(this.createdGroupName == null ? this.groupElement.getTextContent() : this.createdGroupName);
        List<ITopicExtensionElement> ideas = null;
        ideas = this.groupElement != null ? IdeaUtils.getGroupIdeas(this.groupElement) : IdeaUtils.getNoGroupIdeas(this.rootTopic);
        for (ITopicExtensionElement idea : ideas) {
            IdeaFigure ideaFigure = new IdeaFigure(idea.getTextContent());
            org.eclipse.draw2d.Label tooltip = new org.eclipse.draw2d.Label(idea.getTextContent());
            tooltip.setFont(FontUtils.getNewHeight((Font)JFaceResources.getDefaultFont(), (int)9));
            ideaFigure.setToolTip((IFigure)tooltip);
            ideaFigure.setForegroundColor(COLOR_FG_UNSELECTED);
            ideaFigure.setBackgroundColor(COLOR_BG_UNSELECTED);
            this.ideaPool.add((IFigure)ideaFigure);
            this.ideaToExelements.put(ideaFigure, idea);
            this.eventHandler.attach((IFigure)ideaFigure);
        }
        this.updateFontSize();
    }

    private void setGroupTitle(String groupTitleText) {
        this.groupTitleText = groupTitleText;
        if (this.groupTitle == null) {
            return;
        }
        if (groupTitleText == null) {
            groupTitleText = "";
        }
        if (groupTitleText.length() > 12) {
            this.groupTitle.setText(String.valueOf(this.groupTitleText.substring(0, 11)) + "...");
        } else {
            this.groupTitle.setText(groupTitleText);
        }
    }

    public Label getGroupTitle() {
        return this.groupTitle;
    }

    public Label getLeftInsertFeedback() {
        return this.leftInsertFeedback;
    }

    public Label getRightInsertFeedback() {
        return this.rightInsertFeedback;
    }

    public Text getIdeasEntrance() {
        return this.ideasEntrance;
    }

    protected void internalRefresh(Object element) {
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List getSelectionFromWidget() {
        return null;
    }

    public void reveal(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Control getControl() {
        return this.canvas;
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.ideaPool.removeAll();
        this.ideaToExelements.clear();
        this.registerCoreEvent();
        this.loadOldIdeas();
    }

    private void registerCoreEvent() {
        if (this.getInput() == null) {
            return;
        }
        ITopic centralTopic = null;
        Object input = this.getInput();
        if (input instanceof ITopicExtensionElement) {
            this.groupElement = (ITopicExtensionElement)input;
            this.rootTopic = centralTopic = this.groupElement.getTopic();
        } else if (input instanceof ITopic) {
            centralTopic = this.rootTopic = (ITopic)input;
        }
        if (centralTopic != null) {
            if (this.register != null) {
                this.register.unregisterAll();
            } else {
                this.register = new CoreEventRegister((ICoreEventListener)this);
            }
            if (centralTopic != null && centralTopic instanceof ICoreEventSource) {
                this.register.setNextSource((ICoreEventSource)centralTopic);
                this.register.register("ideaAdded");
                this.register.register("ideaDeleted");
                this.register.register("ideaModified");
                this.register.register("ideaGroupTitle");
                this.register.register("addIdeasToGroup");
                this.register.register("removeIdeasFromGroup");
            }
        }
    }

    private void unregisterCoreEvent() {
        if (this.register != null) {
            this.register.unregisterAll();
            this.register = null;
        }
    }

    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        Object target = event.getTarget();
        int index = event.getIndex();
        if (target == null || !(target instanceof ITopicExtensionElement)) {
            return;
        }
        ITopicExtensionElement targetElement = (ITopicExtensionElement)target;
        if ("addIdeasToGroup".equals(type) && this.groupElement == null) {
            this.groupElement = targetElement;
            return;
        }
        if ("removeIdeasFromGroup".equals(type) && this.groupElement == targetElement) {
            this.setCreatedGroupName(this.groupTitleText);
            this.groupElement = null;
            return;
        }
        if (this.groupElement == null) {
            return;
        }
        String groupId = this.groupElement.getAttribute("id");
        String ideaGroupId = targetElement.getAttribute("group_id");
        if ("ideaAdded".equals(type) && ideaGroupId != null && groupId.equals(ideaGroupId)) {
            IdeaFigure ideaFigure = new IdeaFigure(targetElement.getTextContent());
            ideaFigure.setForegroundColor(COLOR_FG_UNSELECTED);
            ideaFigure.setBackgroundColor(COLOR_BG_UNSELECTED);
            org.eclipse.draw2d.Label tooltip = new org.eclipse.draw2d.Label(targetElement.getTextContent());
            ideaFigure.setFontSize(this.ideaFontHeight);
            int tooltipHeight = FontSizeConstants.TOOLTIP_FONT_SIZE_LIST.get(FontSizeConstants.IDEA_FONT_SIZE_LIST.indexOf(this.ideaFontHeight));
            tooltip.setFont(FontUtils.getNewHeight((Font)ideaFigure.getFont(), (int)tooltipHeight));
            ideaFigure.setToolTip((IFigure)tooltip);
            this.ideaPool.add((IFigure)ideaFigure, index);
            this.ideaToExelements.put(ideaFigure, targetElement);
            this.eventHandler.attach((IFigure)ideaFigure);
            this.showFigure(ideaFigure);
        } else if ("ideaDeleted".equals(type) && this.ideaToExelements.values().contains(targetElement)) {
            Set<IdeaFigure> keys = this.ideaToExelements.keySet();
            for (IdeaFigure ideaFigure : keys) {
                if (this.ideaToExelements.get((Object)ideaFigure) != targetElement) continue;
                this.ideaPool.remove((IFigure)ideaFigure);
                this.ideaToExelements.remove((Object)ideaFigure);
                this.eventHandler.detach((IFigure)ideaFigure);
                return;
            }
        } else if ("ideaModified".equals(type) && ideaGroupId != null && groupId.equals(ideaGroupId)) {
            Set<IdeaFigure> keys = this.ideaToExelements.keySet();
            for (IdeaFigure ideaFigure : keys) {
                if (this.ideaToExelements.get((Object)ideaFigure) != targetElement) continue;
                ideaFigure.setText(targetElement.getTextContent());
                this.showFigure(ideaFigure);
                return;
            }
        } else if ("ideaGroupTitle".equals(type) && targetElement == this.groupElement && this.groupElement == targetElement) {
            this.setGroupTitle(targetElement.getTextContent());
        }
    }

    private void showFigure(final IdeaFigure ideaFigure) {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                Viewport viewport = IdeaFactoryViewer.this.canvas.getViewport();
                int value = viewport.getVerticalRangeModel().getValue();
                int min = ideaFigure.getLocation().y + ideaFigure.getSize().height + 5 - viewport.getSize().height;
                int max = ideaFigure.getLocation().y - 5;
                if (value < min) {
                    viewport.setVerticalLocation(min);
                } else if (value > max) {
                    viewport.setVerticalLocation(max);
                }
            }
        });
    }

    private IMindMap findMindMap() {
        Object o;
        if (this.sourceEditor == null) {
            return null;
        }
        IGraphicalEditorPage page = this.sourceEditor.getActivePageInstance();
        if (page == null) {
            return null;
        }
        Object input = page.getInput();
        if (input instanceof IMindMap) {
            return (IMindMap)input;
        }
        if (input instanceof IAdaptable && (o = ((IAdaptable)input).getAdapter(IMindMap.class)) instanceof IMindMap) {
            return (IMindMap)o;
        }
        return (IMindMap)page.getAdapter(IMindMap.class);
    }

    public void setIdeasFontSize(int height) {
        if (this.ideaFontHeight != height) {
            this.ideaFontHeight = height;
            this.updateFontSize();
        }
    }

    private void updateFontSize() {
        if (this.ideaFontHeight != 0 && this.ideaPool != null) {
            for (Object child : this.ideaPool.getChildren()) {
                if (!(child instanceof IdeaFigure)) continue;
                ((IdeaFigure)((Object)child)).setFontSize(this.ideaFontHeight);
                int tooltipHeight = FontSizeConstants.TOOLTIP_FONT_SIZE_LIST.get(FontSizeConstants.IDEA_FONT_SIZE_LIST.indexOf(this.ideaFontHeight));
                IFigure tooltip = ((IdeaFigure)((Object)child)).getToolTip();
                tooltip.setFont(FontUtils.getNewHeight((Font)tooltip.getFont(), (int)tooltipHeight));
            }
            this.canvas.layout();
        }
    }

    public IdeaDropTargetHandler getIdeaDropTargetHandler() {
        return this.ideaDropTargetHandler;
    }

    public void setCreatedGroupName(String createdGroupName) {
        this.createdGroupName = createdGroupName;
    }

    public void checkGroup() {
        if (this.groupElement != null) {
            return;
        }
        if (this.rootTopic == null) {
            return;
        }
        List<ITopicExtensionElement> noGroupIdeas = IdeaUtils.getNoGroupIdeas(this.rootTopic);
        if (noGroupIdeas.size() == 0) {
            return;
        }
        AddIdeasToGroupCommand addIdeasToGroupCommand = new AddIdeasToGroupCommand(this.rootTopic, this.createdGroupName, noGroupIdeas);
        this.sourceEditor.getCommandStack().execute((Command)addIdeasToGroupCommand);
    }

    public ITopicExtensionElement getGroupElement() {
        return this.groupElement;
    }

    private void ensureGroup() {
        this.checkGroup();
        if (this.groupElement == null) {
            String groupName = NLS.bind((String)IdeaFactoryMessages.IdeaFactoryViewer_Group_Name, (Object)1);
            AddIdeaGroupCommand addIdeaGroupCommand = new AddIdeaGroupCommand(this.findMindMap().getSheet().getRootTopic(), groupName);
            this.sourceEditor.getCommandStack().execute((Command)addIdeaGroupCommand);
            this.groupElement = addIdeaGroupCommand.getCreatedGroupElement();
        }
    }

    private org.eclipse.swt.graphics.Point toViewportLocation(org.eclipse.swt.graphics.Point point) {
        Point viewLocation = this.canvas.getViewport().getViewLocation();
        return new org.eclipse.swt.graphics.Point(viewLocation.x + point.x, viewLocation.y + point.y);
    }

    private class EventHandler
    implements MouseListener,
    MouseMotionListener,
    DragDetectListener,
    Listener,
    IMenuListener {
        private IdeaFigure lastSelected;
        private Set<IdeaFigure> currentSelected = new HashSet<IdeaFigure>();
        private boolean isBoxSelecting = false;
        private org.eclipse.swt.graphics.Point boxSelectStart;
        private TransparentCornerLabel boxSelectBorder;
        private List<IdeaFigure> backupSelected = new ArrayList<IdeaFigure>();
        private boolean isBoxSelectCancelMouseNotUp;

        private EventHandler() {
        }

        public void attach(IFigure figure) {
            figure.addMouseListener((MouseListener)this);
            figure.addMouseMotionListener((MouseMotionListener)this);
        }

        public void detach(IFigure figure) {
            figure.removeMouseListener((MouseListener)this);
            figure.removeMouseMotionListener((MouseMotionListener)this);
        }

        public void install(Control control) {
            control.addListener(4, (Listener)this);
            control.addListener(1, (Listener)this);
            control.addListener(5, (Listener)this);
            control.addListener(31, (Listener)this);
            control.addListener(16, (Listener)this);
            control.addDragDetectListener((DragDetectListener)this);
        }

        public void uninstall(Control control) {
            control.removeListener(4, (Listener)this);
            control.removeListener(1, (Listener)this);
            control.removeListener(5, (Listener)this);
            control.removeListener(31, (Listener)this);
            control.removeListener(16, (Listener)this);
            control.removeDragDetectListener((DragDetectListener)this);
        }

        public void mouseDoubleClicked(MouseEvent me) {
            IdeaFactoryViewer.this.canvas.setFocus();
            Object source = me.getSource();
            if (source instanceof IdeaFigure) {
                IdeaFigure ideaSelected = (IdeaFigure)((Object)source);
                this.startEditingIdea(ideaSelected);
            }
        }

        public void mousePressed(MouseEvent me) {
            IdeaFactoryViewer.this.canvas.setFocus();
            Object source = me.getSource();
            if (source instanceof IdeaFigure) {
                IdeaFigure ideaSelected = (IdeaFigure)((Object)source);
                boolean isContains = this.currentSelected.contains((Object)ideaSelected);
                if (me.getState() == SWT.MOD2) {
                    ArrayList<IdeaFigure> ideas = new ArrayList<IdeaFigure>();
                    for (Object child : IdeaFactoryViewer.this.ideaPool.getChildren()) {
                        if (!(child instanceof IdeaFigure)) continue;
                        ideas.add((IdeaFigure)((Object)child));
                    }
                    if (ideas.size() != 0) {
                        int index1 = 0;
                        if (this.lastSelected != null && ideas.contains((Object)this.lastSelected)) {
                            index1 = ideas.indexOf((Object)this.lastSelected);
                        }
                        int index2 = 0;
                        if (ideas.contains((Object)ideaSelected)) {
                            index2 = ideas.indexOf((Object)ideaSelected);
                        }
                        ArrayList<IdeaFigure> selecteds = new ArrayList<IdeaFigure>();
                        int start = Math.min(index1, index2);
                        int end = Math.max(index1, index2);
                        int i = start;
                        while (i <= end) {
                            selecteds.add((IdeaFigure)((Object)ideas.get(i)));
                            ++i;
                        }
                        for (IdeaFigure oldSelected : this.currentSelected) {
                            if (selecteds.contains((Object)oldSelected)) continue;
                            oldSelected.setForegroundColor(COLOR_FG_UNSELECTED);
                            oldSelected.setBackgroundColor(COLOR_BG_UNSELECTED);
                        }
                        for (IdeaFigure selected : selecteds) {
                            if (this.currentSelected.contains((Object)selected)) continue;
                            selected.setForegroundColor(COLOR_FG_SELECTED);
                            selected.setBackgroundColor(COLOR_BG_SELECTED);
                        }
                        this.currentSelected.clear();
                        this.currentSelected.addAll(selecteds);
                    }
                } else if (me.getState() == SWT.MOD1 && isContains) {
                    ideaSelected.setForegroundColor(COLOR_FG_UNSELECTED);
                    ideaSelected.setBackgroundColor(COLOR_BG_UNSELECTED);
                    this.currentSelected.remove((Object)ideaSelected);
                } else {
                    if (me.getState() != SWT.MOD1 && !isContains) {
                        if (!this.currentSelected.isEmpty()) {
                            for (IdeaFigure oldSelected : this.currentSelected) {
                                oldSelected.setForegroundColor(COLOR_FG_UNSELECTED);
                                oldSelected.setBackgroundColor(COLOR_BG_UNSELECTED);
                            }
                        }
                        this.currentSelected.clear();
                    }
                    this.currentSelected.add(ideaSelected);
                    ideaSelected.setForegroundColor(COLOR_FG_SELECTED);
                    ideaSelected.setBackgroundColor(COLOR_BG_SELECTED);
                }
                this.lastSelected = ideaSelected;
            }
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDragged(MouseEvent arg0) {
        }

        public void mouseEntered(MouseEvent me) {
            Object source = me.getSource();
            if (source instanceof IdeaFigure) {
                IdeaFigure ideaEntered = (IdeaFigure)((Object)source);
                IFigure toolTip = ideaEntered.getToolTip();
                if (toolTip != null) {
                    toolTip.setVisible(true);
                }
                ideaEntered.setCursor(Cursors.HAND);
                if (!this.currentSelected.contains((Object)ideaEntered)) {
                    ideaEntered.setForegroundColor(COLOR_FG_PRESELECTED);
                    ideaEntered.setBackgroundColor(COLOR_BG_PRESELECTED);
                }
            }
        }

        public void mouseExited(MouseEvent me) {
            Object source = me.getSource();
            if (source instanceof IdeaFigure) {
                IdeaFigure ideaExited = (IdeaFigure)((Object)source);
                ideaExited.setCursor(Cursors.ARROW);
                if (!this.currentSelected.contains((Object)ideaExited)) {
                    ideaExited.setForegroundColor(COLOR_FG_UNSELECTED);
                    ideaExited.setBackgroundColor(COLOR_BG_UNSELECTED);
                }
            }
        }

        public void mouseHover(MouseEvent arg0) {
        }

        public void mouseMoved(MouseEvent arg0) {
        }

        public void handleEvent(Event event) {
            if (event.type == 1) {
                IAction pasteAction;
                if (IdeaFactoryViewer.this.groupElement == null && IdeaFactoryViewer.this.rootTopic == null) {
                    return;
                }
                ICommandStack commandStack = IdeaFactoryViewer.this.sourceEditor.getCommandStack();
                if (event.keyCode == 127 || event.keyCode == 8) {
                    if (!this.currentSelected.isEmpty()) {
                        IdeaFactoryViewer.this.checkGroup();
                        ArrayList<DeleteIdeaCommand> commands = new ArrayList<DeleteIdeaCommand>();
                        for (IdeaFigure ideaFigure : this.currentSelected) {
                            ITopicExtensionElement deletedIdea = (ITopicExtensionElement)IdeaFactoryViewer.this.ideaToExelements.get((Object)ideaFigure);
                            if (deletedIdea == null) continue;
                            DeleteIdeaCommand deleteIdeaCommand = new DeleteIdeaCommand(IdeaFactoryViewer.this.groupElement.getTopic(), deletedIdea);
                            commands.add(deleteIdeaCommand);
                        }
                        this.currentSelected.clear();
                        if (commands.isEmpty()) {
                            return;
                        }
                        commandStack.execute((Command)new CompoundCommand(commands));
                    }
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)SWT.MOD1, (int)97)) {
                    this.currentSelected.clear();
                    for (Object objSelected : IdeaFactoryViewer.this.ideaPool.getChildren()) {
                        if (!(objSelected instanceof IdeaFigure)) continue;
                        IdeaFigure ideaSelected = (IdeaFigure)((Object)objSelected);
                        ideaSelected.setForegroundColor(COLOR_FG_SELECTED);
                        ideaSelected.setBackgroundColor(COLOR_BG_SELECTED);
                        this.currentSelected.add(ideaSelected);
                    }
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)SWT.MOD1, (int)122)) {
                    if (commandStack.canUndo()) {
                        commandStack.undo();
                    }
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)SWT.MOD1, (int)121)) {
                    if (commandStack.canRedo()) {
                        commandStack.redo();
                    }
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)SWT.MOD1, (int)120)) {
                    IAction cutAction = this.createCutIdeasAction();
                    if (cutAction != null && cutAction.isEnabled()) {
                        cutAction.run();
                    }
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)SWT.MOD1, (int)99)) {
                    IAction copyAction = this.createCopyIdeasAction();
                    if (copyAction != null && copyAction.isEnabled()) {
                        copyAction.run();
                    }
                } else if (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)SWT.MOD1, (int)118) && (pasteAction = this.createPasteIdeasAction()) != null && pasteAction.isEnabled()) {
                    pasteAction.run();
                }
            } else if (event.type == 4) {
                if (this.isBoxSelectCancelMouseNotUp) {
                    this.isBoxSelectCancelMouseNotUp = false;
                } else if (!this.isBoxSelecting) {
                    IFigure target = IdeaFactoryViewer.this.ideaPool.findMouseEventTargetAt(event.x, event.y);
                    if (target == null) {
                        if (!this.currentSelected.isEmpty()) {
                            for (IdeaFigure oldSelected : this.currentSelected) {
                                oldSelected.setForegroundColor(COLOR_FG_UNSELECTED);
                                oldSelected.setBackgroundColor(COLOR_BG_UNSELECTED);
                            }
                        }
                        this.currentSelected.clear();
                    }
                } else {
                    this.isBoxSelecting = false;
                    this.boxSelectBorder.setVisible(false);
                }
            } else if (event.type == 5) {
                if (this.isBoxSelecting) {
                    Rectangle boxBounds = new Rectangle(Math.min(event.x, this.boxSelectStart.x), Math.min(event.y, this.boxSelectStart.y), Math.abs(event.x - this.boxSelectStart.x), Math.abs(event.y - this.boxSelectStart.y));
                    if (this.boxSelectBorder == null) {
                        this.boxSelectBorder = new TransparentCornerLabel();
                        this.boxSelectBorder.setBorder((Border)new LineBorder(ColorUtils.getColor((String)"#5353a7"), 1));
                        this.boxSelectBorder.setOpaque(true);
                        this.boxSelectBorder.setBackgroundColor(ColorUtils.getColor((String)"#dfdfea"));
                        this.boxSelectBorder.setAlpha(80);
                        Layer feedbackLayer = ((LayeredPane)IdeaFactoryViewer.this.canvas.getContents()).getLayer((Object)IdeaFactoryViewer.FEEDBACK_LAYER_KEY);
                        feedbackLayer.add((IFigure)this.boxSelectBorder);
                    }
                    this.boxSelectBorder.setVisible(true);
                    this.boxSelectBorder.setBounds(boxBounds);
                    ArrayList<IdeaFigure> selecteds = new ArrayList<IdeaFigure>();
                    for (Object child : IdeaFactoryViewer.this.ideaPool.getChildren()) {
                        if (!(child instanceof IdeaFigure) || !((IdeaFigure)((Object)child)).getBounds().intersects(boxBounds)) continue;
                        selecteds.add((IdeaFigure)((Object)child));
                    }
                    for (IdeaFigure oldSelected : this.currentSelected) {
                        if (selecteds.contains((Object)oldSelected)) continue;
                        oldSelected.setForegroundColor(COLOR_FG_UNSELECTED);
                        oldSelected.setBackgroundColor(COLOR_BG_UNSELECTED);
                    }
                    for (IdeaFigure selected : selecteds) {
                        if (this.currentSelected.contains((Object)selected)) continue;
                        selected.setForegroundColor(COLOR_FG_SELECTED);
                        selected.setBackgroundColor(COLOR_BG_SELECTED);
                    }
                    this.currentSelected.clear();
                    this.currentSelected.addAll(selecteds);
                }
            } else if (event.type == 31) {
                if (event.detail != 2) {
                    return;
                }
                if (this.isBoxSelecting) {
                    event.doit = false;
                    this.boxSelectBorder.setVisible(false);
                    this.isBoxSelecting = false;
                    this.isBoxSelectCancelMouseNotUp = true;
                    for (IdeaFigure oldSelected : this.currentSelected) {
                        if (this.backupSelected.contains((Object)oldSelected)) continue;
                        oldSelected.setForegroundColor(COLOR_FG_UNSELECTED);
                        oldSelected.setBackgroundColor(COLOR_BG_UNSELECTED);
                    }
                    for (IdeaFigure selected : this.backupSelected) {
                        if (this.currentSelected.contains((Object)selected)) continue;
                        selected.setForegroundColor(COLOR_FG_SELECTED);
                        selected.setBackgroundColor(COLOR_BG_SELECTED);
                    }
                    this.currentSelected.clear();
                    this.currentSelected.addAll(this.backupSelected);
                }
            } else if (event.type == 16) {
                for (IdeaFigure oldSelected : this.currentSelected) {
                    oldSelected.setForegroundColor(COLOR_FG_UNSELECTED);
                    oldSelected.setBackgroundColor(COLOR_BG_UNSELECTED);
                }
                this.currentSelected.clear();
            }
        }

        private ITopicExtensionElement[] getOrderedDragedIdeas() {
            ArrayList<IdeaFigure> orderedSelected = new ArrayList<IdeaFigure>();
            for (IdeaFigure idea : IdeaFactoryViewer.this.ideaPool.getChildren()) {
                if (!this.currentSelected.contains((Object)idea)) continue;
                orderedSelected.add(idea);
            }
            ArrayList<ITopicExtensionElement> ideasDraged = new ArrayList<ITopicExtensionElement>(orderedSelected.size());
            if (!orderedSelected.isEmpty()) {
                for (IdeaFigure ideaSelected : orderedSelected) {
                    ITopicExtensionElement ideaModel = (ITopicExtensionElement)IdeaFactoryViewer.this.ideaToExelements.get((Object)ideaSelected);
                    if (ideaModel == null) continue;
                    ideasDraged.add(ideaModel);
                }
            }
            return ideasDraged.toArray(new ITopicExtensionElement[ideasDraged.size()]);
        }

        private void startEditingIdea(final IdeaFigure source) {
            if (source == null) {
                return;
            }
            final Text editor = new Text((Composite)IdeaFactoryViewer.this.canvas, 2052);
            editor.setFont(source.getFont());
            editor.setText(source.getText());
            Rectangle bounds = source.getBounds();
            Viewport viewport = IdeaFactoryViewer.this.canvas.getViewport();
            int x = bounds.x - viewport.getClientArea().x;
            int y = bounds.y - viewport.getClientArea().y;
            org.eclipse.swt.graphics.Point size = editor.computeSize(-1, -1);
            editor.setBounds(x, y + (bounds.height - size.y) / 2, bounds.width, size.y);
            IdeaFactoryViewer.this.canvas.layout();
            editor.selectAll();
            editor.setFocus();
            final Listener mouseDownFilter = new Listener(){

                public void handleEvent(Event event) {
                    if (event.widget != editor) {
                        EventHandler.this.finishEditingIdea(editor, source);
                    }
                }
            };
            editor.getDisplay().addFilter(3, mouseDownFilter);
            editor.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    editor.getDisplay().removeFilter(3, mouseDownFilter);
                }
            });
            editor.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 13) {
                        EventHandler.this.finishEditingIdea(editor, source);
                    }
                }
            });
            editor.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2) {
                        e.doit = false;
                        EventHandler.this.cancelEditingIdea(editor);
                    }
                }
            });
        }

        private void finishEditingIdea(Text editor, IdeaFigure source) {
            String newTitle = editor.getText();
            String oldTitle = source.getText();
            editor.dispose();
            SourceCommand command = null;
            if (newTitle != oldTitle) {
                IdeaFactoryViewer.this.checkGroup();
                command = "".equals(newTitle) ? new DeleteIdeaCommand(IdeaFactoryViewer.this.groupElement.getTopic(), (ITopicExtensionElement)IdeaFactoryViewer.this.ideaToExelements.get((Object)source)) : new ModifyIdeaContentCommand(IdeaFactoryViewer.this.groupElement.getTopic(), (ITopicExtensionElement)IdeaFactoryViewer.this.ideaToExelements.get((Object)source), newTitle);
                IdeaFactoryViewer.this.sourceEditor.getCommandStack().execute((Command)command);
            }
            IdeaFactoryViewer.this.canvas.layout();
        }

        private void cancelEditingIdea(Text editor) {
            editor.dispose();
            IdeaFactoryViewer.this.canvas.layout();
        }

        public void menuAboutToShow(IMenuManager manager) {
            IAction deleteIdeasAction;
            IAction pasteIdeasAction;
            IAction cutIdeasAction;
            IAction copyIdeasAction = this.createCopyIdeasAction();
            if (copyIdeasAction != null) {
                manager.add(copyIdeasAction);
            }
            if ((cutIdeasAction = this.createCutIdeasAction()) != null) {
                manager.add(cutIdeasAction);
            }
            if ((pasteIdeasAction = this.createPasteIdeasAction()) != null) {
                manager.add(pasteIdeasAction);
            }
            if ((deleteIdeasAction = this.createDeleteIdeasAction()) != null) {
                manager.add(deleteIdeasAction);
            }
        }

        private IAction createDeleteIdeasAction() {
            if (this.currentSelected.size() == 0) {
                return null;
            }
            return new Action(IdeaFactoryMessages.DeleteIdeaAction_Text){

                public void run() {
                    this.setId("org.xmind.ui.ideafactory.deleteIdeas");
                    IdeaFactoryViewer.this.checkGroup();
                    ArrayList<DeleteIdeaCommand> commands = new ArrayList<DeleteIdeaCommand>();
                    for (IdeaFigure ideaFigure : EventHandler.this.currentSelected) {
                        DeleteIdeaCommand deleteIdeaCommand = new DeleteIdeaCommand(IdeaFactoryViewer.this.groupElement.getTopic(), (ITopicExtensionElement)IdeaFactoryViewer.this.ideaToExelements.get((Object)ideaFigure));
                        commands.add(deleteIdeaCommand);
                    }
                    CompoundCommand compoundCommand = new CompoundCommand(commands);
                    IdeaFactoryViewer.this.sourceEditor.getCommandStack().execute((Command)compoundCommand);
                }
            };
        }

        private IAction createCutIdeasAction() {
            if (this.currentSelected.size() == 0) {
                return null;
            }
            return new Action(IdeaFactoryMessages.IdeaFactoryViewer_Action_Cut){

                public void run() {
                    ITopicExtensionElement[] ideas;
                    this.setId("org.xmind.ui.ideafactory.cutIdeas");
                    EventHandler.this.performCopy();
                    IdeaFactoryViewer.this.checkGroup();
                    ArrayList<DeleteIdeaCommand> commands = new ArrayList<DeleteIdeaCommand>();
                    ITopicExtensionElement[] iTopicExtensionElementArray = ideas = EventHandler.this.getOrderedDragedIdeas();
                    int n = ideas.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITopicExtensionElement idea = iTopicExtensionElementArray[n2];
                        commands.add(new DeleteIdeaCommand(IdeaFactoryViewer.this.groupElement.getTopic(), idea));
                        ++n2;
                    }
                    if (commands.size() > 0) {
                        CompoundCommand cc = new CompoundCommand(commands);
                        cc.setLabel(IdeaFactoryMessages.IdeaFactoryViewer_Copy_Cut_Ideas);
                        IdeaFactoryViewer.this.sourceEditor.getCommandStack().execute((Command)cc);
                    }
                }
            };
        }

        private IAction createCopyIdeasAction() {
            if (this.currentSelected.size() == 0) {
                return null;
            }
            return new Action(IdeaFactoryMessages.IdeaFactoryViewer_Action_Copy){

                public void run() {
                    this.setId("org.xmind.ui.ideafactory.copyIdeas");
                    EventHandler.this.performCopy();
                }
            };
        }

        private IAction createPasteIdeasAction() {
            Action pasteAction = new Action(IdeaFactoryMessages.IdeaFactoryViewer_Action_Paste){

                public void run() {
                    this.setId("org.xmind.ui.ideafactory.pasteIdeas");
                    EventHandler.this.performPaste();
                }
            };
            pasteAction.setEnabled(this.isPasteEnabled());
            return pasteAction;
        }

        private void performCopy() {
            if (this.currentSelected == null) {
                return;
            }
            ITopicExtensionElement[] ideas = this.getOrderedDragedIdeas();
            ArrayList<String> ideaContents = new ArrayList<String>();
            ITopicExtensionElement[] iTopicExtensionElementArray = ideas;
            int n = ideas.length;
            int n2 = 0;
            while (n2 < n) {
                ITopicExtensionElement idea = iTopicExtensionElementArray[n2];
                ideaContents.add(idea.getTextContent());
                ++n2;
            }
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            clipboard.setContents(new Object[]{ideaContents.toArray(new String[0]), ideaContents.get(0)}, new Transfer[]{IdeaTransfer2.getInstance(), TextTransfer.getInstance()});
            clipboard.dispose();
            IdeaTransfer2.getInstance().setSourceViewer(IdeaFactoryViewer.this);
        }

        private void performPaste() {
            IdeaFactoryViewer sourceViewer = IdeaTransfer2.getInstance().getSourceViewer();
            if (sourceViewer != null && !sourceViewer.getControl().isDisposed()) {
                sourceViewer.checkGroup();
            }
            IdeaFactoryViewer.this.ensureGroup();
            ArrayList<AddIdeaCommand> commands = new ArrayList<AddIdeaCommand>();
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            Object data = clipboard.getContents((Transfer)IdeaTransfer2.getInstance());
            if (data instanceof String[] && ((String[])data).length != 0) {
                String[] stringArray = (String[])data;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String idea = stringArray[n2];
                    commands.add(new AddIdeaCommand(IdeaFactoryViewer.this.groupElement, idea));
                    ++n2;
                }
            } else {
                Object text = clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (text instanceof String && !"".equals(text)) {
                    commands.add(new AddIdeaCommand(IdeaFactoryViewer.this.groupElement, (String)text));
                }
            }
            clipboard.dispose();
            if (commands.size() == 0) {
                return;
            }
            CompoundCommand cc = new CompoundCommand(commands);
            cc.setLabel(IdeaFactoryMessages.IdeaFactoryViewer_Command_Paste_Ideas);
            IdeaFactoryViewer.this.sourceEditor.getCommandStack().execute((Command)cc);
        }

        private boolean isPasteEnabled() {
            Clipboard clipboard = new Clipboard(Display.getCurrent());
            Object data = clipboard.getContents((Transfer)IdeaTransfer2.getInstance());
            boolean enabled = false;
            if (data instanceof String[] && ((String[])data).length > 0) {
                enabled = true;
            } else {
                Object text = clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (text instanceof String && !"".equals(text)) {
                    enabled = true;
                }
            }
            clipboard.dispose();
            return enabled;
        }

        public void dragDetected(DragDetectEvent e) {
            org.eclipse.swt.graphics.Point location = IdeaFactoryViewer.this.toViewportLocation(new org.eclipse.swt.graphics.Point(e.x, e.y));
            for (IdeaFigure ideaFigure : this.currentSelected) {
                if (!ideaFigure.getBounds().contains(location.x, location.y)) continue;
                return;
            }
            this.backupSelected.clear();
            this.backupSelected.addAll(this.currentSelected);
            for (IdeaFigure oldSelected : this.currentSelected) {
                oldSelected.setForegroundColor(COLOR_FG_UNSELECTED);
                oldSelected.setBackgroundColor(COLOR_BG_UNSELECTED);
            }
            this.currentSelected.clear();
            this.isBoxSelecting = true;
            this.boxSelectStart = new org.eclipse.swt.graphics.Point(location.x, location.y);
        }

        public void createDragSource(Control control) {
            if (control != null && control.getData("DragSource") != null) {
                return;
            }
            final DragSource dragSource = new DragSource(control, 3);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dragSource.dispose();
                }
            });
            dragSource.setTransfer(new Transfer[]{IdeaTransfer.getInstance()});
            dragSource.addDragListener(new DragSourceListener(){
                private ITopicExtensionElement[] ideas;

                public void dragStart(DragSourceEvent event) {
                    this.ideas = EventHandler.this.getOrderedDragedIdeas();
                    if (this.ideas.length == 0) {
                        event.doit = false;
                    }
                    for (IdeaFigure idea : EventHandler.this.currentSelected) {
                        idea.setAlpha(96);
                    }
                }

                public void dragSetData(DragSourceEvent event) {
                    event.data = new Object[]{this.ideas, this.ideas[0].getTextContent()};
                    IdeaTransfer.getInstance().setSourceViewer(IdeaFactoryViewer.this);
                }

                public void dragFinished(DragSourceEvent event) {
                    for (IdeaFigure idea : EventHandler.this.currentSelected) {
                        idea.setAlpha(255);
                    }
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IdeaDropTargetHandler
    implements DropTargetListener {
        private int insertIndex = -1;
        private TransparentCornerLabel feedback;

        public void createDropTarget(Control control) {
            if (control != null && control.getData("DropTarget") != null) {
                return;
            }
            final DropTarget dropTarget = new DropTarget(control, 3);
            dropTarget.setTransfer(new Transfer[]{IdeaTransfer.getInstance()});
            dropTarget.addDropListener((DropTargetListener)this);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    dropTarget.dispose();
                }
            });
        }

        public void dropAccept(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (this.feedback != null) {
                this.feedback.setVisible(false);
            }
            if (IdeaTransfer.getInstance().isSupportedType(event.currentDataType)) {
                this.dropIdeas(event);
            }
        }

        private void dropIdeas(DropTargetEvent event) {
            List<ITopicExtensionElement> sourceIdeas = Arrays.asList((ITopicExtensionElement[])((Object[])event.data)[0]);
            if (sourceIdeas.size() == 0) {
                return;
            }
            IdeaFactoryViewer sourceViewer = IdeaTransfer.getInstance().getSourceViewer();
            if (sourceViewer != null && !sourceViewer.getControl().isDisposed()) {
                sourceViewer.checkGroup();
            }
            IdeaFactoryViewer.this.checkGroup();
            ArrayList<SourceCommand> commands = new ArrayList<SourceCommand>();
            if (!sourceIdeas.get(0).getAttribute("group_id").equals(IdeaFactoryViewer.this.groupElement.getAttribute("id"))) {
                int i = sourceIdeas.size() - 1;
                while (i >= 0) {
                    ITopicExtensionElement idea = sourceIdeas.get(i);
                    commands.add(new DeleteIdeaCommand(idea.getTopic(), idea));
                    commands.add(new AddIdeaCommand(IdeaFactoryViewer.this.groupElement, idea.getTextContent(), this.insertIndex));
                    --i;
                }
            } else {
                ArrayList<ITopicExtensionElement> beforeInsertIdeas = new ArrayList<ITopicExtensionElement>();
                ArrayList<ITopicExtensionElement> afterInsertIdeas = new ArrayList<ITopicExtensionElement>();
                for (ITopicExtensionElement idea : sourceIdeas) {
                    int index = -1;
                    index = IdeaFactoryViewer.this.groupElement != null ? IdeaUtils.getGroupIdeas(IdeaFactoryViewer.this.groupElement).indexOf(idea) : IdeaUtils.getNoGroupIdeas(IdeaFactoryViewer.this.rootTopic).indexOf(idea);
                    if (index < this.insertIndex) {
                        beforeInsertIdeas.add(idea);
                        continue;
                    }
                    if (index < this.insertIndex) continue;
                    afterInsertIdeas.add(idea);
                }
                for (ITopicExtensionElement idea : beforeInsertIdeas) {
                    commands.add(new AddIdeaCommand(IdeaFactoryViewer.this.groupElement, idea.getTextContent(), this.insertIndex));
                    commands.add(new DeleteIdeaCommand(idea.getTopic(), idea));
                }
                int i = afterInsertIdeas.size() - 1;
                while (i >= 0) {
                    ITopicExtensionElement sourceIdea = (ITopicExtensionElement)afterInsertIdeas.get(i);
                    commands.add(new DeleteIdeaCommand(sourceIdea.getTopic(), sourceIdea));
                    commands.add(new AddIdeaCommand(IdeaFactoryViewer.this.groupElement, sourceIdea.getTextContent(), this.insertIndex));
                    --i;
                }
            }
            IdeaFactoryViewer.this.sourceEditor.getCommandStack().execute((Command)new CompoundCommand(commands));
        }

        public void dragOver(DropTargetEvent event) {
            this.dragOver(new org.eclipse.swt.graphics.Point(event.x, event.y));
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragLeave(DropTargetEvent event) {
            if (this.feedback != null) {
                this.feedback.setVisible(false);
            }
        }

        public void dragEnter(DropTargetEvent event) {
        }

        public void dragOver(org.eclipse.swt.graphics.Point position) {
            org.eclipse.swt.graphics.Point point = IdeaFactoryViewer.this.canvas.toControl(position);
            org.eclipse.swt.graphics.Point viewportLocation = IdeaFactoryViewer.this.toViewportLocation(new org.eclipse.swt.graphics.Point(point.x, point.y));
            Layer feedbackLayer = ((LayeredPane)IdeaFactoryViewer.this.canvas.getContents()).getLayer((Object)IdeaFactoryViewer.FEEDBACK_LAYER_KEY);
            int insertIndex = -1;
            IFigure figure = IdeaFactoryViewer.this.ideaPool.findFigureAt(viewportLocation.x, viewportLocation.y);
            if (figure instanceof IdeaFigure) {
                insertIndex = IdeaFactoryViewer.this.ideaPool.getChildren().indexOf(figure);
            } else {
                List ideas = IdeaFactoryViewer.this.ideaPool.getChildren();
                for (IFigure child : ideas) {
                    Rectangle largeBounds = new Rectangle(child.getBounds()).expand(5, 5);
                    boolean contains = largeBounds.contains(viewportLocation.x, viewportLocation.y);
                    if (contains) {
                        insertIndex = ideas.indexOf(child);
                        break;
                    }
                    if (viewportLocation.y >= largeBounds.y) continue;
                    insertIndex = ideas.indexOf(child);
                    break;
                }
                if (insertIndex == -1) {
                    insertIndex = ideas.size();
                }
            }
            if (insertIndex == this.insertIndex) {
                if (this.feedback != null) {
                    this.feedback.setVisible(true);
                }
                return;
            }
            this.insertIndex = insertIndex;
            if (this.feedback == null) {
                this.feedback = new TransparentCornerLabel();
                this.feedback.setOpaque(true);
                this.feedback.setBackgroundColor(ColorUtils.getColor((String)"#f57d7d"));
                int height = 31;
                if (IdeaFactoryViewer.this.ideaPool.getChildren().size() != 0) {
                    height = ((IFigure)((IdeaFactoryViewer)IdeaFactoryViewer.this).ideaPool.getChildren().get((int)0)).getBounds().height - 2;
                }
                this.feedback.setSize(30, height);
                this.feedback.setAlpha(187);
                this.feedback.setCornerDimensions(5);
                feedbackLayer.add((IFigure)this.feedback);
            }
            if (insertIndex >= 0 && insertIndex <= IdeaFactoryViewer.this.ideaPool.getChildren().size()) {
                Rectangle bounds;
                IFigure source;
                org.eclipse.swt.graphics.Point location = null;
                Dimension size = this.feedback.getSize();
                if (insertIndex != IdeaFactoryViewer.this.ideaPool.getChildren().size()) {
                    source = (IFigure)IdeaFactoryViewer.this.ideaPool.getChildren().get(insertIndex);
                    bounds = source.getBounds();
                    location = new org.eclipse.swt.graphics.Point(bounds.x, bounds.y + (bounds.height - size.height) / 2);
                } else if (IdeaFactoryViewer.this.ideaPool.getChildren().size() == 0) {
                    location = new org.eclipse.swt.graphics.Point(5, 6);
                } else {
                    source = (IFigure)IdeaFactoryViewer.this.ideaPool.getChildren().get(IdeaFactoryViewer.this.ideaPool.getChildren().size() - 1);
                    bounds = source.getBounds();
                    location = new org.eclipse.swt.graphics.Point(bounds.x + bounds.width + 5, bounds.y + (bounds.height - size.height) / 2);
                    if (location.x + size.width > feedbackLayer.getBounds().x + feedbackLayer.getBounds().width) {
                        location = new org.eclipse.swt.graphics.Point(5, bounds.y + bounds.height + 5 + (bounds.height - size.height) / 2);
                        int cfr_ignored_0 = location.y;
                        int cfr_ignored_1 = feedbackLayer.getBounds().y;
                        int cfr_ignored_2 = feedbackLayer.getBounds().height;
                    }
                }
                this.feedback.setVisible(true);
                this.feedback.setBounds(new Rectangle(location.x + 1, location.y, size.width, size.height));
            }
        }

        public void dropTopics(Object[] sources) {
            if (this.feedback != null) {
                this.feedback.setVisible(false);
            }
            if (sources == null || sources.length == 0) {
                return;
            }
            ArrayList<ITopic> topics = new ArrayList<ITopic>();
            Object[] objectArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                Object source = objectArray[n2];
                if (source instanceof ITopic) {
                    topics.add((ITopic)source);
                }
                ++n2;
            }
            if (topics.size() == 0) {
                return;
            }
            ArrayList<ITopic> filteredTopics = new ArrayList<ITopic>();
            for (ITopic topic : topics) {
                if (MindMapUtils.isAncestorInList((ITopic)topic, topics)) continue;
                filteredTopics.add(topic);
            }
            ArrayList<ITopic> sortFilteredTopics = new ArrayList<ITopic>();
            List allSortedChildren = MindMapUtils.getAllTopics((ISheet)((ITopic)topics.get(0)).getOwnedSheet(), (boolean)true, (boolean)false);
            for (ITopic topic : allSortedChildren) {
                if (!filteredTopics.contains(topic)) continue;
                sortFilteredTopics.add(topic);
            }
            ArrayList<AddIdeaCommand> commands = new ArrayList<AddIdeaCommand>();
            ArrayList<ITopic> allChildren = new ArrayList<ITopic>();
            for (ITopic topic : sortFilteredTopics) {
                if (allChildren.contains(topic)) continue;
                this.getAllChildren(topic, allChildren);
            }
            IdeaFactoryViewer.this.ensureGroup();
            int i = allChildren.size() - 1;
            while (i >= 0) {
                commands.add(new AddIdeaCommand(IdeaFactoryViewer.this.groupElement, ((ITopic)allChildren.get(i)).getTitleText(), this.insertIndex));
                --i;
            }
            for (ITopic topic : sortFilteredTopics) {
                commands.add((AddIdeaCommand)new DeleteTopicCommand(topic));
            }
            IdeaFactoryViewer.this.sourceEditor.getCommandStack().execute((Command)new CompoundCommand(commands));
        }

        private void getAllChildren(ITopic topic, List<ITopic> topics) {
            if (topic != null) {
                topics.add(topic);
            }
            for (ITopic child : topic.getAllChildren()) {
                this.getAllChildren(child, topics);
            }
        }

        public void dragLeave() {
            if (this.feedback != null) {
                this.feedback.setVisible(false);
            }
        }
    }

    private static class IdeaFigure
    extends org.eclipse.draw2d.Label {
        private int alpha = 255;

        public IdeaFigure(String idea) {
            super(idea);
            this.setBorder((Border)new MarginBorder(8, 10, 8, 10));
            this.setFont(FontUtils.getNewHeight((Font)this.getFont(), (int)11));
        }

        public void setFontSize(int height) {
            if (height > 0) {
                this.setFont(FontUtils.getNewHeight((Font)JFaceResources.getDefaultFont(), (int)height));
            }
        }

        public void setAlpha(int alpha) {
            if (this.alpha != alpha) {
                this.alpha = alpha;
                this.repaint();
                this.revalidate();
            }
        }

        protected void paintFigure(Graphics graphics) {
            graphics.setAlpha(this.alpha);
            graphics.setAntialias(1);
            graphics.setTextAntialias(1);
            Rectangle rect = this.getBounds().getCopy();
            graphics.setLineStyle(1);
            org.xmind.gef.draw2d.graphics.Path shape = new org.xmind.gef.draw2d.graphics.Path((Device)Display.getCurrent());
            shape.addRoundedRectangle((float)rect.x, (float)rect.y, (float)(rect.width - 1), (float)(rect.height - 1), 4.0f);
            graphics.fillPath((Path)shape);
            graphics.drawPath((Path)shape);
            shape.dispose();
            graphics.setForegroundColor(ColorUtils.getColor((String)"#323232"));
            graphics.setLineStyle(1);
            graphics.setLineWidth(2);
            graphics.setFillRule(2);
            super.paintFigure(graphics);
        }
    }
}

