/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.internal.device;

public class AudioUtils {
    private static final float MAX_AMPLITUDE = 32767.0f;
    private static final double MIN_AMPLITUDE = Math.pow(10.0, -1.5);

    public static int calculateLevel(byte[] data, int length) {
        float sum = 0.0f;
        int num = 0;
        int i = 0;
        while (i < length - 1) {
            short t = AudioUtils.bytesToShort16(data[i++], data[i++]);
            float f = (float)t / 32767.0f;
            sum += f * f;
            ++num;
        }
        if (num == 0) {
            return 0;
        }
        double amp = Math.sqrt(sum / (float)num);
        return AudioUtils.ampToLevel(amp);
    }

    public static int ampToLevel(double amp) {
        if (Math.abs(amp) < MIN_AMPLITUDE) {
            return 0;
        }
        double dB = 20.0 * Math.log10(amp);
        double k = Math.max(dB + 30.0, 0.0) / 30.0;
        int level = (int)(k * 100.0);
        return level;
    }

    public static short bytesToShort16(byte highByte, byte lowByte) {
        return (short)(highByte << 8 | lowByte & 0xFF);
    }
}

