/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.HashSet;
import java.util.Set;
import org.xmind.ui.branch.BranchStructureData;
import org.xmind.ui.mindmap.IBranchPart;

public class TimelineVerticalData
extends BranchStructureData {
    private Set<Integer> rightwards = null;

    public TimelineVerticalData(IBranchPart branch) {
        super(branch);
    }

    public boolean isLeftwardBranch(int index) {
        return !this.getRightwardBranch().contains(index);
    }

    public Set<Integer> getRightwardBranch() {
        if (this.rightwards == null) {
            this.rightwards = this.calcUpwardBranchs();
        }
        return this.rightwards;
    }

    private Set<Integer> calcUpwardBranchs() {
        HashSet<Integer> set = new HashSet<Integer>();
        int i = 0;
        IBranchPart lastChild = null;
        boolean rightward = true;
        for (IBranchPart sub : this.getBranch().getSubBranches()) {
            if (lastChild == null) {
                set.add(i);
            } else {
                if (!this.isInSameRange(lastChild, sub)) {
                    boolean bl = rightward = !rightward;
                }
                if (rightward) {
                    set.add(i);
                }
            }
            lastChild = sub;
            ++i;
        }
        return set;
    }
}

