/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicComponent;
import org.xmind.gef.ISourceProvider;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.dnd.DndData;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.dnd.IDndSupport;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.internal.editpolicies.DeletablePolicy;
import org.xmind.ui.internal.editpolicies.PropertyCommandBuilder;
import org.xmind.ui.util.MindMapUtils;

public class EditablePolicy
extends DeletablePolicy {
    @Override
    public boolean understands(String requestType) {
        return super.understands(requestType) || "copy".equals(requestType) || "cut".equals(requestType) || "paste".equals(requestType) || "replace_all".equals(requestType);
    }

    @Override
    public void handle(Request request) {
        String reqType = request.getType();
        if ("copy".equals(reqType)) {
            this.copy(request);
        } else if ("cut".equals(reqType)) {
            this.cut(request);
        } else if ("paste".equals(reqType)) {
            this.paste(request);
        } else if ("replace_all".equals(reqType)) {
            this.replaceAll(request);
        } else if (!"delete".equals(reqType)) {
            super.handle(request);
        }
    }

    protected void copy(Request request) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        List sources = request.getTargets();
        List<Object> models = this.filter(MindMapUtils.getRealModels(sources), viewer);
        if (models.isEmpty()) {
            return;
        }
        this.performCopy(models.toArray(), request.getTargetViewer());
    }

    protected List<Object> filter(List<Object> elements, IViewer viewer) {
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        ITopic root = (ITopic)viewer.getAdapter(ITopic.class);
        ArrayList<Object> list = new ArrayList<Object>(elements.size());
        for (Object o : elements) {
            if (this.shouldRemove(o, elements, sheet, root, viewer)) continue;
            list.add(o);
        }
        return list;
    }

    private boolean shouldRemove(Object element, List<Object> elements, ISheet sheet, ITopic root, IViewer viewer) {
        block7: {
            block6: {
                if (!(element instanceof IRelationship)) break block6;
                IRelationship r = (IRelationship)element;
                for (Object o : elements) {
                    if (!(o instanceof ISheet) || !o.equals(r.getParent())) continue;
                    return true;
                }
                break block7;
            }
            if (!(element instanceof ITopicComponent)) break block7;
            ITopicComponent c = (ITopicComponent)element;
            ISheet s = null;
            ITopic p = null;
            for (Object o : elements) {
                if (o instanceof ISheet) {
                    if (s == null) {
                        s = c.getOwnedSheet();
                    }
                    if (o.equals(s)) {
                        return true;
                    }
                }
                if (p == null) {
                    p = c.getParent();
                }
                if (!(o instanceof ITopic) || p == null || !MindMapUtils.isDescendentOf(p, (ITopic)o)) continue;
                return true;
            }
        }
        return false;
    }

    protected void performCopy(Object[] elements, IViewer viewer) {
        String[] ids;
        elements = this.filterAndSort(elements);
        IDndSupport dndSupport = viewer.getDndSupport();
        if (dndSupport != null && (ids = dndSupport.getDndClientIds()).length > 0) {
            ArrayList<Object> data = new ArrayList<Object>(ids.length);
            ArrayList<Transfer> transfers = new ArrayList<Transfer>(ids.length);
            String[] stringArray = ids;
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Object object;
                String id = stringArray[n2];
                IDndClient client = dndSupport.getDndClient(id);
                if (client != null && (object = client.toTransferData(elements, viewer)) != null) {
                    data.add(object);
                    Transfer transfer = client.getTransfer();
                    transfers.add(transfer);
                }
                ++n2;
            }
            if (!data.isEmpty()) {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(data.toArray(), transfers.toArray(new Transfer[0]));
                clipboard.dispose();
            }
        }
    }

    private Object[] filterAndSort(Object[] elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<ITopic> topics = new ArrayList<ITopic>();
        ArrayList<Object> others = new ArrayList<Object>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ITopic) {
                topics.add((ITopic)element);
            } else {
                others.add(element);
            }
            ++n2;
        }
        List<ITopic> filteredTopics = MindMapUtils.filterOutDescendents(topics, null);
        Collections.sort(filteredTopics, Core.getTopicComparator());
        ArrayList<ITopic> all = new ArrayList<ITopic>(filteredTopics);
        all.addAll(others);
        return all.toArray();
    }

    protected void cut(Request request) {
        List sources = request.getTargets();
        List<Object> models = MindMapUtils.getRealModels(sources);
        if (models.isEmpty()) {
            return;
        }
        this.performCopy(models.toArray(), request.getTargetViewer());
        this.delete(request);
    }

    @Override
    protected String getDeleteLabel(String type) {
        if ("org.xmind.ui.topic".equals(type)) {
            return CommandMessages.Command_CutTopic;
        }
        if ("org.xmind.ui.relationship".equals(type)) {
            return CommandMessages.Command_CutRelationship;
        }
        if ("org.xmind.ui.marker".equals(type)) {
            return CommandMessages.Command_DeleteMarker;
        }
        if ("org.xmind.ui.sheet".equals(type)) {
            return CommandMessages.Command_CutSheet;
        }
        if ("org.xmind.ui.boundary".equals(type)) {
            return CommandMessages.Command_DeleteBoundary;
        }
        return CommandMessages.Command_Cut;
    }

    protected void paste(Request request) {
        DndData dndData;
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return;
        }
        IDndSupport dndSupport = viewer.getDndSupport();
        if (dndSupport == null) {
            return;
        }
        Clipboard cb = new Clipboard(Display.getCurrent());
        try {
            dndData = dndSupport.parseData(cb.getAvailableTypes(), (Object)cb, false);
        }
        finally {
            cb.dispose();
        }
        if (dndData == null) {
            return;
        }
        IDndClient client = dndSupport.getDndClient(dndData.clientId);
        if (client == null) {
            return;
        }
        request.setParameter("dropOperation", (Object)1);
        Command command = client.makeDNDCommand(dndData.parsedData, request);
        if (command == null) {
            return;
        }
        command.setLabel(CommandMessages.Command_Paste);
        this.saveAndRun(command, request.getTargetDomain());
        if (command instanceof ISourceProvider) {
            this.select(((ISourceProvider)command).getSources(), viewer);
        }
    }

    private void replaceAll(Request request) {
        PropertyCommandBuilder builder;
        String text = (String)request.getParameter("text");
        String replacement = (String)request.getParameter("replacement");
        if (text == null || replacement == null) {
            return;
        }
        boolean ignoreCase = Boolean.TRUE.equals(request.getParameter("ignoreCase"));
        List targets = request.getTargets();
        if (targets.isEmpty()) {
            return;
        }
        if (ignoreCase) {
            text = text.toLowerCase();
        }
        if ((builder = new PropertyCommandBuilder(request)).canStart()) {
            builder.start();
            for (IPart target : targets) {
                Object model = MindMapUtils.getRealModel(target);
                if (!(model instanceof ITitled)) continue;
                ITitled t = (ITitled)model;
                String oldText = t.getTitleText();
                if (oldText != null) {
                    String newText;
                    String searchText = ignoreCase ? oldText.toLowerCase() : oldText;
                    StringBuilder sb = new StringBuilder(oldText.length() + replacement.length());
                    int start = 0;
                    int index = searchText.indexOf(text);
                    while (index >= 0) {
                        sb.append(oldText.substring(start, index));
                        sb.append(replacement);
                        start = index + text.length();
                        index = searchText.indexOf(text, start);
                    }
                    if (start < oldText.length()) {
                        sb.append(oldText.substring(start));
                    }
                    if (!(newText = sb.toString()).equals(oldText)) {
                        builder.add((Command)new ModifyTitleTextCommand(t, newText), true);
                    }
                }
                builder.addSource(t, true);
            }
            builder.end();
        }
    }
}

