/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.internal.svgsupport.SVGShape;

public final class SVGRectangleShape
extends SVGShape {
    private float x;
    private float y;
    private float rx;
    private float ry;
    private float height;
    private float width;

    SVGRectangleShape() {
    }

    public SVGRectangleShape(float x, float y, float rx, float ry, float height, float width) {
        this.x = x;
        this.y = y;
        this.rx = rx;
        this.ry = ry;
        this.height = height;
        this.width = width;
    }

    @Override
    void parse(Element implemention, SVGShape parent) {
        super.parse(implemention, parent);
        this.parseRect(implemention, parent);
    }

    private void parseRect(Element implemention, SVGShape parent) {
        this.x = this.getFloatAttribute(implemention, "x");
        this.y = this.getFloatAttribute(implemention, "y");
        this.rx = this.getFloatAttribute(implemention, "rx");
        this.ry = this.getFloatAttribute(implemention, "ry");
        if (this.rx != 0.0f) {
            this.ry = this.ry == 0.0f ? this.rx : this.ry;
        } else {
            this.rx = this.ry;
        }
        this.width = this.getFloatAttribute(implemention, "width");
        this.height = this.getFloatAttribute(implemention, "height");
    }

    @Override
    Path generatePath(Display device) {
        Path path = new Path((Device)device);
        PrecisionRectangle rect = new PrecisionRectangle((double)this.x, (double)this.y, (double)this.width, (double)this.height);
        path.addRoundedRectangle(rect, this.rx);
        return path;
    }

    @Override
    PrecisionRectangle generateRectangle() {
        return new PrecisionRectangle((double)this.x, (double)this.y, (double)this.width, (double)this.height);
    }

    @Override
    protected SVGShape clone() {
        SVGRectangleShape rect = new SVGRectangleShape();
        rect.setInfo(this.getInfo().clone());
        rect.x = this.x;
        rect.y = this.y;
        rect.rx = this.rx;
        rect.ry = this.ry;
        rect.height = this.height;
        rect.width = this.width;
        return rect;
    }

    public boolean equals(Object obj) {
        SVGRectangleShape rect;
        if (this == obj) {
            return true;
        }
        return obj instanceof SVGRectangleShape && (rect = (SVGRectangleShape)obj).getInfo().equals(this.getInfo()) && this.x == rect.x && this.width == rect.width && this.height == rect.height && this.rx == rect.rx && this.ry == rect.ry;
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.getInfo().hashCode();
        result = result * 31 + Float.floatToIntBits(this.x);
        result = result * 31 + Float.floatToIntBits(this.y);
        result = result * 31 + Float.floatToIntBits(this.width);
        result = result * 31 + Float.floatToIntBits(this.height);
        result = result * 31 + Float.floatToIntBits(this.rx);
        result = result * 31 + Float.floatToIntBits(this.ry);
        return result;
    }

    public String toString() {
        return "SVGRectangle( x=" + this.x + " y=" + this.y + " width=" + this.width + " height=" + this.height + this.getInfo().toString() + ")";
    }
}

