/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.xmind.ui.internal.svgsupport.ColorRecognizer;
import org.xmind.ui.internal.svgsupport.SVGColor;
import org.xmind.ui.internal.svgsupport.SVGShape;
import org.xmind.ui.internal.svgsupport.SVGTransform;

public class SVGShapeInfoMap
implements Cloneable {
    private static final float DEFAULT_STROKE_LINEJOIN_MITER = 4.0f;
    private static final float DEFAULT_STROKE_DASHOFFSET = 0.0f;
    public static final int DEFAULT_STROKE_LINEJOIN = 1;
    private static final float INVALID_FLOAT = -1.0f;
    private static final float MAX_OPACITY = 1.0f;
    private static final float MIN_OPACITY = 0.0f;
    public static final String ID = "id";
    public static final String FILL = "fill";
    public static final String FILL_RULE = "fill-rule";
    public static final String FILL_OPACITY = "fill-opacity";
    public static final String STROKE = "stroke";
    public static final String STROKE_WIDTH = "stroke-width";
    public static final String STROKE_OPACITY = "stroke-opacity";
    public static final String STROKE_LINESTYLE = "line-style";
    public static final String STROKE_LINECAP = "stroke-linecap";
    public static final String STROKE_LINECAP_BUTT = "butt";
    public static final String STROKE_LINECAP_ROUND = "round";
    public static final String STROKE_LINECAP_SQUARE = "square";
    public static final String STROKE_DASHARRAY = "stroke-dasharray";
    public static final String STROKE_LINEJOIN = "stroke-linejoin";
    public static final String STROKE_LINEJOIN_MITER = "miter";
    public static final String STROKE_LINEJOIN_ROUND = "round";
    public static final String STROKE_LINEJOIN_BEVEL = "bevel";
    public static final String STROKE_MITERLIMIT = "stroke-miterlimit";
    public static final String STROKE_DASHOFFSET = "stroke-dashoffset";
    public static final String FILL_RULE_EVENODD_STRING = "evenodd";
    public static final String FILL_RULE_NONZERO_STRING = "nonzero";
    public static final String TRANSFORM = "transform";
    private static final String NONE = "none";
    private Map<String, Object> map = new HashMap<String, Object>();
    private int idCount = 0;

    void parse(Element implementation, SVGShapeInfoMap infoMap) {
        if (infoMap != null) {
            this.map.putAll(infoMap.map);
            this.map.remove(TRANSFORM);
        }
        if (implementation.hasAttribute(ID)) {
            this.putId(implementation.getAttribute(ID));
        } else {
            this.putId(this.generateRandomId());
        }
        this.parseStyles(implementation);
    }

    private synchronized String generateRandomId() {
        return "shapeId-" + this.idCount++;
    }

    private void parseStyles(Element implementation) {
        this.parseFillStyle(implementation);
        this.parseStrokeStyle(implementation);
        this.parseLineAttributes(implementation);
        this.parseTransformStyle(implementation);
    }

    private void parseFillStyle(Element implementation) {
        float opacity;
        SVGColor color;
        String fill = implementation.getAttribute(FILL);
        if (implementation.hasAttribute(FILL) && !fill.equals(NONE) && (color = ColorRecognizer.recognizeColor(fill, SVGShape.idRefs)) != null) {
            this.putFillColor(color);
        }
        if (implementation.hasAttribute(FILL_RULE)) {
            this.putFillRule(implementation.getAttribute(FILL_RULE));
        }
        if ((opacity = this.getFloatAttribute(implementation, FILL_OPACITY)) != -1.0f) {
            this.putFillOpacity(opacity * this.getFillOpacity());
        }
    }

    private void parseStrokeStyle(Element implementation) {
        float opacity;
        float width;
        SVGColor color;
        String stroke = implementation.getAttribute(STROKE).trim();
        if ((implementation.hasAttribute(STROKE) || !stroke.equals(NONE)) && (color = ColorRecognizer.recognizeColor(stroke, SVGShape.idRefs)) != null) {
            this.putStrokeColor(color);
        }
        if (0.0f <= (width = this.getFloatAttribute(implementation, STROKE_WIDTH))) {
            this.putLineWidth(width);
        }
        if (0.0f <= (opacity = this.getFloatAttribute(implementation, STROKE_OPACITY)) && 1.0f >= opacity) {
            this.putStrokeOpacity(opacity * this.getStrokeOpacity());
        }
    }

    private void parseLineAttributes(Element implementation) {
        if (implementation.hasAttribute(STROKE_LINECAP)) {
            String lineCap = implementation.getAttribute(STROKE_LINECAP);
            if (lineCap.equals("round")) {
                this.putLineCap(2);
            } else if (lineCap.equals(STROKE_LINECAP_SQUARE)) {
                this.putLineCap(3);
            }
        }
        if (implementation.hasAttribute(STROKE_DASHARRAY)) {
            String dashArray = implementation.getAttribute(STROKE_DASHARRAY).trim();
            String[] strs = dashArray.split("[\\,|\\s]+");
            float[] dashArr = new float[strs.length];
            int i = 0;
            while (i < strs.length) {
                dashArr[i] = Float.valueOf(strs[i]).floatValue();
                ++i;
            }
            this.putLineDash(dashArr);
        }
        if (implementation.hasAttribute(STROKE_DASHOFFSET)) {
            String dashOffset = implementation.getAttribute(STROKE_DASHOFFSET);
            this.putLineDashOffSET(Float.valueOf(dashOffset).floatValue());
        }
        if (implementation.hasAttribute(STROKE_LINEJOIN)) {
            String lineJoin = implementation.getAttribute(STROKE_LINEJOIN);
            if (lineJoin.equals("round")) {
                this.putLineJoin(2);
            } else if (lineJoin.equals(STROKE_LINEJOIN_BEVEL)) {
                this.putLineJoin(3);
            }
        }
        if (implementation.hasAttribute(STROKE_MITERLIMIT)) {
            String miterLimit = implementation.getAttribute(STROKE_MITERLIMIT);
            this.putLineMiterLimit(Float.valueOf(miterLimit).floatValue());
        }
    }

    private void parseTransformStyle(Element implementation) {
        SVGTransform svgTransform = new SVGTransform();
        if (implementation.hasAttribute(TRANSFORM)) {
            String transform = implementation.getAttribute(TRANSFORM).trim();
            svgTransform.parseTransform(transform);
            this.putTransform(svgTransform);
        }
    }

    float getFloatAttribute(Element ele, String name) {
        if (ele.hasAttribute(name)) {
            return Float.valueOf(ele.getAttribute(name)).floatValue();
        }
        return -1.0f;
    }

    protected SVGShapeInfoMap clone() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(map);
        SVGShapeInfoMap infoMap = new SVGShapeInfoMap();
        infoMap.map = map;
        return infoMap;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SVGShapeInfoMap && this.getId() != null) {
            return this.getId().equals(((SVGShapeInfoMap)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return " style:id=" + this.getId() + " ";
    }

    public void add(SVGShapeInfoMap info) {
        for (String key : info.map.keySet()) {
            if (!this.map.containsKey(key) && !key.equals(TRANSFORM)) {
                this.map.put(key, info.map.get(key));
                continue;
            }
            if (key.equals(FILL_OPACITY)) {
                this.map.put(FILL_OPACITY, Float.valueOf(this.getFillOpacity() * info.getFillOpacity()));
            }
            if (!key.equals(STROKE_OPACITY)) continue;
            this.map.put(STROKE_OPACITY, Float.valueOf(this.getStrokeOpacity() * info.getStrokeOpacity()));
        }
    }

    public String getId() {
        return (String)this.map.get(ID);
    }

    public void putId(String id) {
        this.map.put(ID, id);
    }

    public SVGColor getFillColor() {
        return (SVGColor)this.map.get(FILL);
    }

    public void putFillColor(SVGColor fillColor) {
        this.map.put(FILL, fillColor);
    }

    public String getFillRule() {
        Object obj = this.map.get(FILL_RULE);
        if (obj == null) {
            return FILL_RULE_NONZERO_STRING;
        }
        return (String)obj;
    }

    public void putFillRule(String fillRule) {
        this.map.put(FILL_RULE, fillRule);
    }

    public float getFillOpacity() {
        Object obj = this.map.get(FILL_OPACITY);
        float opacity = 1.0f;
        if (obj != null) {
            opacity = ((Float)obj).floatValue();
        }
        return opacity;
    }

    public void putFillOpacity(float fillOpacity) {
        this.map.put(FILL_OPACITY, Float.valueOf(fillOpacity));
    }

    public SVGColor getStrokeColor() {
        return (SVGColor)this.map.get(STROKE);
    }

    public void putStrokeColor(SVGColor strokeColor) {
        this.map.put(STROKE, strokeColor);
    }

    public float getLineWidth() {
        Object obj = this.map.get(STROKE_WIDTH);
        float lineWidth = 1.0f;
        if (obj != null) {
            lineWidth = ((Float)obj).floatValue();
        }
        return lineWidth;
    }

    public void putLineWidth(float lineWidth) {
        this.map.put(STROKE_WIDTH, Float.valueOf(lineWidth));
    }

    public float getStrokeOpacity() {
        Object obj = this.map.get(STROKE_OPACITY);
        float opacity = 1.0f;
        if (obj != null) {
            opacity = ((Float)obj).floatValue();
        }
        return opacity;
    }

    public void putStrokeOpacity(float strokeOpacity) {
        this.map.put(STROKE_OPACITY, Float.valueOf(strokeOpacity));
    }

    public int getLineStyle() {
        Object obj = this.map.get(STROKE_LINESTYLE);
        if (obj == null) {
            return 6;
        }
        return (Integer)obj;
    }

    public void putLineStyle(int style) {
        this.map.put(STROKE_LINESTYLE, style);
    }

    public int getLineCap() {
        Object obj = this.map.get(STROKE_LINECAP);
        if (obj == null) {
            return 1;
        }
        return (Integer)obj;
    }

    public void putLineCap(int lineCap) {
        this.map.put(STROKE_LINECAP, lineCap);
    }

    public float[] getLineDash() {
        if (this.map.get(STROKE_DASHARRAY) == null) {
            return null;
        }
        return (float[])this.map.get(STROKE_DASHARRAY);
    }

    public void putLineDash(float[] lineDash) {
        this.map.put(STROKE_DASHARRAY, lineDash);
    }

    public int getLineJoin() {
        Object obj = this.map.get(STROKE_LINEJOIN);
        if (obj == null) {
            return 1;
        }
        return (Integer)obj;
    }

    public void putLineJoin(int lineJoin) {
        this.map.put(STROKE_LINEJOIN, lineJoin);
    }

    public float getLineMiterLimit() {
        Object obj = this.map.get(STROKE_LINEJOIN_MITER);
        if (obj == null) {
            return 4.0f;
        }
        return ((Float)obj).floatValue();
    }

    public void putLineMiterLimit(float lineMiterLimit) {
        this.map.put(STROKE_LINEJOIN_MITER, Float.valueOf(lineMiterLimit));
    }

    public float getLineDashOffset() {
        Object obj = this.map.get(STROKE_DASHOFFSET);
        if (obj == null) {
            return 0.0f;
        }
        return ((Integer)obj).intValue();
    }

    public void putLineDashOffSET(float lineDashOffput) {
        this.map.put(STROKE_DASHOFFSET, Float.valueOf(lineDashOffput));
    }

    public SVGTransform getTransform() {
        return (SVGTransform)this.map.get(TRANSFORM);
    }

    public void putTransform(SVGTransform transform) {
        this.map.put(TRANSFORM, transform);
    }
}

