/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.ArrayList;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public abstract class UsageDescriber {
    public static final String DEFAULT_CUSTOM_ROLE_NAME = "Custom Role";
    private static final String CONSUMABLE = "Consumable - this configuration can be selected by another project as a dependency";
    private static final String RESOLVABLE = "Resolvable - this configuration can be resolved by this project to a set of files";
    private static final String DECLARABLE_AGAINST = "Declarable - this configuration can have dependencies added to it";
    private static final String UNUSABLE = "This configuration does not allow any usage";
    private static final String IS_DEPRECATED = "(but this behavior is marked deprecated)";

    private UsageDescriber() {
    }

    public static String describeRole(ConfigurationRole role) {
        return UsageDescriber.describeUsage(role.isConsumable(), role.isResolvable(), role.isDeclarable(), role.isConsumptionDeprecated(), role.isResolutionDeprecated(), role.isDeclarationAgainstDeprecated());
    }

    public static String describeCurrentUsage(DeprecatableConfiguration configuration) {
        return UsageDescriber.describeUsage(configuration.isCanBeConsumed(), configuration.isCanBeResolved(), configuration.isCanBeDeclared(), configuration.isDeprecatedForConsumption(), configuration.isDeprecatedForResolution(), configuration.isDeprecatedForDeclarationAgainst());
    }

    public static String describeUsage(boolean isConsumable, boolean isResolvable, boolean isDeclarable, boolean isConsumptionDeprecated, boolean isResolutionDeprecated, boolean isDeclarationAgainstDeprecated) {
        ArrayList<String> descriptions = new ArrayList<String>();
        if (isConsumable) {
            descriptions.add("\tConsumable - this configuration can be selected by another project as a dependency" + UsageDescriber.describeDeprecation(isConsumptionDeprecated));
        }
        if (isResolvable) {
            descriptions.add("\tResolvable - this configuration can be resolved by this project to a set of files" + UsageDescriber.describeDeprecation(isResolutionDeprecated));
        }
        if (isDeclarable) {
            descriptions.add("\tDeclarable - this configuration can have dependencies added to it" + UsageDescriber.describeDeprecation(isDeclarationAgainstDeprecated));
        }
        if (descriptions.isEmpty()) {
            descriptions.add("\tThis configuration does not allow any usage");
        }
        return String.join((CharSequence)"\n", descriptions);
    }

    private static String describeDeprecation(boolean deprecated) {
        return deprecated ? " (but this behavior is marked deprecated)" : "";
    }
}

