/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.internal.AbstractCacheCleanup;
import org.gradle.cache.internal.CacheVersion;
import org.gradle.cache.internal.CacheVersionMapping;
import org.gradle.cache.internal.NonReservedFileFilter;
import org.gradle.cache.internal.UsedGradleVersions;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedVersionsCacheCleanup
extends AbstractCacheCleanup {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnusedVersionsCacheCleanup.class);
    private final Pattern cacheNamePattern;
    private final CacheVersionMapping cacheVersionMapping;
    private final UsedGradleVersions usedGradleVersions;
    private Set<CacheVersion> usedVersions;

    public static UnusedVersionsCacheCleanup create(String cacheName, CacheVersionMapping cacheVersionMapping, UsedGradleVersions usedGradleVersions) {
        Pattern cacheNamePattern = Pattern.compile('^' + Pattern.quote(cacheName) + "-((?:\\d+" + Pattern.quote(".") + ")*\\d+)$");
        return new UnusedVersionsCacheCleanup(cacheNamePattern, cacheVersionMapping, usedGradleVersions);
    }

    private UnusedVersionsCacheCleanup(Pattern cacheNamePattern, CacheVersionMapping cacheVersionMapping, UsedGradleVersions usedGradleVersions) {
        super((baseDir, filter) -> {
            IOFileFilter combinedFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), new RegexFileFilter(cacheNamePattern), FileFilterUtils.asFileFilter((FileFilter)filter), FileFilterUtils.asFileFilter((FileFilter)new NonReservedFileFilter(Collections.singleton(baseDir)))});
            File[] result = baseDir.getParentFile().listFiles((FileFilter)combinedFilter);
            return result == null ? Collections.emptySet() : Arrays.asList(result);
        });
        this.cacheNamePattern = cacheNamePattern;
        this.cacheVersionMapping = cacheVersionMapping;
        this.usedGradleVersions = usedGradleVersions;
    }

    @Override
    public void clean(CleanableStore cleanableStore, CleanupProgressMonitor progressMonitor) {
        this.determineUsedVersions();
        super.clean(cleanableStore, progressMonitor);
    }

    private void determineUsedVersions() {
        this.usedVersions = new TreeSet<CacheVersion>();
        for (GradleVersion gradleVersion : this.getUsedGradleVersionsSmallerThanCurrent()) {
            this.usedVersions.addAll(this.cacheVersionMapping.getVersionUsedBy(gradleVersion).asSet());
        }
    }

    private SortedSet<GradleVersion> getUsedGradleVersionsSmallerThanCurrent() {
        return this.usedGradleVersions.getUsedGradleVersions().headSet(GradleVersion.current());
    }

    @Override
    protected boolean shouldDelete(File cacheDir) {
        Matcher matcher = this.cacheNamePattern.matcher(cacheDir.getName());
        if (matcher.matches()) {
            CacheVersion version = CacheVersion.parse(matcher.group(1));
            return version.compareTo(this.cacheVersionMapping.getLatestVersion()) < 0 && !this.usedVersions.contains(version);
        }
        return false;
    }

    @Override
    protected void handleDeletion(File cacheDir) {
        LOGGER.debug("Deleting unused versioned cache directory at {}", (Object)cacheDir);
    }

    @Override
    protected int deleteEmptyParentDirectories(File baseDir, File dir) {
        return 0;
    }
}

