/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.util.Platform;
import com.izforge.izpack.util.Platforms;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlatformModelMatcher {
    private final Platforms platforms;
    private final Platform platform;
    private static final Logger logger = Logger.getLogger(PlatformModelMatcher.class.getName());

    public PlatformModelMatcher(Platforms platforms, Platform platform) {
        this.platforms = platforms;
        this.platform = platform;
    }

    public Platform getCurrentPlatform() {
        return this.platform;
    }

    public boolean matchesCurrentPlatform(OsModel model) {
        return this.match(this.platform, model);
    }

    public boolean match(Platform platform, OsModel model) {
        boolean match = true;
        if (model.getArch() != null && model.getArch().length() != 0) {
            Platform.Arch arch = this.platforms.getArch(model.getArch());
            match = arch.equals((Object)platform.getArch());
        }
        if (match && model.getVersion() != null && model.getVersion().length() != 0) {
            boolean bl = match = platform.getVersion() != null && platform.getVersion().equals(model.getVersion());
        }
        if (match && model.getName() != null && model.getName().length() != 0) {
            Platform.Name name = this.platforms.getName(model.getName());
            match = name.equals((Object)platform.getName());
        }
        if (match && model.getFamily() != null) {
            Platform.Name family = this.platforms.getName(model.getFamily());
            match = platform.getName().isA(family);
        }
        if (match && model.getJre() != null && model.getJre().length() > 0) {
            match = platform.getJavaVersion() != null && platform.getJavaVersion().startsWith(model.getJre());
        }
        return match && (model.getFamily() != null || model.getName() != null || model.getVersion() != null || model.getArch() != null || model.getJre() != null);
    }

    public boolean matchesCurrentPlatform(List<OsModel> models) {
        return this.matches(this.platform, models);
    }

    public boolean matches(Platform platform, List<OsModel> models) {
        if (models == null || models.isEmpty()) {
            return true;
        }
        boolean log = logger.isLoggable(Level.FINE);
        for (OsModel model : models) {
            if (log) {
                logger.fine("Checking if OS constraints " + model + " match platform=" + platform);
            }
            if (!this.match(platform, model)) continue;
            if (log) {
                logger.fine("OS constraints matched platform");
            }
            return true;
        }
        if (log) {
            logger.fine("OS constraints do not match platform=" + platform);
        }
        return false;
    }
}

