---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques
---

# Mathématiques

Cette section détaille le sujet de la mise en forme des
[mathématiques](https://fr.wikipedia.org/wiki/Mathématiques).

Les sujets suivants font l'objet d'une page dédiée :

-   les [équations](/4_domaines_specialises/mathematiques/equations/start) ;
-   les [structures mathématiques](/4_domaines_specialises/mathematiques/structures/start)
    telles que les matrices, 
    [fractions](/4_domaines_specialises/mathematiques/structures/indices/start),
    [indices](/4_domaines_specialises/mathematiques/structures/indices/start),
    [délimiteurs](/4_domaines_specialises/mathematiques/structures/delimiteurs/start) ;
-   les [styles d'affichage](/4_domaines_specialises/mathematiques/styles/start) des
    mathématiques ;
-   les [symboles mathématiques](/4_domaines_specialises/mathematiques/symboles/start),
    y compris les 
    [polices et fontes mathématiques](/4_domaines_specialises/mathematiques/symboles/polices/start).


Quelques questions portent sur **l'affichage de mathématiques** :

-   [](/4_domaines_specialises/mathematiques/passer_en_mode_mathematique)
-   [](/4_domaines_specialises/mathematiques/encadrer_une_formule_mathematique)
-   [](/4_domaines_specialises/mathematiques/espaces_en_mode_mathematique)
-   [](/4_domaines_specialises/mathematiques/barrer_des_termes)
-   [](/4_domaines_specialises/mathematiques/aligner_des_nombres_sur_la_virgule)


Une autre série de question étudie les **liens entre les mathématiques**
**et les autres éléments d'un document** :

-   [](/4_domaines_specialises/mathematiques/composer_du_texte_en_mode_mathematique)
-   [](/4_domaines_specialises/mathematiques/coupures_de_lignes_en_mode_mathematique)
-   [](/4_domaines_specialises/mathematiques/composer_un_tableau_en_mode_mathematique)
-   [](/4_domaines_specialises/mathematiques/notes_de_bas_de_page_en_mode_mathematique)


:::{seealso}
Le sujet des mathématiques avec LaTeX est vaste. Dans le monde francophone, 
deux forums constituent de bonnes références sur ce sujet :
-  [MathemaTeX](https://www.mathematex.fr/) ;
-  [Les-mathematiques.net]( https://les-mathematiques.net/vanilla/categories/latex).

Vous pouvez également tester des formules mathématiques et consulter 
une large bibliothèque d'exemples sur 
[L4T (LaTeX for technics)](https://www.latex4technics.com/). 
:::


```{toctree}
:glob: true
:maxdepth: 1
:hidden:

*/start
*
```