---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, polices, caractères flous, texte flou, 
              texte pas net
---

# Pourquoi mes fontes deviennent-elles floues lorsque je passe à T1 ?

Vous avez des problèmes de césure et quelqu'un vous a suggéré d'utiliser 
`\usepackage[T1]{fontenc}` pour vous aider à les résoudre. 
Soudain, vous constatez que votre PDF final est devenu flou. 
Le problème peut se poser si vous passez par une sortie PostScript 
et que vous la convertissez ensuite en PDF, 
ou si vous utilisez pdfTeX pour l'ensemble du travail.

En fait, il s'agit du même problème que la plupart des autres 
concernant la [qualité du PDF](/5_fichiers/formats/pdf/generer_un_fichier_pdf_de_qualite) : 
vous avez abandonné votre configuration précédente utilisant 
les versions Type 1 des polices *Computer Modern*, 
et `dvips` a inséré les versions Type 3 des polices *European Computer Modern* 
dans la sortie de votre document (consultez "[](/5_fichiers/formats/fontes/formats_de_polices_adobe)" 
pour plus de détails sur ces types de polices ; 
notez aussi que *l'encodage* T1 n'a rien à voir directement avec le *format* Type 1).

Cependant, comme indiqué dans la question "[](/5_fichiers/formats/fontes/fontes_t1_8bits)", 
les versions Type 1 des polices de type *Computer Modern* en encodage T1 (ou équivalent) 
sont maintenant disponibles, à la fois comme polices "réelles" et 
comme jeux de polices virtuelles. 
Une solution consiste donc à utiliser l'une de ces alternatives.

L'alternative est de changer complètement de famille de police, par exemple *Times* (par défaut) 
ou l'une des nombreuses polices encodées par Adobe qui sont plus agréables. 
L'action par défaut de <ctanpkg:fontinst>, lors de la création de métriques pour une telle police, 
est de créer des paramètres pour les encodages OT1 et T1, 
il y a donc peu de changement dans ce qui se passe (au niveau de l'utilisateur) 
même si vous êtes passé à l'encodage T1 lors de l'utilisation des polices.

:::{sources}
[Fonts go fuzzy when you switch to T1](faquk:FAQ-fuzzy-T1)
:::
