;;;; latexnfo-mode.el

;;; Major mode for editing Latexinfo files.

;;; Robert J. Chassell          
;;; Converted to LaTeXinfo by Mike Clarkson
;;; Please send bug reports to:  mike@apl.ists.ca

;; Copyright (C) 1985, 1988, 1989, 1990, 1991 Free Software Foundation, Inc.
;; Copyleft  (C) 1988, 1989, 1990, 1991 Michael E. Clarkson


;;; This file is not a part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.


;;; Autoloads

(autoload 'latexinfo-format-region
          "latexinfo"
  "Convert the current region of the Latexinfo file to Info format.
This lets you see what that part of the file will look like in Info.
The command is bound to \\[latexinfo-format-region].  The text that is
converted to Info is stored in a temporary buffer."
          t nil)

(autoload 'latexinfo-format-buffer
          "latexinfo"
  "Process the current buffer as latexinfo code, into an Info file.
The Info file output is generated in a buffer visiting the Info file
names specified in the \\setfilename command.

Non-nil argument (prefix, if interactive) means don't make tag table
and don't split the file if large.  You can use Info-tagify and
Info-split to do these manually."
          t nil)

(autoload 'kill-compilation
          "compile"
  "Kill the process made by the \\[compile] command."
          t nil)

(autoload 'latexinfo-latex-region
          "latexnfo-tex"
  "Run latex on the current region. 

A temporary file is written in the default directory, and LaTeX is run
in that directory.  The first line of the file is copied to the
temporary file; and if the buffer has a header, it is written to the
temporary file before the region itself.  The buffer's header is all
lines between the strings defined by latexinfo-start-of-header and
latexinfo-end-of-header inclusive.  The header must start in the first 100
lines.  The value of latexinfo-latex-trailer is appended to the temporary file
after the region."
          t nil)

(autoload 'latexinfo-latex-buffer
          "latexnfo-tex"
  "Run LaTeX on current buffer.
After running LaTeX the first time, you may have to run \\[latexinfo-latexindex]
and then \\[latexinfo-latex-buffer] again."
          t nil)

(autoload 'latexinfo-kill-latex-job
          "latexnfo-tex"
  "Kill the currently running LaTeX job."
          t nil)

(autoload 'latexinfo-recenter-latex-output-buffer
          "latexnfo-tex"
  "Redisplay buffer of LaTeX job output so that most recent output can be seen.
The last line of the buffer is displayed on
line LINE of the window, or centered if LINE is nil."
          t nil)

(autoload 'latexinfo-delete-from-latex-print-queue
          "latexnfo-tex"
  "Delete job from the line printer spooling queue.
You are prompted for the job number (shown by a previous
\\[latexinfo-show-latex-print-queue] command."
          t nil)

(autoload 'latexinfo-show-latex-print-queue
          "latexnfo-tex"
  "Show the print queue that \\[latexinfo-latex-print] put your job on.
Runs the shell command defined by latexinfo-show-latex-queue-command."
          t nil)

(autoload 'latexinfo-latex-print
          "latexnfo-tex"
  "Print .dvi file made by \\[latexinfo-latex-region] or \\[latexinfo-latex-buffer].
Runs the shell command defined by latexinfo-latex-dvi-print-command."
          t nil)

(autoload 'latexinfo-latexindex
          "latexnfo-tex"
  "Run latexindex on unsorted index files.
The index files are made by \\[latexinfo-latex-region] or \\[latexinfo-latex-buffer].
Runs the shell command defined by latexinfo-latexindex-command."
          t nil)

(autoload 'latexinfo-make-menu
          "latexnfo-upd"
  "Without any prefix argument, make or update a menu.
Make the menu for the section enclosing the node found following point.

Non-nil argument (prefix, if interactive) means make or update menus
for nodes within or part of the marked region.

Whenever a menu exists, and is being updated, the descriptions that
are associated with node names in the pre-existing menu are
incorporated into the new menu.  Otherwise, the nodes' section titles
are inserted as descriptions."
          t nil)

(autoload 'latexinfo-update-node
          "latexnfo-upd"
  "Without any prefix argument, update the node in which point is located.
Non-nil argument (prefix, if interactive) means update the nodes in the
marked region.

The functions for creating or updating nodes and menus, and their
keybindings, are:

    latexinfo-update-node (&optional region-p)    \\[latexinfo-update-node]
    latexinfo-every-node-update ()                \\[latexinfo-every-node-update]
    latexinfo-sequential-node-update (&optional region-p)

    latexinfo-make-menu (&optional region-p)      \\[latexinfo-make-menu]
    latexinfo-all-menus-update ()                 \\[latexinfo-all-menus-update]
    latexinfo-master-menu ()

    latexinfo-indent-menu-description (column &optional region-p)

The `latexinfo-column-for-description' variable specifies the column to
which menu descriptions are indented. Its default value is 24."
          t nil)

(autoload 'latexinfo-every-node-update
          "latexnfo-upd"
  "Update every node in a Latexinfo file."
          t nil)

(autoload 'latexinfo-all-menus-update
          "latexnfo-upd"
  "Update every regular menu in a Latexinfo file.
Remove pre-existing master menu, if there is one.

If called with a non-nil argument, this function first updates all the
nodes in the buffer before updating the menus."
          t nil)

(autoload 'latexinfo-master-menu
          "latexnfo-upd"
  "Make a master menu for a whole Latexinfo file.
Non-nil argument (prefix, if interactive) means first update all
existing nodes and menus.  Remove pre-existing master menu, if there is one.

This function creates a master menu that follows the top node.  The
master menu includes every entry from all the other menus.  It
replaces any existing ordinary menu that follows the top node.

If called with a non-nil argument, this function first updates all the
menus in the buffer (incorporating descriptions from pre-existing
menus) before it constructs the master menu.

The function removes the detailed part of an already existing master
menu.  This action depends on the pre-exisitng master menu using the
standard `latexinfo-master-menu-header'.

The master menu has the following format, which is adapted from the
recommendation in the Latexinfo Manual:

   * The first part contains the major nodes in the Latexinfo file: the
     nodes for the chapters, chapter-like sections, and the major
     appendices.  This includes the indices, so long as they are in
     chapter-like sections, such as chapter* sections.

   * The second and subsequent parts contain a listing of the other,
     lower level menus, in order.  This way, an inquirer can go
     directly to a particular node if he or she is searching for
     specific information.

Each of the menus in the detailed node listing is introduced by the
title of the section containing the menu."
          t nil)

(autoload 'latexinfo-indent-menu-description
          "latexnfo-upd"
  "Indent every description in menu following point to COLUMN.  
Non-nil argument (prefix, if interactive) means indent every
description in every menu in the region.  Does not indent second and
subsequent lines of a multi-line description."
          t nil)

(autoload 'latexinfo-sequential-node-update
          "latexnfo-upd"
  "Update one node (or many) in a Latexinfo file with sequential pointers.

This function causes the `Next' or `Previous' pointer to point to the
immediately preceding or following node, even if it is at a higher or
lower hierarchical level in the document.  Continually pressing `n' or
`p' takes you straight through the file.

Without any prefix argument, update the node in which point is located.
Non-nil argument (prefix, if interactive) means update the nodes in the
marked region.

This command makes it awkward to navigate among sections and
subsections; it should be used only for those documents that are meant
to be read like a novel rather than a reference, and for which the
Info `g*' command is inadequate."
          t nil)

(autoload 'latexinfo-insert-node-lines
          "latexnfo-upd"
  "Insert missing `\\node' lines in region of Latexinfo file.
Non-nil argument (prefix, if interactive) means also to insert the
section titles as node names; and also to insert the section titles as
node names in pre-existing \\node lines that lack names."
          t nil)

(autoload 'latexinfo-multiple-files-update
          "latexnfo-upd"
  "Update first node pointers in each file included in OUTER-FILE;
create or update main menu in the outer file that refers to such nodes. 
This does not create or update menus or pointers within the included files.

With optional MAKE-MASTER-MENU argument (prefix arg, if interactive),
insert a master menu in OUTER-FILE.  This does not create or update
menus or pointers within the included files.

With optional UPDATE-EVERYTHING argument (numeric prefix arg, if
interactive), update all the menus and all the `Next', `Previous', and
`Up' pointers of all the files included in OUTER-FILE before inserting
a master menu in OUTER-FILE.

The command also updates the `Top' level node pointers of OUTER-FILE.

Notes: 

  * this command does NOT save any files--you must save the
    outer file and any modified, included files.

  * except for the `Top' node, this command does NOT handle any
    pre-existing nodes in the outer file; hence, indices must be
    enclosed in an included file.

Requirements:

  * each of the included files must contain exactly one highest
    hierarchical level node, 
  * this highest node must be the first node in the included file,
  * each highest hierarchical level node must be of the same type.

Thus, normally, each included file contains one, and only one,
chapter."
          t nil)


;;; Syntax table

(defvar latexinfo-mode-syntax-table nil)

(if latexinfo-mode-syntax-table
    nil
  (setq latexinfo-mode-syntax-table (make-syntax-table))
  (modify-syntax-entry ?\" " " latexinfo-mode-syntax-table)
  (modify-syntax-entry ?@ "w" latexinfo-mode-syntax-table)
  (modify-syntax-entry ?\\ "\\" latexinfo-mode-syntax-table)
  (modify-syntax-entry ?\^q "\\" latexinfo-mode-syntax-table)
  (modify-syntax-entry ?\[ "(]" latexinfo-mode-syntax-table)
  (modify-syntax-entry ?\] ")[" latexinfo-mode-syntax-table)
  (modify-syntax-entry ?{ "(}" latexinfo-mode-syntax-table)
  (modify-syntax-entry ?} "){" latexinfo-mode-syntax-table)
  (modify-syntax-entry ?$ "w" latexinfo-mode-syntax-table)
  (modify-syntax-entry ?\' "w" latexinfo-mode-syntax-table))


;;; Keybindings
(defvar latexinfo-mode-map nil)

;;; Keys common both to Latexinfo mode and to LaTeX shell.

(defun latexinfo-define-common-keys (keymap)
  "Define the keys both in Latexinfo mode and in the latexinfo-latex-shell."
  (define-key keymap "\C-c\C-t\C-k"    'latexinfo-kill-latex-job)
  (define-key keymap "\C-c\C-t\C-x"    'latexinfo-quit-latex-job)
  (define-key keymap "\C-c\C-t\C-l"    'latexinfo-recenter-latex-output-buffer)
  (define-key keymap "\C-c\C-t\C-d"    'latexinfo-delete-from-latex-print-queue)
  (define-key keymap "\C-c\C-t\C-q"    'latexinfo-show-latex-print-queue)
  (define-key keymap "\C-c\C-t\C-p"    'latexinfo-latex-print)
  (define-key keymap "\C-c\C-t\C-i"    'latexinfo-latexindex)

  (define-key keymap "\C-c\C-t\C-r"    'latexinfo-latex-region)
  (define-key keymap "\C-c\C-t\C-b"    'latexinfo-latex-buffer))

;; Mode documentation displays commands in reverse order 
;; from how they are listed in the latexinfo-mode-map.

(if latexinfo-mode-map
    nil
  (setq latexinfo-mode-map (make-sparse-keymap))

  ;; bindings for `latexnfo-tex.el'
  (latexinfo-define-common-keys latexinfo-mode-map)

  ;; bindings for `latexinfmt.el'
  (define-key latexinfo-mode-map "\C-c\C-e\C-r"    'latexinfo-format-region)
  (define-key latexinfo-mode-map "\C-c\C-e\C-b"    'latexinfo-format-buffer)

  ;; bindings for updating nodes and menus

  (define-key latexinfo-mode-map "\C-c\C-um"   'latexinfo-master-menu)

  (define-key latexinfo-mode-map "\C-c\C-u\C-m"   'latexinfo-make-menu)
  (define-key latexinfo-mode-map "\C-c\C-u\C-n"   'latexinfo-update-node)
  (define-key latexinfo-mode-map "\C-c\C-u\C-e"   'latexinfo-every-node-update)
  (define-key latexinfo-mode-map "\C-c\C-u\C-a"   'latexinfo-all-menus-update)
  (define-key latexinfo-mode-map "\C-c\C-u\C-i"	  'latexinfo-insert-node-lines)
  (define-key latexinfo-mode-map "\C-c\C-u\C-f"	  'latexinfo-multiple-files-update)
  (define-key latexinfo-mode-map "\C-c\C-u\C-d"	  'latexinfo-indent-menu-description)
  (define-key latexinfo-mode-map "\C-c\C-u\C-s"   'latexinfo-sequential-node-update)
  (define-key latexinfo-mode-map "\C-c\C-s"     'latexinfo-show-structure)

  (define-key latexinfo-mode-map "\C-c\C-c}"    'up-list)
  (define-key latexinfo-mode-map "\C-c\C-c{"    'latexinfo-insert-braces)

  ;; bindings for inserting strings

  (define-key latexinfo-mode-map "\C-c\C-cv"    'latexinfo-insert-var)
  (define-key latexinfo-mode-map "\C-c\C-cs"    'latexinfo-insert-samp)
  (define-key latexinfo-mode-map "\C-c\C-co"    'latexinfo-insert-noindent)
  (define-key latexinfo-mode-map "\C-c\C-cn"    'latexinfo-insert-node)
  (define-key latexinfo-mode-map "\C-c\C-ck"    'latexinfo-insert-kbd)
  (define-key latexinfo-mode-map "\C-c\C-ci"    'latexinfo-insert-item)
  (define-key latexinfo-mode-map "\C-c\C-cx"    'latexinfo-insert-example)
  (define-key latexinfo-mode-map "\C-c\C-ce"    'latexinfo-insert-end)
  (define-key latexinfo-mode-map "\C-c\C-cd"    'latexinfo-insert-dfn)
  (define-key latexinfo-mode-map "\C-c\C-cc"    'latexinfo-insert-code))


;;; Latexinfo mode

;; also defined in latexnfo-upd.el
(defvar latexinfo-chapter-level-regexp
  "chapter\\|chapter\\*\\|unnumbered"
  "*Regexp matching chapter-level headings (but not the top node).")

(defun latexinfo-mode ()
  "Major mode for editing Latexinfo files.

  It has these extra commands:
\\{latexinfo-mode-map}

  These are files that are used as input for LaTeX to make printed manuals
and also to be turned into Info files by \\[latexinfo-format-buffer].
These files are written in a version of LaTeX input format.

  Editing commands are like text-mode except that the syntax table is
set up so expression commands skip Latexinfo bracket groups.  To see
what the Info version of a region of the Latexinfo file will look like,
use \\[latexinfo-format-region].  This command runs Info on the current region
of the Latexinfo file and formats it properly.

  You can show the structure of a Latexinfo file with \\[latexinfo-show-structure].
This command shows the structure of a Latexinfo file by listing the
lines with the commands for \\chapter, \\section, and the like.
These lines are displayed in another window called the *Occur* window.
In that window, you can position the cursor over one of the lines and
use \\[occur-mode-goto-occurrence], to jump to the corresponding spot
in the Latexinfo file.

  In addition, Latexinfo mode provides commands that insert various
frequently used commands into the buffer.  You can use these
commands to save keystrokes.  And you can insert balanced braces with
\\[latexinfo-insert-braces] and later use the command \\[up-list] to
move forward past the closing brace.

Also, Latexinfo mode provides functions for automatically creating or
updating menus and node pointers.  These functions

  * insert the `Next', `Previous' and `Up' pointers of a node,
  * insert or update the menu for a section, and
  * create a master menu for a Latexinfo source file.

Here are the functions:

    latexinfo-update-node                \\[latexinfo-update-node]
    latexinfo-every-node-update          \\[latexinfo-every-node-update]
    latexinfo-sequential-node-update 

    latexinfo-make-menu                  \\[latexinfo-make-menu]
    latexinfo-all-menus-update           \\[latexinfo-all-menus-update]
    latexinfo-master-menu

    latexinfo-indent-menu-description (column &optional region-p)

The `latexinfo-column-for-description' variable specifies the column to
which menu descriptions are indented. 

Passed an argument (a prefix argument, if interactive), the
`latexinfo-update-node' and `latexinfo-make-menu' functions do their jobs
in the region.

To use the updating commands, you must structure your Latexinfo file
hierarchically, such that each `\\node' line, with the exception of the
Top node, is accompanied by some kind of section line, such as an
`\\chapter' or `\\section' line.

If the file has a `top' node, it must be called `top' or `Top' and
be the first node in the file.

Entering Latexinfo mode calls the value of text-mode-hook, and then the
value of latexinfo-mode-hook."
  (interactive)
  (text-mode)
  (setq mode-name "Latexinfo")
  (setq major-mode 'latexinfo-mode)
  (use-local-map latexinfo-mode-map)
  (set-syntax-table latexinfo-mode-syntax-table)
  (make-local-variable 'page-delimiter)
  (setq page-delimiter 
        (concat 
         "^\\\\node [ \t]*[Tt]op\\\\|^\\\\\\(" 
         latexinfo-chapter-level-regexp 
         "\\)"))
  (make-local-variable 'require-final-newline)
  (setq require-final-newline t)
  (make-local-variable 'indent-tabs-mode)
  (setq indent-tabs-mode nil)
  (make-local-variable 'paragraph-separate)
  (setq paragraph-separate (concat "^\b\\|^\\\\[a-zA-Z{}]*[ \n]\\|" paragraph-separate))
  (make-local-variable 'paragraph-start)
  (setq paragraph-start (concat "^\b\\|^\\\\[a-zA-Z{}]*[ \n]\\|" paragraph-start))
  (make-local-variable 'fill-column)
  (setq fill-column 72)
  (make-local-variable 'comment-start)
  (setq comment-start "\\c ")
  (make-local-variable 'comment-start-skip)
  (setq comment-start-skip "\\\\c +")
  (make-local-variable 'words-include-escapes)
  (setq words-include-escapes t)
  (make-local-variable 'latexinfo-start-of-header)
  (setq latexinfo-start-of-header "\\documentstyle")
  (make-local-variable 'latexinfo-end-of-header)
  (setq latexinfo-end-of-header "\\setfilename")
  (run-hooks 'text-mode-hook 'latexinfo-mode-hook))


;;; Define start and end of header expressions 

;; The start-of-header and end-of-header expressions are defined here
;; since they used by both by `latexinfmt.el' and by `latexnfo-tex.el',
;; only one of which is likely to be loaded at one time.

(defvar latexinfo-start-of-header "\\documentstyle"
  "String to mark start of header for latexinfo-latex-region.")

(defvar latexinfo-end-of-header "\\begin{document}"
  "String to mark end of header for latexinfo-latex-region.")


;;; Insert string commands

(defun latexinfo-insert-var ()
  "Insert the string \\var{} in a latexinfo buffer."
  (interactive)
  (insert "\\var{}")
  (backward-char))

(defun latexinfo-insert-samp ()
  "Insert the string \\samp{} in a latexinfo buffer."
  (interactive)
  (insert "\\samp{}")
  (backward-char))

(defun latexinfo-insert-noindent ()
  "Insert the string \\noindent in a latexinfo buffer."
  (interactive)
  (insert "\\noindent\n"))

(defun latexinfo-insert-node ()
  "Insert the string \\node in a latexinfo buffer, 
along with a comment indicating the arguments to \\node."
  (interactive)
  (insert "\\node     \n\\comment  node-name,  next,  previous,  up")
  (forward-line -1)
  (forward-char 6))

(defun latexinfo-insert-kbd ()
  "Insert the string \\kbd in a latexinfo buffer."
  (interactive)
  (insert "\\kbd{}")
  (backward-char))

(defun latexinfo-insert-item ()
  "Insert the string \\item in a latexinfo buffer."
  (interactive)
  (insert "\\item")
  (newline))

(defun latexinfo-insert-example ()
  "Insert the string \\begin{example} in a latexinfo buffer."
  (interactive)
  (insert "\\begin{example}\n\\begin{example}\n")
  (forward-line -2))

(defun latexinfo-insert-end ()
  "Insert the string `\\end{}' in a latexinfo buffer."
  (interactive)
  (insert "\\end{}"))

(defun latexinfo-insert-dfn ()
  "Insert the string \\dfn{} in a latexinfo buffer."
  (interactive)
  (insert "\\dfn{}")
  (backward-char))

(defun latexinfo-insert-code ()
  "Insert the string \\code{} in a latexinfo buffer."
  (interactive)
  (insert "\\code{}")
  (backward-char))

(defun latexinfo-insert-braces ()
  "Make a pair of braces and be poised to type inside of them.
Use \\[up-list] to move forward out of the braces."
  (interactive)
  (insert "{}")
  (backward-char))


;;; Latexinfo file structure

; The following is defined in `latexnfo-upd.el'
; (defvar latexinfo-section-types-regexp
;   "^\\\\\\(chapter\\|sect\\|sub\\|unnum\\)"
;   "Regexp matching chapter, section, other headings (but not the top node).")

(defun latexinfo-show-structure (&optional nodes-too) 
  "Show the structure of a Latexinfo file.
List the lines in the file that begin with the commands for
\\chapter, \\section, and the like.

With optional argument (prefix if interactive), list both the lines
with commands for \\chapter, \\section, and the like, and list
\\node lines.

Lines with structuring commands beginning in them are displayed in
another window called the *Occur* window.  In that window, you can
position the cursor over one of the lines and use
\\[occur-mode-goto-occurrence], 
to jump to the corresponding spot in the Latexinfo file."

  (interactive "P")
  (if (not (fboundp 'latexinfo-make-menu)) (load "latexnfo-upd"))
  (save-excursion 
    (goto-char (point-min))
    (if nodes-too
        (occur (concat "\\(^\\\\node\\)\\|" latexinfo-section-types-regexp))
      (occur latexinfo-section-types-regexp)))
  (pop-to-buffer "*Occur*")
  (goto-char (point-min))
  (flush-lines "-----"))


;;; Place provide at end of file.
(provide 'latexnfo-mde)
;;;;;;;;;;;;;;;; end latexinfo.el ;;;;;;;;;;;;;;;;
