{ Turbo-Pascal 6.0 }
{$A+,B-,D-,E-,F-,G-,I-,L-,N-,O-,R-,S-,V+,X-}
{$M 4000,0,0}
uses dos, crt;

type shortstr=string[12];
var cddrive,userdrive : string[2];
    c: char;

procedure exitproc;
begin
  Window(1,1,80,24);
  Textbackground(black);
  Textcolor(white);
  Clrscr;
  Writeln('You aborted the 4TeX installation program!');
  Writeln;
  halt;
end;

procedure read_a_key;
begin
  c:=readkey;
  if ord(c)=27 then exitproc
end;

procedure hidecursor; assembler;

asm
	MOV AH,$01
	XOR BH,BH
	MOV CX,$2000
	INT 10h
end; {hidecursor}

procedure normcursor; assembler;

asm
	MOV CL,$07
	MOV CH,$06
	CMP [Lastmode],7
	JNE @@1
	MOV CL,$0C
	MOV CH,$0B
@@1:
	MOV AH,$01
	XOR BH,BH
	MOV CX,$0B0C
	INT 10h
end; {normcursor}

procedure prtitel;

var
  i, j : Integer;
  prnaam : array [1..14] of string [80];

begin
  hidecursor;
  prnaam[ 1] := '         Ŀ     Ŀ     Ŀ     Ŀ         ';
  prnaam[ 2] := '                                                             ';
  prnaam[ 3] := '                                                               ';
  prnaam[ 4] := '                                                       ';
  prnaam[ 5] := '                                                        ';
  prnaam[ 6] := '                                                             ';
  prnaam[ 7] := '                                                            ';
  prnaam[ 8] := '                                                            ';
  prnaam[ 9] := '                                                          ';
  prnaam[10] := '                                                       ';
  prnaam[11] := '                                                            ';
  prnaam[12] := '                                    ';
  prnaam[13] := '                                                                      ';
  prnaam[14] := '                                                                             ';
  Textbackground(blue);
  Clrscr;
  Gotoxy(1,25);
  for j := 1 to 14 do
  begin
    for i := 1 to 80 do
    begin
      if (prnaam[j,i] in [#179,#191,#192,#196,#217,#218]) then
      begin
        if (i in [1..22]) then
        Textcolor(lightmagenta);
        if (i in [23..39]) then
        Textcolor(lightred);
        if (i in [39..60]) then
        Textcolor(yellow);
        if (i in [60..72]) then
        Textcolor(lightgreen);
      end
      else
      Textcolor(lightcyan);
      Write(prnaam[j,i]);
    end;
    Delay(10);
  end;
  for i := 1 to 9 do
  begin
    Writeln;
    Delay(10);
  end;
  Textcolor(white);
  Window(22,17,70,24);
  Textcolor(black);
  Writeln('  Ŀ');
  Writeln('                                   ');
  Writeln('                                   ');
  Writeln('                                   ');
  Writeln('                                   ');
  Writeln('  ');
  Window(29,18,62,24);
  Textcolor(white);
  Writeln('        Wietse Dol');
  Writeln('      Erik Frambach');
  Writeln('Maarten H. van der Vlerk');
  Writeln('    (c) 4U, 1991-1994');
  Window(1,1,80,24);
  Delay(400);
end; {prtitel}

procedure box;
begin
  Textcolor(white);
  Window(5,16,75,25);
  Textcolor(black);
  Writeln('  Ŀ');
  Writeln('                                                                   ');
  Writeln('                                                                   ');
  Writeln('                                                                   ');
  Writeln('                                                                   ');
  Writeln('                                                                   ');
  Writeln('                                                                   ');
  Writeln('                                                                   ');
  Writeln('  ');
  Window(10,18,75,24);
  Textcolor(white);
end;

procedure introtext;
begin
  box;
  Writeln('This program will create some directories and copy some files.');
  Writeln('After this you can run 4TeX from CD-rom without installing');
  Writeln('all the programs on your harddisk.');
  Writeln;
  Writeln('Press any key ...');
  read_a_key;
end;

procedure User_SYSTEM_drive;
begin
  repeat
    box;
    Window(10,17,75,24);
    Writeln('To install 4TeX we need to know the drive letter');
    Writeln('of the CD-rom drive and the drive you want to use');
    Writeln('for your own TeX-files.                           ');
    Writeln;
    normcursor;
    Write('CD-rom Drive: ');
    read_a_key;
    cddrive:=c+':';
    Writeln(cddrive);
    Write('Userfiles Drive: ');
    read_a_key;
    userdrive:=c+':';
    writeln(userdrive);
    gotoxy(35,24);
    write('Drive letters correct (Y/N)?');
    read_a_key;
  until upcase(c)='Y';
  hidecursor;
end;

procedure dosprog(programname, parameters:string);
begin
  swapvectors;
  Exec(programname,parameters);
  swapvectors;
end;

procedure make_dirs;
begin
  Window(1,1,80,24);
  clrscr;
  Writeln('Create directories: ');
  Writeln(userdrive+'\texfiles');
  dosprog(getenv('COMSPEC'),'/c mkdir '+userdrive+'\texfiles > nul');
  Writeln(userdrive+'\texfiles\bibfiles');
  dosprog(getenv('COMSPEC'),'/c mkdir '+userdrive+'\texfiles\bibfiles > nul');
  Writeln(userdrive+'texfiles\fonts');
  dosprog(getenv('COMSPEC'),'/c mkdir '+userdrive+'\texfiles\fonts > nul');
  Writeln(userdrive+'\texfiles\macros');
  dosprog(getenv('COMSPEC'),'/c mkdir '+userdrive+'\texfiles\macros > nul');
  Writeln(userdrive+'\texfiles\mf');
  dosprog(getenv('COMSPEC'),'/c mkdir '+userdrive+'\texfiles\mf > nul');
  Writeln(userdrive+'\texfiles\pictures');
  dosprog(getenv('COMSPEC'),'/c mkdir '+userdrive+'\texfiles\pictures > nul');
  Writeln(userdrive+'\texfiles\spell');
  dosprog(getenv('COMSPEC'),'/c mkdir '+userdrive+'\texfiles\spell > nul');
  Writeln(userdrive+'\texfiles\texinput');
  dosprog(getenv('COMSPEC'),'/c mkdir '+userdrive+'\texfiles\texinput > nul');
  Writeln(userdrive+'\texfiles\tfm');
  dosprog(getenv('COMSPEC'),'/c mkdir '+userdrive+'\texfiles\tfm > nul');
  Writeln;
  Writeln('Scan the drives with ACD');
  dosprog(getenv('COMSPEC'),'/c '+cddrive+'\emtex\utils\acd.exe /create');
  Writeln;
end;

procedure copyfiles;
begin
  Writeln('Copy files:');
  dosprog(getenv('COMSPEC'),'/c copy '+cddrive+'\emtex\btm\texuser.set '+userdrive+'\texfiles > nul');
  Writeln(cddrive+'\emtex\btm\texuser.set ==> '+userdrive+'\texfiles\texuser.set');
  dosprog(getenv('COMSPEC'),'/c copy '+cddrive+'\emtex\utils\sharewar\qedit\*.qm '+userdrive+'\texfiles\macros > nul');
  Writeln(cddrive+'\emtex\utils\sharewar\qedit\*.qm  ==> '+userdrive+'\texfiles\macros\*.qm');
  dosprog(getenv('COMSPEC'),'/c copy '+cddrive+'\emtex\utils\sharewar\qedit\edit.hlp '+userdrive+'\texfiles\macros > nul');
  Writeln(cddrive+'\emtex\utils\sharewar\qedit\edit.hlp  ==> '+userdrive+'\texfiles\macros\edit.hlp');
  Writeln;
end;

procedure patch(filename:shortstr);
var inf, outf : text;
    regel     : string;
begin
  assign(inf,filename);
  assign(outf,'_dump_');
  reset(inf);
  rewrite(outf);
  repeat
    readln(inf,regel);
    if pos('t:\',regel) > 0 then
      regel:=copy(regel,1,pos('t:\',regel)-1)+userdrive+'\texfiles\macros\'+copy(regel,pos('t:\',regel)+25,255);
    writeln(outf,regel);
  until(eof(inf));
  close(inf);
  close(outf);
  dosprog(getenv('COMSPEC'),'/c copy _dump_ '+filename+' > nul');
  dosprog(getenv('COMSPEC'),'/c del _dump_ > nul');
end;

procedure make_macros;
begin
  dosprog(getenv('COMSPEC'),'/c '+userdrive);
  dosprog(getenv('COMSPEC'),'/c chdir '+userdrive+'\texfiles\macros');
  Writeln('Change Qedit macros for 4TeX');
  patch('tex.qm');
  patch('blok.qm');
  Writeln('Compile Qedit macros for 4TeX');
  Writeln;
  dosprog(getenv('COMSPEC'),'/c '+cddrive+'\emtex\utils\sharewar\qedit\qmac tex.mac tex.qm /b /a- > nul');
  dosprog(getenv('COMSPEC'),'/c '+cddrive+'\emtex\utils\sharewar\qedit\qmac blok.mac blok.qm /b /a- > nul');
  dosprog(getenv('COMSPEC'),'/c '+cddrive+'\emtex\utils\sharewar\qedit\qmac error.mac error.qm /b /a- > nul');
  dosprog(getenv('COMSPEC'),'/c '+cddrive+'\emtex\utils\sharewar\qedit\qmac bib.mac bib.qm /b /a- > nul');
  dosprog(getenv('COMSPEC'),'/c '+cddrive+'\emtex\utils\sharewar\qedit\qmac glossary.mac glossary.qm /b /a- > nul');
end;

procedure make_texuser;
var inf, outf : text;
    regel     : string;
begin
  dosprog(getenv('COMSPEC'),'/c chdir '+userdrive+'\texfiles');
  Writeln('Change TEXUSER.set, i.e. user settings for 4TeX');
  assign(inf,'texuser.set');
  assign(outf,'_dump_');
  reset(inf);
  rewrite(outf);
  repeat
    readln(inf,regel);
    if pos('DRIVE=',regel)=1 then  regel:='DRIVE='+cddrive+'\emtex';
    if pos('USERDRIVE=',regel)=1 then regel:='USERDRIVE='+userdrive+'\texfiles';
    writeln(outf,regel);
  until(eof(inf));
  close(inf);
  close(outf);
  dosprog(getenv('COMSPEC'),'/c copy _dump_ texuser.set > nul');
  dosprog(getenv('COMSPEC'),'/c del _dump_ > nul');
end;

procedure make_startbatch;
var outf : text;
    Do_dos: boolean;
begin
  Do_dos:=true;
  assign(outf,'4tex.bat');
  rewrite(outf);
  Writeln('Create batch file to start 4TeX');
  writeln(outf,'@echo off');
  writeln(outf,'set 4TEXPATH=',userdrive,'\texfiles');
  if (pos('4DOS',getenv('COMSPEC'))>0) or (pos('4dos',getenv('COMSPEC'))>0) then
  begin
    Write('Do you have 4DOS version 5.0 (or higher) (Y/N)?');
    read_a_key;
    write(c);
    if upcase(c)='Y' then Do_dos:=false;
  end;
  if Do_dos then
    writeln(outf,cddrive,'\emtex\utils\sharewar\4dos\4dos.com @',cddrive,'\emtex\btm\4tex.ini /c ',
                 cddrive,'\emtex\btm\4tex.btm %1 %2 %3')
  else
    writeln(outf,'call ',cddrive,'\emtex\btm\tex.btm');
  writeln(outf,'set 4TEXPATH=');
  close(outf);
end;

procedure how_to_use;
begin
  prtitel;
  box;
  Writeln('To start 4TeX simply type');
  Writeln('   ',userdrive,'\texfiles\4tex.bat');
  Writeln('To see the startup options type');
  Writeln('   ',userdrive,'\texfiles\4tex.bat /?');
  Writeln;
  Writeln('Press any key ...');
  read_a_key;
  Window(1,1,80,25);
  Textbackground(black);
  Textcolor(white);
  Clrscr;
end;

begin
  prtitel;
  if getenv('comspec')='' then
  begin
    clrscr;
    writeln('You need to set the COMSPEC variable!!!');
    writeln('e.g. set COMSPEC=c:\command.com');
    read_a_key;
    halt;
  end;
  introtext;
  User_SYSTEM_drive;
  make_dirs;
  copyfiles;
  make_macros;
  make_texuser;
  make_startbatch;
  how_to_use;
end.
