/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant;

import de.nm.ant.AbstractWorkerTask;
import de.nm.string.XString;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.tools.ant.BuildException;

public abstract class AbstractWorkdirTask
extends AbstractWorkerTask {
    protected String basename;
    protected int buffersize = 65535;
    protected String newbasename = null;
    protected File workdir;

    protected InputStream createInputStream(File file) throws IOException {
        return new BufferedInputStream(new FileInputStream(file), this.buffersize);
    }

    protected String createNewBasename() {
        String bn = this.newbasename == null ? this.basename : (this.newbasename.contains("$basename") ? this.newbasename.replace("$basename", this.basename) : this.newbasename);
        return bn;
    }

    protected OutputStream createOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(file), this.buffersize);
    }

    protected BufferedReader createReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), this.encoding), this.buffersize);
    }

    protected File createWorkingInput(StringBuilder text, File input, String extname, boolean endtext, String command) throws IOException {
        File workinput;
        if (text == null || text.length() == 0) {
            workinput = input;
        } else {
            String line;
            if (this.workdir == null) {
                throw new BuildException("No workdir set.");
            }
            workinput = this.createFile(this.workdir, XString.concat((String[])new String[]{this.createBasename(input), ".", extname, "-tmp"}));
            BufferedWriter out = this.createWriter(workinput);
            out.write(text.toString());
            out.newLine();
            BufferedReader in = this.createReader(input);
            while ((line = in.readLine()) != null) {
                out.write(line);
                out.newLine();
            }
            in.close();
            if (endtext) {
                out.write(command);
            }
            out.close();
        }
        return workinput;
    }

    protected BufferedWriter createWriter(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.encoding), this.buffersize);
    }

    protected File getFile(String ext) {
        if (this.workdir == null) {
            throw new BuildException("'workdir' not set!");
        }
        if (this.basename == null) {
            throw new BuildException("'basename' not set!");
        }
        return this.createFile(this.workdir, this.createNewBasename(), ext);
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public void setBuffersize(int buffersize) {
        this.buffersize = buffersize;
    }

    public void setNewbasename(String newbasename) {
        this.newbasename = newbasename;
    }

    public void setWorkdir(File workdir) {
        this.workdir = workdir;
    }
}

