program cbapp2;

uses
  crt, dos, ch_files;

var
  source : sourcelisttype;
  target : sourcetype;



var
  f1, f2 : file;
  i: integer;
  index_val, j : longint;
  total_games, global_game_numb, game_numb: longint;
  games_in_file, temp, local_game_numb, source_numb: longint;

begin
  io_error:=false;
  io_test;

  if paramcount<2 then
  begin
    writeln;
    writeln('SYNTAX: CBAPPEND source-wildcard target-filename');
    writeln;
    writeln('EX:     CBAPPEND info* all-info');
    writeln;
    writeln('Makes a gamefile and an indexfile called all-info.cbf and all-info.cbi');
    writeln('consisting of all ChessBase files starting with info*');
    writeln('A subset of info* is selected after prompting.');
    writeln('If all-info.* already exists, all new files are appended to it');
    writeln;
    write('Type source wildcard: ');
    readln(source[0].name);
    write('Type target filename: ');
    readln(target.name);
    writeln;
  end
  else
  begin
    source[0].name:=paramstr(1);
    target.name:=paramstr(2);
  end;

  writeln('Any comment welcome!      Carsten Hansen, CH0506@HDC.HHA.DK');
  writeln;
  writeln;
  remove_ext(source[0].name);
  remove_ext(target.name);

  find_path(source[0].name, source[0].path);
  find_path(target.name,  target.path);
  source[1]:=target;
  select_source_files(source);

  open_file_for_write(target.index,'--target.-BI');
  open_file_for_write(target.game,'--target.-BF');

  i:=1;
  index_val:=0;
  total_games:=total_numb_of_games(source);
  put_index_val(target.index,total_games+1);
  global_game_numb:=0;
  game_numb:=0;
  source_numb:=0;
  while (i<=source_max) and (not io_error) do
  begin
    if (source[i].name<>'') and
       file_exist(source[i].path+source[i].name+'.CBI') and
       file_exist(source[i].path+source[i].name+'.CBF') then
    begin
      open_file_for_read(source[i].index,
                         source[i].path+source[i].name+'.CBI');

      open_file_for_read(source[i].game,
                         source[i].path+source[i].name+'.CBF');

      games_in_file:=get_index_val(source[i].index)-1;
      write(games_in_file:7,' Games in ',source[i].name);
      inc(source_numb);
      if source_numb=1 then
      begin
        temp:=get_index_val(source[i].index);
        put_index_val(target.index,temp);
        index_val:=2;
      end
      else
        temp:=index_val+get_index_val(source[i].index);
      index_val:=index_val-global_game_numb-2;
      local_game_numb:=0;
      for j:=1 to games_in_file-1 do
      begin
        inc(local_game_numb);
        inc(global_game_numb);
        temp:=index_val+get_index_val(source[i].index)-
                      local_game_numb+global_game_numb;
        put_index_val(target.index,temp);
        if (local_game_numb mod 100)=0 then
          write('.');
      end;
      inc(local_game_numb);
      inc(global_game_numb);
      temp:=index_val+get_index_val(source[i].index)-
                    local_game_numb+global_game_numb;
      for j:=1 to filesize(source[i].game.f) do
      begin
        put_next_byte(target.game,get_next_byte(source[i].game));
        if ((j mod 2000)=0) then
          write('.');
      end;
      writeln;
      index_val:=target.game.pos+3+global_game_numb;
      put_index_val(target.index,index_val);
      close_read_file(source[i].index);
      close_read_file(source[i].game);
    end;
    inc(i);
  end;
  close_write_file(target.index);
  close_write_file(target.game);

  if global_game_numb>0 then
  begin
    writeln('=========================================================');
    write(total_games:7,' Games in ');
    writeln(target.path,target.name);
    writeln('=========================================================');
    if file_exist(target.path+target.name+'.CBI') and
       file_exist(target.path+target.name+'.CBF') then
    begin

      assign(f1,target.path+target.name+'.CBI');
      erase_file(target.path+target.name+'.-BI');
      rename(f1,target.path+target.name+'.-BI');

      assign(f2,target.path+target.name+'.CBF');
      erase_file(target.path+target.name+'.-BF');
      rename(f2,target.path+target.name+'.-BF');

      writeln('RENAMING OLD ',target.name,'.CBI ===> ',target.name,'.-BI');
      writeln('RENAMING OLD ',target.name,'.CBF ===> ',target.name,'.-BF');
    end;
    rename(target.index.f,target.path+target.name+'.CBI');
    rename(target.game.f ,target.path+target.name+'.CBF');
  end
  else
  begin
    if source_numb<2 then
    begin
      writeln;
      writeln('NOT POSSIBLE TO FIND ANY MATCHING FILES');
      writeln;
    end;
  end;
end.

