/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.outline;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.texlipse.model.OutlineNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class TexContentProvider
implements ITreeContentProvider {
    private List<OutlineNode> rootElements;
    private ViewerFilter filter;

    public TexContentProvider(ViewerFilter filter) {
        this.filter = filter;
    }

    public Object[] getChildren(Object parentElement) {
        OutlineNode node = (OutlineNode)parentElement;
        ArrayList<OutlineNode> children = node.getChildren();
        if (children != null && children.size() != 0) {
            return children.toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return ((OutlineNode)element).getParent();
    }

    public boolean hasChildren(Object element) {
        OutlineNode node = (OutlineNode)element;
        ArrayList<OutlineNode> children = node.getChildren();
        if (children != null && children.size() != 0) {
            for (OutlineNode n : children) {
                if (!this.filter.select(null, element, (Object)n)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.rootElements.toArray();
    }

    public void dispose() {
        this.rootElements = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.rootElements = (List)newInput;
    }
}

