//
// Latex Project Public Licence (lppl1.3) applies
// Originally written by Kwanleung Tse
// First Release : 1st July, 2014
// Last Update : 25th September, 2014
//
//

package worker4math.hktex2;

import java.util.ArrayList;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.SparseBooleanArray;

public class Parsetitle {
	
	public static volatile SparseArray<Float> thisypos = new SparseArray<Float>();
	public static volatile SparseBooleanArray error = new SparseBooleanArray();
	public static volatile SparseArray<String> errormessage = new SparseArray<String>();
    
	public void parsetitle(Canvas canvas, Block block, ParagraphBlock paragraphblock, Integer tid, Integer containerwidth, Integer containerheight, int superblocknumber, SuperBlock superblock, 
			SparseArray<ArrayList<String>> superblockline, SparseIntArray superblocknumline, SparseIntArray superblockstartline, SparseIntArray superblockendline, float ypos, ArrayList<Typeface> tf , String attribute1){
		
		Parsetext title = new Parsetext();
		Character type=null;
		int j=-1;
		int fontsize=Header.fontsize;
		int tid2=tid*1000;
		int viewportwidth=containerwidth-Header.leftsidemargin-Header.rightsidemargin;
		float ypos2=ypos;
		Boolean endofline=false;
		String sfontsize="";

		String attribute2="1"+attribute1.substring(1);
		
		
		for (int i=0;i<=superblockline.get(superblocknumber).size()-1;i++){                      
			endofline=false;
			String line=superblockline.get(superblocknumber).get(i);
			line=line.trim();
			while(!endofline){
				if (line.substring(0,6).equals("!title")){type='t';line=line.substring(6).trim();j=line.indexOf("!!");}
				else if (line.substring(0,7).equals("!author")){type='a';line=line.substring(7).trim();j=line.indexOf("!!");ypos=ypos+5;thisypos.put(tid,ypos);}
				else if (line.substring(0,12).equals("!affiliation")){type='f';line=line.substring(12).trim();j=line.indexOf("!!");ypos=ypos+0;thisypos.put(tid,ypos);}
				else if (line.substring(0,6).equals("!email")){type='e';line=line.substring(6).trim();j=line.indexOf("!!");ypos=ypos+0;thisypos.put(tid,ypos);}
				else if (line.substring(0,5).equals("!date")){type='d';line=line.substring(5).trim();j=line.indexOf("!!");ypos=ypos+0;thisypos.put(tid,ypos);}
				else if (line.substring(0,5).equals("!text")){type='x';line=line.substring(5).trim();j=line.indexOf("!!");ypos=ypos+0;thisypos.put(tid,ypos);}
				else if (line.substring(0,7).equals("!vspace")){
					int ij=line.indexOf("}",7);
					float vspace=Integer.parseInt(line.substring(8,ij));
					ypos=ypos+vspace;
					line=line.substring(ij+1); line=line.trim();
					thisypos.put(tid,ypos);
				}
				else if (type=='t'){
					fontsize=(int)(Header.fontsize*Header.sizefactor.get("Huge"));if (fontsize>Header.maxfontsize){fontsize=Header.maxfontsize;};
					sfontsize=Integer.toString(fontsize);
					if (sfontsize.length()==1){
						attribute1 =  "000"+sfontsize+attribute1.substring(4);
						attribute2 =  "100"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==2){
						attribute1 =  "00"+sfontsize+attribute1.substring(4);
						attribute2 =  "10"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==3){
						attribute1 =  "0"+sfontsize+attribute1.substring(4);
						attribute2 =  "1"+sfontsize+"002"+attribute2.substring(7);
					}					
					line=line.trim();
					line="$!shadow{!mbox{"+line+"}}$";
					title.parsetext(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, line, Header.leftsidemargin , ypos, tf, attribute2, attribute1, false, 0.0f);
  			
					float adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(i))/2;
					for (int ii=0;ii<=SuperBlock.blockxpos.get(i+tid2).size()-1;ii++){
						SuperBlock.blockxpos.get(i+tid2).set(ii,SuperBlock.blockxpos.get(i+tid2).get(ii)+adjustx);
					}
					error.put(tid, Parsetext.error.get(tid)); if (error.get(tid)){errormessage.put(tid, Parsetext.errormessage.get(tid)); return;};
					ypos=Parsetext.thisypos.get(tid);
					thisypos.put(tid,ypos);
					endofline=true;
				}  		  
				else if (type=='a'){
					fontsize=(int)(Header.fontsize*Header.sizefactor.get("Large"));if (fontsize>Header.maxfontsize){fontsize=Header.maxfontsize;};
					sfontsize=Integer.toString(fontsize);
					if (sfontsize.length()==1){
						attribute1 =  "000"+sfontsize+attribute1.substring(4);
						attribute2 =  "100"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==2){
						attribute1 =  "00"+sfontsize+attribute1.substring(4);
						attribute2 =  "10"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==3){
						attribute1 =  "0"+sfontsize+attribute1.substring(4);
						attribute2 =  "1"+sfontsize+"002"+attribute2.substring(7);
					}					
					line=line.trim();
					line="$!bf{!mbox{"+line+"}}$";
					title.parsetext(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, line, Header.leftsidemargin , ypos, tf, attribute2, attribute1, false, 0.0f);
  			  		
					float adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(i))/2;
					for (int ii=0;ii<=SuperBlock.blockxpos.get(i+tid2).size()-1;ii++){
						SuperBlock.blockxpos.get(i+tid2).set(ii,SuperBlock.blockxpos.get(i+tid2).get(ii)+adjustx);
					}
					error.put(tid, Parsetext.error.get(tid)); if (error.get(tid)){errormessage.put(tid, Parsetext.errormessage.get(tid)); return;};
					ypos=Parsetext.thisypos.get(tid);
					thisypos.put(tid,ypos);
					endofline=true;
				}
				else if (type=='f'){
					fontsize=Header.fontsize;
					sfontsize=Integer.toString(fontsize);
					if (sfontsize.length()==1){
						attribute1 =  "000"+sfontsize+attribute1.substring(4);
						attribute2 =  "100"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==2){
						attribute1 =  "00"+sfontsize+attribute1.substring(4);
						attribute2 =  "10"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==3){
						attribute1 =  "0"+sfontsize+attribute1.substring(4);
						attribute2 =  "1"+sfontsize+"002"+attribute2.substring(7);
					}					
					line=line.trim();
					line="$!it{!mbox{"+line+"}}$";
					title.parsetext(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, line, Header.leftsidemargin , ypos, tf, attribute2, attribute1, false, 0.0f);
    			  		
					float adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(i))/2;
					for (int ii=0;ii<=SuperBlock.blockxpos.get(i+tid2).size()-1;ii++){
						SuperBlock.blockxpos.get(i+tid2).set(ii,SuperBlock.blockxpos.get(i+tid2).get(ii)+adjustx);
					}
					error.put(tid, Parsetext.error.get(tid)); if (error.get(tid)){errormessage.put(tid, Parsetext.errormessage.get(tid)); return;};
					ypos=Parsetext.thisypos.get(tid);
					thisypos.put(tid,ypos);
					endofline=true;
				}
				else if (type=='e'){
					fontsize=Header.fontsize;
					sfontsize=Integer.toString(fontsize);
					if (sfontsize.length()==1){
						attribute1 =  "000"+sfontsize+attribute1.substring(4);
						attribute2 =  "100"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==2){
						attribute1 =  "00"+sfontsize+attribute1.substring(4);
						attribute2 =  "10"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==3){
						attribute1 =  "0"+sfontsize+attribute1.substring(4);
						attribute2 =  "1"+sfontsize+"002"+attribute2.substring(7);
					}					
					line=line.trim();
					line="$!mo{!mbox{"+line+"}}$";
					title.parsetext(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, line, Header.leftsidemargin , ypos, tf, attribute2, attribute1, false, 0.0f);
    			  		
					float adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(i))/2;
					for (int ii=0;ii<=SuperBlock.blockxpos.get(i+tid2).size()-1;ii++){
						SuperBlock.blockxpos.get(i+tid2).set(ii,SuperBlock.blockxpos.get(i+tid2).get(ii)+adjustx);
					}
					error.put(tid, Parsetext.error.get(tid)); if (error.get(tid)){errormessage.put(tid, Parsetext.errormessage.get(tid)); return;};
					ypos=Parsetext.thisypos.get(tid);
					thisypos.put(tid,ypos);
					endofline=true;
				}
				else if (type=='d'){
					fontsize=Header.fontsize;
					sfontsize=Integer.toString(fontsize);
					if (sfontsize.length()==1){
						attribute1 =  "000"+sfontsize+attribute1.substring(4);
						attribute2 =  "100"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==2){
						attribute1 =  "00"+sfontsize+attribute1.substring(4);
						attribute2 =  "10"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==3){
						attribute1 =  "0"+sfontsize+attribute1.substring(4);
						attribute2 =  "1"+sfontsize+"002"+attribute2.substring(7);
					}					
					line=line.trim();
					line="$!mo{!mbox{"+line+"}}$";
					title.parsetext(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, line, Header.leftsidemargin , ypos, tf, attribute2, attribute1, false, 0.0f);
    			  		
					float adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(i))/2;
					for (int ii=0;ii<=SuperBlock.blockxpos.get(i+tid2).size()-1;ii++){
						SuperBlock.blockxpos.get(i+tid2).set(ii,SuperBlock.blockxpos.get(i+tid2).get(ii)+adjustx);
					}
					error.put(tid, Parsetext.error.get(tid)); if (error.get(tid)){errormessage.put(tid, Parsetext.errormessage.get(tid)); return;};
					ypos=Parsetext.thisypos.get(tid);
					thisypos.put(tid,ypos);
					endofline=true;
				}
				else if (type=='x'){
					fontsize=Header.fontsize;
					sfontsize=Integer.toString(fontsize);
					if (sfontsize.length()==1){
						attribute1 =  "000"+sfontsize+attribute1.substring(4);
						attribute2 =  "100"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==2){
						attribute1 =  "00"+sfontsize+attribute1.substring(4);
						attribute2 =  "10"+sfontsize+"002"+attribute2.substring(7);
					} else if (sfontsize.length()==3){
						attribute1 =  "0"+sfontsize+attribute1.substring(4);
						attribute2 =  "1"+sfontsize+"002"+attribute2.substring(7);
					}					
					line=line.trim();
					line="$!mbox{"+line+"}$";
					title.parsetext(canvas, block, paragraphblock, tid, containerwidth, containerheight, superblocknumber, superblock, line, Header.leftsidemargin , ypos, tf, attribute2, attribute1, false, 0.0f);
    			  		
					float adjustx=(viewportwidth-SuperBlock.superblocklinewidth.get(tid).get(i))/2;
					for (int ii=0;ii<=SuperBlock.blockxpos.get(i+tid2).size()-1;ii++){
						SuperBlock.blockxpos.get(i+tid2).set(ii,SuperBlock.blockxpos.get(i+tid2).get(ii)+adjustx);
					}
					error.put(tid, Parsetext.error.get(tid)); if (error.get(tid)){errormessage.put(tid, Parsetext.errormessage.get(tid)); return;};
					ypos=Parsetext.thisypos.get(tid);
					thisypos.put(tid,ypos);
					endofline=true;
				}
				if(j==0){endofline=true;}
			}
			thisypos.put(tid,ypos+20);
         	}
			SuperBlock.titleendline.put(tid, SuperBlock.superblocklinenumber.get(tid));
			SuperBlock.titleheight.put(tid,thisypos.get(tid)-ypos2+SuperBlock.superblocklineheight.get(0).get(0)-SuperBlock.superblocklinedepth.get(0).get(0));
		}
	}
