/*
    This application will use a stand-alone DLL.

    This allows you to compile this application with other Win32 compilers.
*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>

/*
    Emx 0.9c does not understand WINAPI inside a typedef definition (stack).
    The function call_dll_func() restores the stack.

    NT09c does not contain this error.
*/

typedef int WINAPI (*DLLFUNC) (void);

int call_dll_func(DLLFUNC func)
{
    return (*func) ();
}

int main(int argc, char **argv)
{
    HINSTANCE hLib;		/* handle of the DLL */
    DLLFUNC lpfnDllTest;        /* address of DLL function */

    hLib = LoadLibrary("dllso.dll");
    if (!hLib) {
	DWORD err = GetLastError();
	printf("Cannot load dll fails err=0x%lX = %ld\n", err, err);
	exit(1);
    }

    lpfnDllTest = (DLLFUNC) GetProcAddress(hLib, "DllTest");
    if (!lpfnDllTest) {
	printf("Error: GetProcAddress(Maximum)\n");
	exit(1);
    }

    printf("APP: dll returns %d\n", call_dll_func(lpfnDllTest));

    FreeLibrary(hLib);

    return 0;
}
