/* chmod.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"
#include <string.h>

int __chmod(const char *name, int flag, int attr)
{
    char fname[512];

    if (flag < 0 || flag > 1)
      return _rsxnt_errno(EINVAL);

    /* check pipe */
    if (strncmp(name, "/pipe/", 6) == 0 || strncmp(name, "\\pipe\\", 6) == 0)
      return _rsxnt_errno(ENOENT);

    _rsxnt_truncate_name (fname, name);

    if (_rsxnt_get_process_ptr()->bConsoleApp)
	OemToChar(fname, fname);

    if (flag == 0) {
	DWORD attr = GetFileAttributes(fname);
	if (attr == 0xffffffff)
	    return _rsxnt_get_last_errno();
	else
	    return (attr & 0x7f);
    } else {
	if (!attr)
	    attr = FILE_ATTRIBUTE_NORMAL;
	if (SetFileAttributes(fname, attr) == FALSE)
	    return _rsxnt_get_last_errno();
	else
	    return 0;
    }
}
