
/* ANIMAL.C --- Animate malloc operation. */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <graphics.h>

typedef unsigned long addr;

void get_arena(FILE *f, addr *lo_rtn, addr *hi_rtn)
{
  addr base, lo, hi;
  unsigned len, i;
  char c;

  lo = ~0;
  hi = 0;
  i = 0;
  while (fscanf(f, "%c%lu %u", &c, &base, &len) != EOF) {
    if (++i % 100 == 0)
      printf(".");
    if (base < lo)
      lo = base;
    if (base + len - 1 > hi)
      hi = base + len - 1;
  }
  *lo_rtn = lo;
  *hi_rtn = hi;
}

#define NSEGS 30
#define SEG_SEP 16
#define SEG_HT 8

void draw_seg(int malloc_p, double start, double end)
{
  int seg, x0, x1, y0;

  if ((int)(start) == (int)(end - 1e-8)) {
    seg = start;
    x0 = (start - seg) * getmaxx();
    x1 = (end - seg) * getmaxx();
    y0 = seg * SEG_SEP;
    setfillstyle(malloc_p ? SOLID_FILL : EMPTY_FILL, EGA_WHITE);
    bar(x0, y0, x1, y0 + (SEG_HT-1));
  }
  else {
    draw_seg(malloc_p, start, ceil(start));
    start = ceil(start);
    while (start < end) {
      draw_seg(malloc_p, start, min(end, start + 1));
      start = start + 1;
    }
  }
}

void animate(FILE *f, addr lo, addr hi)
{
  addr base, delta;
  unsigned len;
  char c;

  delta = hi - lo;
  while (fscanf(f, "%c%lu %u\n", &c, &base, &len) != EOF) {
    draw_seg(c == 'm', NSEGS * (double)(base - lo)/delta,
		NSEGS * (double)(base + len - 1 - lo)/delta);
    delay(50);
  }
}

int main(void)
{
  FILE *f;
  addr lo, hi;
  int gdriver, gmode, errorcode;

  if ((f = fopen("malloc.trc", "r")) == NULL) {
    fprintf(stderr, "can't open trace file\n");
    return 1;
  }

  get_arena(f, &lo, &hi);
  rewind(f);
  gdriver = DETECT;
  
  initgraph(&gdriver, &gmode, "\\tc\\bgi");
  errorcode = graphresult();
  if (errorcode != grOk)
    return 1;

  animate(f, lo, hi);
  closegraph();
  return 0;
}
