unit VFParm;
{$I option.pas}
interface
uses Dos, VFDcl, VFString;

function  ReturnParm(var id : char) : string;
function  OneParmMore : boolean;

implementation

const InitParmMode : boolean = false;
var   StrParm : string;

const MaxFile = 5;
var PFile    : array [1..MaxFile] of text;
    FromFile : byte;

procedure InitVFParm;
var i, N : integer;
begin
     if InitParmMode then exit;
     StrParm:=GetEnv('VFCOMB');
     N:=ParamCount;
     for i:=1 to N do StrParm:=StrParm+' '+ParamStr(i);
     FromFile:=0;
     InitParmMode:=true;
end; {InitVFParm}

function OneParmMore : boolean;
begin
    if not InitParmMode then InitVFParm;
    if FromFile > 0 then OneParmMore:=true
       else OneParmMore:=(StrParm <> '') and (StrParm <> ' ');
end; {OneParmMore}

function ReturnParm(var id : char) : string;
var s, ss : string;
    i, kk : integer;
label LLL;
begin

     if not InitParmMode then InitVFParm;

LLL:
     s:='';
     while (s = '') do
     begin
          if FromFile > 0 then
          begin
               if eof(PFile[FromFile]) then
               begin
                    close(PFile[FromFile]);
                    FromFile:=FromFile-1;
               end
               else begin
                    readln(PFile[FromFile],s);
                    while (ord(s[0]) > 0) and (s[1] = ' ') do delete(s,1,1);
                    i:=pos(' ',s); if i > 0 then s[0]:=char(i);
                    if (s = '') or (s[1] in ['%',';','*']) then goto LLL;
               end;
          end
          else begin
               s:=GetFragmString(StrParm);
               if (s = '') or (s = ' ') then
               begin
                  id:=' '; ReturnParm:='';
                  exit;
               end;
          end;
     end; {while}

     kk:=ord(s[0]);
     {--- s:=UpCaseString(s); ---}

     {--- Check for @file construction ---}
     if s[1] = '@' then
     begin
          if FromFile >= MaxFile then
          begin
             ErrorLog('*** Error: "@file" ('+s+') is nested too deeply');
          end
          else begin
             if kk < 2 then
             begin
                  ErrorLog('*** Warning: "@file" without file name')
             end
             else begin
                  ss:=copy(s,2,kk-1);
                  FromFile:=FromFile+1;
                  assign(PFile[FromFile],ss);
                  {$I-} reset(PFile[FromFile]); {$I+}
                  if IOResult <> 0 then
                  begin
                     ErrorLog('*** Error: File (@'+ss+') does not exist');
                     FromFile:=FromFile-1;
                  end;
             end;
          end;
          goto LLL;
     end;

     {--- Check for option name ---}
     if s[1] in ['/','-','+','!'] then
     begin
          if kk < 2 then
          begin
               ErrorLog('*** Error: parameter absent ('+s+')');
               goto LLL;
          end;
          id:=s[2];
          if kk < 3 then
          begin
               ss:='';
          end
          else if s[3] in [':','='] then
          begin
               if kk < 4 then ss:=''
                         else ss:=copy(s,4,kk-3);
          end
          else begin
               ss:=copy(s,3,kk-2);
          end;
     end
     else begin
          id:=' '; ss:=s;
     end;

     ReturnParm:=ss;


end; {ReturnParm}



end.

