/*
 * Decompiled with CFR 0.152.
 */
package nts.base;

import java.io.Serializable;
import nts.base.BinFraction;
import nts.base.BytePar;
import nts.base.Dimen;

public class Glue
implements Serializable {
    public static final byte NORMAL = 0;
    public static final byte FIL = 1;
    public static final byte FILL = 2;
    public static final byte FILLL = 3;
    public static final byte MAX_ORDER = 3;
    public static final Glue NULL;
    public static final Glue ZERO;
    private final Dimen dimen;
    private final Dimen stretch;
    private final byte strOrder;
    private final Dimen shrink;
    private final byte shrOrder;

    public Dimen getDimen() {
        return this.dimen;
    }

    public Dimen getStretch() {
        return this.stretch;
    }

    public Dimen getShrink() {
        return this.shrink;
    }

    public byte getStrOrder() {
        return this.strOrder;
    }

    public byte getShrOrder() {
        return this.shrOrder;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String unit) {
        StringBuffer buf = new StringBuffer(80);
        buf.append(this.dimen.toString());
        if (unit != null) {
            buf.append(unit);
        }
        if (!this.stretch.isZero()) {
            Glue.append(buf.append(" plus "), this.stretch, this.strOrder, unit);
        }
        if (!this.shrink.isZero()) {
            Glue.append(buf.append(" minus "), this.shrink, this.shrOrder, unit);
        }
        return buf.toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public static StringBuffer append(StringBuffer buf, Dimen val, byte ord, String unit) {
        block5: {
            byte by;
            block4: {
                buf.append(val.toString());
                if (ord < 0 || ord > 3) {
                    buf.append("foul");
                    return buf;
                }
                if (ord <= 0) {
                    if (unit == null) return buf;
                    buf.append(unit);
                    return buf;
                }
                buf.append("fil");
                if (!true) break block4;
                by = ord;
                ord = (byte)(by - 1);
                if (by <= 1) break block5;
            }
            do {
                buf.append('l');
                by = ord;
                ord = (byte)(by - 1);
            } while (by > 1);
        }
        return buf;
    }

    public static String toString(Dimen val, byte ord, String unit) {
        return Glue.append(new StringBuffer(30), val, ord, unit).toString();
    }

    public static String toString(Dimen val, byte ord) {
        return Glue.toString(val, ord, null);
    }

    public static Glue valueOf(Dimen d, Dimen p, byte po, Dimen m, byte mo) {
        if (p.isZero()) {
            po = 0;
        }
        if (m.isZero()) {
            mo = 0;
        }
        return new Glue(d, p, po, m, mo);
    }

    public static Glue valueOf(Dimen d, Dimen p, Dimen m) {
        return new Glue(d, p, 0, m, 0);
    }

    public static Glue valueOf(Dimen d) {
        return new Glue(d, Dimen.ZERO, 0, Dimen.ZERO, 0);
    }

    public boolean isZero() {
        return this.dimen.isZero() && this.stretch.isZero() && this.shrink.isZero();
    }

    public Glue negative() {
        return Glue.valueOf(this.dimen.negative(), this.stretch.negative(), this.strOrder, this.shrink.negative(), this.shrOrder);
    }

    private static Dimen addParts(Dimen x, Dimen y, byte xo, BytePar yo) {
        if (x.isZero()) {
            xo = 0;
        }
        if (xo == yo.get()) {
            return x.plus(y);
        }
        if (xo < yo.get() && !y.isZero()) {
            return y;
        }
        yo.set(xo);
        return x;
    }

    public Glue plus(Glue g) {
        BytePar strO = new BytePar(g.strOrder);
        BytePar shrO = new BytePar(g.shrOrder);
        Dimen str = Glue.addParts(this.stretch, g.stretch, this.strOrder, strO);
        Dimen shr = Glue.addParts(this.shrink, g.shrink, this.shrOrder, shrO);
        return Glue.valueOf(this.dimen.plus(g.dimen), str, strO.get(), shr, shrO.get());
    }

    public Glue plus(Dimen d) {
        return Glue.valueOf(this.dimen.plus(d), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue plus(int num) {
        return Glue.valueOf(this.dimen.plus(num), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue plus(int num, int den) {
        return Glue.valueOf(this.dimen.plus(num, den), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue plus(BinFraction x) {
        return Glue.valueOf(this.dimen.plus(x), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue plus(double d) {
        return Glue.valueOf(this.dimen.plus(d), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue minus(Glue g) {
        return this.plus(g.negative());
    }

    public Glue minus(Dimen d) {
        return Glue.valueOf(this.dimen.minus(d), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue minus(int num) {
        return Glue.valueOf(this.dimen.minus(num), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue minus(int num, int den) {
        return Glue.valueOf(this.dimen.minus(num, den), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue minus(BinFraction x) {
        return Glue.valueOf(this.dimen.minus(x), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue minus(double d) {
        return Glue.valueOf(this.dimen.minus(d), this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue times(Dimen d) {
        return Glue.valueOf(this.dimen.times(d), this.stretch.times(d), this.strOrder, this.shrink.times(d), this.shrOrder);
    }

    public Glue times(int num) {
        return Glue.valueOf(this.dimen.times(num), this.stretch.times(num), this.strOrder, this.shrink.times(num), this.shrOrder);
    }

    public Glue times(int num, int den) {
        return Glue.valueOf(this.dimen.times(num, den), this.stretch.times(num, den), this.strOrder, this.shrink.times(num, den), this.shrOrder);
    }

    public Glue times(BinFraction x) {
        return Glue.valueOf(this.dimen.times(x), this.stretch.times(x), this.strOrder, this.shrink.times(x), this.shrOrder);
    }

    public Glue times(double d) {
        return Glue.valueOf(this.dimen.times(d), this.stretch.times(d), this.strOrder, this.shrink.times(d), this.shrOrder);
    }

    public Glue timesTheFinite(Dimen d) {
        return Glue.valueOf(this.dimen.times(d), this.strOrder == 0 ? this.stretch.times(d) : this.stretch, this.strOrder, this.shrOrder == 0 ? this.shrink.times(d) : this.shrink, this.shrOrder);
    }

    public Glue over(Dimen d) {
        return Glue.valueOf(this.dimen.over(d), this.stretch.over(d), this.strOrder, this.shrink.over(d), this.shrOrder);
    }

    public Glue over(int num) {
        return Glue.valueOf(this.dimen.over(num), this.stretch.over(num), this.strOrder, this.shrink.over(num), this.shrOrder);
    }

    public Glue over(int num, int den) {
        return Glue.valueOf(this.dimen.over(num, den), this.stretch.over(num, den), this.strOrder, this.shrink.over(num, den), this.shrOrder);
    }

    public Glue over(BinFraction x) {
        return Glue.valueOf(this.dimen.over(x), this.stretch.over(x), this.strOrder, this.shrink.over(x), this.shrOrder);
    }

    public Glue over(double d) {
        return Glue.valueOf(this.dimen.over(d), this.stretch.over(d), this.strOrder, this.shrink.over(d), this.shrOrder);
    }

    public Glue resizedCopy(Dimen d) {
        return Glue.valueOf(d, this.stretch, this.strOrder, this.shrink, this.shrOrder);
    }

    public Glue withFiniteShrink() {
        return this.shrOrder == 0 ? this : Glue.valueOf(this.dimen, this.stretch, this.strOrder, this.shrink, (byte)0);
    }

    private Glue(Dimen d, Dimen p, byte po, Dimen m, byte mo) {
        this.dimen = d;
        this.stretch = p;
        this.strOrder = po;
        this.shrink = m;
        this.shrOrder = mo;
    }

    static {
        ZERO = new Glue(Dimen.ZERO, Dimen.ZERO, 0, Dimen.ZERO, 0);
    }

    public static interface Provider {
        public Glue getGlueValue();
    }
}

