/* open.c -- open a file.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <sys/fcntl.h>
#include <io.h>
#include "ansidecl.h"
#include "symlink.h"


int
DEFUN_VAR (symlink_open, (name, flags, VA_LIST),
const char *name AND
int flags AND
VA_DECL)
{
  char buffer[_MAX_PATH];
  int length, mode;

  length = _resolvlink (name, buffer, _MAX_PATH);
  if (length >= 0)
    {
      if (flags & O_CREAT)
	{
	  va_list arg;

	  VA_START (arg, flags);
	  mode = va_arg (arg, int);
	  va_end (arg);
	}
      else
	mode = 0;

      return (open (buffer, flags, mode));
    }

  return (-1);
}
