/* symlink/cdefs.h -- this file is part of the SYMLINK Library.

   Copyright (C) 1994, 1995 Ralph Schleicher  */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#ifndef	_SYMLINK_CDEFS_H
#define	_SYMLINK_CDEFS_H


#if defined (__STDC__) || defined (__cplusplus)

#define	__PROTO(arg)	arg

#else /* not __STDC__ and not __cplusplus */

#define	__PROTO(arg)	()

#ifdef void
#undef void
#endif
#define void

#ifdef const
#undef const
#endif
#define	const

#ifdef signed
#undef signed
#endif
#define	signed

#ifdef volatile
#undef volatile
#endif
#define	volatile

#endif /* not __STDC__ and not __cplusplus */


#if defined (__STDC__)

#define	__CONCAT(x,y)	x ## y
#define	__STRING(x)	#x

#else /* not __STDC__ */

#define	__CONCAT(x,y)	x/**/y
#define	__STRING(x)	"x"

#endif /* not __STDC__ */


#if defined (__cplusplus)

#define	__BEGIN_DECLS	extern "C" {
#define	__END_DECLS	}

#else /* not __cplusplus */

#define	__BEGIN_DECLS
#define	__END_DECLS

#endif /* not __cplusplus */


#endif /* not _SYMLINK_CDEFS_H */
