/********************************************************************
*
* This file is part of the TeXnicCenter-system
*
* Copyright (C) 1999-2000 Sven Wiegand
* Copyright (C) 2000-$CurrentYear$ ToolsCenter
* 
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation; either version 2 of
* the License, or (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
* If you have further questions or if you want to support
* further TeXnicCenter development, visit the TeXnicCenter-homepage
*
*    http://www.ToolsCenter.org
*
*********************************************************************/

/********************************************************************
*
* $Id: OutputWizardViewer.h,v 1.5 2003/09/02 08:50:35 niteria Exp $
*
********************************************************************/

#if !defined(AFX_OUTPUTWIZARDVIEWER_H__627C2BE6_5B16_11D4_A222_006097239934__INCLUDED_)
#define AFX_OUTPUTWIZARDVIEWER_H__627C2BE6_5B16_11D4_A222_006097239934__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "EditMenuButtonOpt.h"

/**
This property page is part of the output wizard (COutputWizard) and
requests the user to specify the properties of a file-type-specific
viewer.

@ingroup dialogs
@ingroup profiles

@author Sven Wiegand
*/
class COutputWizardViewer : public CPropertyPage
{
	DECLARE_DYNCREATE(COutputWizardViewer)

// Construction/Destruction
public:
	/**
	Constructs a page for the specified dialog template.
	*/
	COutputWizardViewer(UINT unIDTemplate = -1);
	virtual ~COutputWizardViewer();


// Overridings
protected:
	//{{AFX_VIRTUAL(COutputWizardViewer)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

// Message Handlers
protected:
	//{{AFX_MSG(COutputWizardViewer)
	afx_msg void OnViewerBrowse();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

// Dialog Data
public:
	//{{AFX_DATA(COutputWizardViewer)
	enum { IDD = IDD_OUTPUTWIZARD_DVIVIEWER };
	CPersistPosEdit	m_wndFWSearch;
	CEditMenuButtonOpt	m_wndViewerPHBtn;
	CString	m_strForwardSearchOption;
	CString	m_strPath;
	CString	m_strSingleInstanceOption;
	//}}AFX_DATA

// Attributes
protected:
	/** 
	Stores the current cursor position of the 
	m_wndForwardSearchOptionEdit.
	*/
	struct tagSelection
	{
		int nStart, nEnd;
	} m_selForwardSearchOptionEdit;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // AFX_OUTPUTWIZARDVIEWER_H__627C2BE6_5B16_11D4_A222_006097239934__INCLUDED_
