@q file: rc.w@>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>
@q output wrc.cpp@>
@** Raw character mapper. 
Maps an 8 bit character into the raw character object.
This is the raw character part of a grammar's terminal alphabet.
To provide some performance, a static pool of objects is used instead of trashing
malloc memory manager.
Though it's a fixed size defined by |SIZE_RC_MALLOC| an overflow test 
at runtime throws an error if the memory pool is exhausted.
All the raw character objects are of same size.
Their differences comes in their genes: blue eyes,
|id__|, |enumerated_id__|, and delete attributes.
It is the same dog with the same spots of color
being called by a different nickname.
To improve startup performance where the array was being
initialized to the default ctor layout that actually was useless, 
|CAbs_lr1_sym|'s default ctor has been eliminated.
Now a raw character pool is used with casting to the newly minted |CAbs_lr1_sym|.

Output is directed to |wrc.cpp|.
@<Struct...@>+=
struct rc_map{
	enum rc_size{rc_size_=ASCII_8_BIT+1};
	yacco2::CAbs_lr1_sym*
	 map_char_to_raw_char_sym(yacco2::UINT Char,yacco2::UINT File,yacco2::UINT Pos
	 ,UINT* Line_no,UINT* Pos_in_line);
static char array_chr_sym__[SIZE_RC_MALLOC];
static INT current_rc_malloc_sub__;
static yacco2::KCHARP chr_literal__[ASCII_8_BIT];
};
@*2 Set up Raw characters malloc variables.
@<accrue rc code@>= // acrue rc code
int yacco2::rc_map::current_rc_malloc_sub__(-1);
char yacco2::rc_map::array_chr_sym__[SIZE_RC_MALLOC];
yacco2::KCHARP yacco2::rc_map::chr_literal__[ASCII_8_BIT]=
{"\x00","\x01","\x02","\x03","\x04","\x05","\x06","\x07","\x08","\x09","\x0a"
,"\x0b","\x0c","\x0d","\x0e","\x0f"
,"\x10","\x11","\x12","\x13","\x14","\x15","\x16","\x17","\x18","\x19","\x1a"
,"\x1b","\x1c","\x1d","\x1e","\x1f"
,"\x20","\x21","\x22","\x23","\x24","\x25","\x26","\x27","\x28","\x29","\x2a"
,"\x2b","\x2c","\x2d","\x2e","\x2f"
,"\x30","\x31","\x32","\x33","\x34","\x35","\x36","\x37","\x38","\x39","\x3a"
,"\x3b","\x3c","\x3d","\x3e","\x3f"
,"\x40","\x41","\x42","\x43","\x44","\x45","\x46","\x47","\x48","\x49","\x4a"
,"\x4b","\x4c","\x4d","\x4e","\x4f"
,"\x50","\x51","\x52","\x53","\x54","\x55","\x56","\x57","\x58","\x59","\x5a"
,"\x5b","\x5c","\x5d","\x5e","\x5f"
,"\x60","\x61","\x62","\x63","\x64","\x65","\x66","\x67","\x68","\x69","\x6a"
,"\x6b","\x6c","\x6d","\x6e","\x6f"
,"\x70","\x71","\x72","\x73","\x74","\x75","\x76","\x77","\x78","\x79","\x7a"
,"\x7b","\x7c","\x7d","\x7e","\x7f"
,"\x80","\x81","\x82","\x83","\x84","\x85","\x86","\x87","\x88","\x89","\x8a"
,"\x8b","\x8c","\x8d","\x8e","\x8f"
,"\x90","\x91","\x92","\x93","\x94","\x95","\x96","\x97","\x98","\x99","\x9a"
,"\x9b","\x9c","\x9d","\x9e","\x9f"
,"\xa0","\xa1","\xa2","\xa3","\xa4","\xa5","\xa6","\xa7","\xa8","\xa9","\xaa"
,"\xab","\xac","\xad","\xae","\xaf"
,"\xb0","\xb1","\xb2","\xb3","\xb4","\xb5","\xb6","\xb7","\xb8","\xb9","\xba"
,"\xbb","\xbc","\xbd","\xbe","\xbf"
,"\xc0","\xc1","\xc2","\xc3","\xc4","\xc5","\xc6","\xc7","\xc8","\xc9","\xca"
,"\xcb","\xcc","\xcd","\xce","\xcf"
,"\xd0","\xd1","\xd2","\xd3","\xd4","\xd5","\xd6","\xd7","\xd8","\xd9","\xda"
,"\xdb","\xdc","\xdd","\xde","\xdf"
,"\xe0","\xe1","\xe2","\xe3","\xe4","\xe5","\xe6","\xe7","\xe8","\xe9","\xea"
,"\xeb","\xec","\xed","\xee","\xef"
,"\xf0","\xf1","\xf2","\xf3","\xf4","\xf5","\xf6","\xf7","\xf8","\xf9","\xfa"
,"\xfb","\xfc","\xfd","\xfe","\xff"
};

@*2 Output rc code.
@(wrc.cpp@>=
@<copyright notice@>;
@<iyacco2@>;
@<irc@>;
@<ilrk@>;
using namespace NS_yacco2_characters;
@<accrue rc code@>;

@*2 Map raw character to character symbol.\fbreak
Place line detection by line feed.
Call of this method requires the line number and character position.
It determines the line boundary and augments their values.
@<accrue rc code@>+=
yacco2::CAbs_lr1_sym* 
yacco2::rc_map::
map_char_to_raw_char_sym@/
(yacco2::UINT Char,yacco2::UINT File_no,yacco2::UINT Pos,UINT* Line_no,UINT* Pos_in_line){
map_char_to_symbol:@/
@<Validate File no...@>;
	if(Char >= rc_size_){
      @<Error bad character mapping@>;
      return 0;
	}
    @<Trace raw characters@>;
    if(Char == EOF_CHAR_SUB){
     yacco2::PTR_LR1_eog__->tok_co_ords__.external_file_id__= File_no;
     yacco2::PTR_LR1_eog__->tok_co_ords__.rc_pos__= Pos;
    yacco2::PTR_LR1_eog__->set_line_no_and_pos_in_line(*Line_no,1);     
     return yacco2::PTR_LR1_eog__;
     }
    @<malloc raw characters from static...@>;
     ++(*Pos_in_line);
    sym->set_line_no_and_pos_in_line(*Line_no,*Pos_in_line);     
    if(Char == LINE_FEED){// set for next char
      ++(*Line_no);
      *Pos_in_line = START_CHAR_POS;
    }
	return sym;
}

@*2 Malloc raw characters from static pool instead of newing of Malloc.\fbreak
Note: the raw character pool used to eliminate the default
|CAbs_lr1_sym| ctor initialization of the array at start up time. 
Now it's just a raw cess pool waiting to evolve.
@<malloc raw characters from static pool instead of newing@>=
++rc_map::current_rc_malloc_sub__;
long rc_sub = current_rc_malloc_sub__*SIZE_CAbs_lr1_sym;
if(rc_sub > SIZE_RC_MALLOC){
  @<Error no more raw character storage@>;
}
CAbs_lr1_sym* sym = (CAbs_lr1_sym*)&rc_map::array_chr_sym__[rc_sub];
sym->id__ = rc_map::chr_literal__[Char];
sym->enumerated_id__ = Char + START_OF_RC_ENUM;
sym->tok_co_ords__.external_file_id__ = File_no;
sym->tok_co_ords__.rc_pos__ = Pos;

@<|create_set_entry for Rc|@>;